/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.icongenerator.java2d;

import com.sshtools.icongenerator.AwesomeIcon;
import com.sshtools.icongenerator.IconBuilder;
import com.sshtools.icongenerator.IconUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Java2DIconCanvas {
    private static float DEFAULT_SHRINK_FACTOR = 0.8f;
    private static Font iconFont;
    private Paint textPaint;
    private Paint borderPaint;
    private String text;
    private RectangularShape shape;
    private RectangularShape borderShape;
    private Rectangle2D.Float bounds;
    private Font font;
    private Stroke borderStroke;
    private Stroke textStroke;
    private int fixedFontSize;
    private Paint backgroundPaint;
    private float border;
    private float shrinkFactor = DEFAULT_SHRINK_FACTOR;
    private boolean isIcon;

    public Java2DIconCanvas(IconBuilder builder) {
        this.bounds = new Rectangle2D.Float(0.0f, 0.0f, builder.width(), builder.height());
        switch (builder.computedShape()) {
            case ROUNDED: {
                this.shape = new RoundRectangle2D.Float();
                ((RoundRectangle2D)this.shape).setRoundRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, builder.radius(), builder.radius());
                break;
            }
            case ROUND: {
                this.shape = new Ellipse2D.Float();
                this.shape.setFrame(this.bounds);
                this.shrinkFactor *= 0.85f;
                break;
            }
            default: {
                this.shape = new Rectangle2D.Float();
                this.shape.setFrame(this.bounds);
            }
        }
        int bg = builder.computedColor();
        Color color = new Color(bg);
        this.backgroundPaint = color;
        if (builder.backgroundOpacity() != 255) {
            this.backgroundPaint = new Color(color.getRed(), color.getGreen(), color.getBlue(), builder.backgroundOpacity());
        }
        this.border = builder.border();
        if (this.border > 0.0f) {
            this.borderPaint = new Color(builder.computedBorderColor());
            Rectangle2D.Float rect = new Rectangle2D.Float(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            rect.x += this.border / 2.0f;
            rect.y += this.border / 2.0f;
            rect.width -= this.border;
            rect.height -= this.border;
            if (this.shape instanceof RoundRectangle2D) {
                this.borderShape = new RoundRectangle2D.Float(rect.x, rect.y, rect.width, rect.height, builder.radius(), builder.radius());
            } else if (this.shape instanceof Ellipse2D) {
                this.borderShape = new Ellipse2D.Float();
                this.borderShape.setFrame(rect);
            } else {
                this.borderShape = new Rectangle2D.Float();
                this.borderShape.setFrame(rect);
            }
            this.borderStroke = new BasicStroke(this.border);
        }
        this.fixedFontSize = builder.fontSize();
        this.textStroke = new BasicStroke(Math.max(1.0f, this.border));
        this.textPaint = new Color(builder.computedTextColor(bg));
        this.bounds.setRect(this.bounds.x + this.border, this.bounds.y + this.border, this.bounds.width - this.border * 2.0f, this.bounds.height - this.border * 2.0f);
        this.text = builder.computedText();
        AwesomeIcon awesomeIcon = builder.computedIcon();
        boolean bl = this.isIcon = awesomeIcon != null;
        if (this.isIcon) {
            this.text = awesomeIcon.toString();
            this.font = Java2DIconCanvas.getIconFont().deriveFont(builder.bold() ? 1 : 0, this.fixedFontSize == -1 ? (float)((int)this.bounds.width) : (float)this.fixedFontSize);
        } else {
            this.font = new Font(builder.fontName(), builder.bold() ? 1 : 0, this.fixedFontSize == -1 ? IconUtil.pixelsToPoints((int)((int)Math.min(this.bounds.width, this.bounds.height))) : this.fixedFontSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D canvas) {
        canvas = (Graphics2D)canvas.create();
        try {
            canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            canvas.setPaint(this.backgroundPaint);
            canvas.fill(this.shape);
            if (this.borderPaint != null) {
                this.drawBorder(canvas);
            }
            LineMetrics fm = this.font.getLineMetrics(this.text, 0, this.text.length(), canvas.getFontRenderContext());
            canvas.translate(this.bounds.x, this.bounds.y);
            GlyphVector gv = this.font.createGlyphVector(canvas.getFontRenderContext(), this.text);
            Rectangle textBounds = gv.getPixelBounds(canvas.getFontRenderContext(), 0.0f, 0.0f);
            float availableWidth = this.bounds.width;
            float availableHeight = this.bounds.height;
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            if (((RectangularShape)textBounds).getWidth() > (double)availableWidth) {
                scaleX = availableWidth / (float)((RectangularShape)textBounds).getWidth();
            }
            if (fm.getHeight() > availableHeight) {
                scaleY = availableHeight / fm.getHeight();
            }
            scaleX = scaleY = Math.min(scaleY, scaleX);
            canvas.translate(((double)this.bounds.width - ((RectangularShape)textBounds).getWidth() * (double)(scaleX *= this.shrinkFactor)) / 2.0, (availableHeight + (fm.getAscent() - fm.getDescent()) * (scaleY *= this.shrinkFactor)) / 2.0f);
            canvas.setPaint(this.textPaint);
            canvas.setStroke(this.textStroke);
            AffineTransform t = AffineTransform.getScaleInstance(scaleX, scaleY);
            AffineTransform saveAT = canvas.getTransform();
            canvas.transform(t);
            canvas.translate(-((RectangularShape)textBounds).getX(), 0.0);
            canvas.fill(gv.getOutline());
            canvas.setTransform(saveAT);
        }
        finally {
            canvas.dispose();
        }
    }

    private static Font getIconFont() {
        if (iconFont == null) {
            try {
                InputStream in;
                URL resource = AwesomeIcon.class.getResource("fontawesome-webfont.ttf");
                InputStream inputStream = in = resource == null ? null : resource.openStream();
                if (in == null) {
                    throw new RuntimeException("Could not find FontAwesome font. Make sure fontaweseome-webfont.ttf is on the CLASSPATH");
                }
                try {
                    iconFont = Font.createFont(0, in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to load icon font.", ioe);
            }
            catch (FontFormatException ffe) {
                throw new RuntimeException("Failed to load icon font.", ffe);
            }
        }
        return iconFont;
    }

    private void drawBorder(Graphics2D canvas) {
        Paint p = canvas.getPaint();
        Stroke s = canvas.getStroke();
        canvas.setPaint(this.borderPaint);
        canvas.setStroke(this.borderStroke);
        canvas.draw(this.borderShape);
        canvas.setPaint(p);
        canvas.setStroke(s);
    }
}

