/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.events;

import com.sshtools.events.Event;
import com.sshtools.events.EventListener;
import com.sshtools.events.EventService;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EventServiceImplementation
implements EventService {
    private static final EventService INSTANCE = new EventServiceImplementation();
    private final Hashtable<String, EventListener> keyedListeners;
    private Vector<EventListener> globalListeners = new Vector();

    protected EventServiceImplementation() {
        this.keyedListeners = new Hashtable();
    }

    public static EventService getInstance() {
        return INSTANCE;
    }

    public synchronized void addListener(String threadPrefix, EventListener listener) {
        if (threadPrefix.trim().equals("")) {
            this.globalListeners.addElement(listener);
        } else {
            this.keyedListeners.put(threadPrefix.trim(), listener);
        }
    }

    public synchronized void removeListener(String threadPrefix) {
        this.keyedListeners.remove(threadPrefix);
    }

    public synchronized void fireEvent(Event evt) {
        if (evt == null) {
            return;
        }
        Enumeration<EventListener> keys = this.globalListeners.elements();
        while (keys.hasMoreElements()) {
            EventListener mListener = keys.nextElement();
            try {
                mListener.processEvent(evt);
            }
            catch (Throwable throwable) {}
        }
        String sourceThread = Thread.currentThread().getName();
        Enumeration<String> keys2 = this.keyedListeners.keys();
        while (keys2.hasMoreElements()) {
            String key = keys2.nextElement();
            try {
                String prefix = "";
                if (sourceThread.indexOf(45) <= -1 || !key.startsWith(prefix = sourceThread.substring(0, sourceThread.indexOf(45)))) continue;
                EventListener mListener = this.keyedListeners.get(key);
                mListener.processEvent(evt);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addListener(EventListener listener) {
        this.addListener("", listener);
    }
}

