/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.SshKeyPair;
import java.io.IOException;

public class SshKeyPairGenerator {
    public static final String SSH1_RSA = "rsa1";
    public static final String SSH2_RSA = "ssh-rsa";
    public static final String SSH2_DSA = "ssh-dss";

    public static SshKeyPair generateKeyPair(String algorithm, int bits) throws IOException, SshException {
        if (!SSH2_RSA.equalsIgnoreCase(algorithm) && !SSH2_DSA.equalsIgnoreCase(algorithm)) {
            throw new IOException(algorithm + " is not a supported key algorithm!");
        }
        SshKeyPair pair = new SshKeyPair();
        pair = SSH2_RSA.equalsIgnoreCase(algorithm) ? ComponentManager.getInstance().generateRsaKeyPair(bits) : ComponentManager.getInstance().generateDsaKeyPair(bits);
        return pair;
    }
}

