/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sftp;

import com.sshtools.events.Event;
import com.sshtools.events.EventServiceImplementation;
import com.sshtools.logging.Log;
import com.sshtools.sftp.FileTransferProgress;
import com.sshtools.sftp.SftpFile;
import com.sshtools.sftp.SftpFileAttributes;
import com.sshtools.sftp.SftpMessage;
import com.sshtools.sftp.SftpStatusException;
import com.sshtools.sftp.TransferCancelledException;
import com.sshtools.ssh.Packet;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.SshSession;
import com.sshtools.ssh.SubsystemChannel;
import com.sshtools.ssh.message.MessageHolder;
import com.sshtools.util.Base64;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.UnsignedInteger32;
import com.sshtools.util.UnsignedInteger64;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpSubsystemChannel
extends SubsystemChannel {
    private String CHARSET_ENCODING = "ISO-8859-1";
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int OPEN_TEXT = 64;
    static final int STATUS_FX_OK = 0;
    static final int STATUS_FX_EOF = 1;
    static final int SSH_FXP_INIT = 1;
    static final int SSH_FXP_VERSION = 2;
    static final int SSH_FXP_OPEN = 3;
    static final int SSH_FXP_CLOSE = 4;
    static final int SSH_FXP_READ = 5;
    static final int SSH_FXP_WRITE = 6;
    static final int SSH_FXP_LSTAT = 7;
    static final int SSH_FXP_FSTAT = 8;
    static final int SSH_FXP_SETSTAT = 9;
    static final int SSH_FXP_FSETSTAT = 10;
    static final int SSH_FXP_OPENDIR = 11;
    static final int SSH_FXP_READDIR = 12;
    static final int SSH_FXP_REMOVE = 13;
    static final int SSH_FXP_MKDIR = 14;
    static final int SSH_FXP_RMDIR = 15;
    static final int SSH_FXP_REALPATH = 16;
    static final int SSH_FXP_STAT = 17;
    static final int SSH_FXP_RENAME = 18;
    static final int SSH_FXP_READLINK = 19;
    static final int SSH_FXP_SYMLINK = 20;
    static final int SSH_FXP_STATUS = 101;
    static final int SSH_FXP_HANDLE = 102;
    static final int SSH_FXP_DATA = 103;
    static final int SSH_FXP_NAME = 104;
    static final int SSH_FXP_ATTRS = 105;
    static final int SSH_FXP_EXTENDED = 200;
    static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static int MAX_VERSION = 4;
    int this_MAX_VERSION = 4;
    int version = -1;
    int serverVersion = -1;
    UnsignedInteger32 requestId = new UnsignedInteger32(0L);
    Hashtable<UnsignedInteger32, SftpMessage> responses = new Hashtable();
    SftpThreadSynchronizer sync = new SftpThreadSynchronizer();
    Hashtable<String, byte[]> extensions = new Hashtable();

    public SftpSubsystemChannel(SshSession session) throws SshException {
        super(session);
        this.this_MAX_VERSION = MAX_VERSION;
    }

    public SftpSubsystemChannel(SshSession session, int Max_Version) throws SshException {
        super(session);
        this.setThisMaxSftpVersion(Max_Version);
    }

    public static void setMaxSftpVersion(int MAX_VERSION) {
        SftpSubsystemChannel.MAX_VERSION = MAX_VERSION;
    }

    public void setThisMaxSftpVersion(int MAX_VERSION) {
        this.this_MAX_VERSION = MAX_VERSION;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getCanonicalNewline() throws SftpStatusException {
        if (this.version <= 3) {
            throw new SftpStatusException(8, "Newline setting not available for SFTP versions <= 3");
        }
        if (!this.extensions.containsKey("newline")) {
            return "\r\n".getBytes();
        }
        return this.extensions.get("newline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SshException, UnsupportedEncodingException {
        try {
            Packet packet = this.createPacket();
            packet.write(1);
            packet.writeInt(this.this_MAX_VERSION);
            this.sendMessage(packet);
            byte[] msg = this.nextMessage();
            if (msg[0] != 2) {
                this.close();
                throw new SshException("Unexpected response from SFTP subsystem.", 6);
            }
            ByteArrayReader bar = new ByteArrayReader(msg);
            try {
                bar.skip(1L);
                this.serverVersion = (int)bar.readInt();
                this.version = Math.min(this.serverVersion, MAX_VERSION);
                try {
                    while (bar.available() > 0) {
                        String name = bar.readString();
                        byte[] data = bar.readBinaryString();
                        this.extensions.put(name, data);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                bar.close();
            }
            if (this.version <= 3) {
                this.setCharsetEncoding("ISO-8859-1");
            } else {
                this.setCharsetEncoding("UTF8");
            }
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(6, (Throwable)ex);
        }
        catch (Throwable t) {
            throw new SshException(6, t);
        }
    }

    @Override
    public void close() throws IOException {
        this.responses.clear();
        super.close();
    }

    public void setCharsetEncoding(String charset) throws SshException, UnsupportedEncodingException {
        if (this.version == -1) {
            throw new SshException("SFTP Channel must be initialized before setting character set encoding", 4);
        }
        String test = "123456890";
        test.getBytes(charset);
        this.CHARSET_ENCODING = charset;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public String getCharsetEncoding() {
        return this.CHARSET_ENCODING;
    }

    public boolean supportsExtension(String name) {
        return this.extensions.containsKey(name);
    }

    public byte[] getExtension(String name) {
        return this.extensions.get(name);
    }

    public SftpMessage sendExtensionMessage(String request, byte[] requestData) throws SshException, SftpStatusException {
        try {
            UnsignedInteger32 id = this.nextRequestId();
            Packet packet = this.createPacket();
            packet.write(200);
            packet.writeUINT32(id);
            packet.writeString(request);
            this.sendMessage(packet);
            return this.getResponse(id);
        }
        catch (IOException ex) {
            throw new SshException(5, (Throwable)ex);
        }
    }

    public void changePermissions(SftpFile file, int permissions) throws SftpStatusException, SshException {
        SftpFileAttributes attrs = new SftpFileAttributes(this, 5);
        attrs.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(file, attrs);
    }

    public void changePermissions(String filename, int permissions) throws SftpStatusException, SshException {
        SftpFileAttributes attrs = new SftpFileAttributes(this, 5);
        attrs.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(filename, attrs);
    }

    public void changePermissions(String filename, String permissions) throws SftpStatusException, SshException {
        SftpFileAttributes attrs = new SftpFileAttributes(this, 5);
        attrs.setPermissions(permissions);
        this.setAttributes(filename, attrs);
    }

    public void setAttributes(String path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(9);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.write(attrs.toByteArray());
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
    }

    public void setAttributes(SftpFile file, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (file.getHandle() == null) {
            throw new SftpStatusException(100, "The handle is not an open file handle!");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(10);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(file.getHandle());
            msg.write(attrs.toByteArray());
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public UnsignedInteger32 postWriteRequest(byte[] handle, long position, byte[] data, int off, int len) throws SftpStatusException, SshException {
        if (data.length - off < len) {
            throw new IndexOutOfBoundsException("Incorrect data array size!");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(6);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(position);
            msg.writeBinaryString(data, off, len);
            this.sendMessage(msg);
            return requestId;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws SftpStatusException, SshException {
        this.getOKRequestStatus(this.postWriteRequest(handle, offset.longValue(), data, off, len));
    }

    public void performOptimizedWrite(byte[] handle, int blocksize, int outstandingRequests, InputStream in, int buffersize, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedWrite(handle, blocksize, outstandingRequests, in, buffersize, progress, 0L);
    }

    public void performOptimizedWrite(byte[] handle, int blocksize, int outstandingRequests, InputStream in, int buffersize, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        try {
            if (blocksize < 4096) {
                throw new SshException("Block size cannot be less than 4096", 4);
            }
            if (position < 0L) {
                throw new SshException("Position value must be greater than zero!", 4);
            }
            if (position > 0L && progress != null) {
                progress.progressed(position);
            }
            if (buffersize <= 0) {
                buffersize = blocksize;
            }
            byte[] buf = new byte[blocksize];
            long transfered = position;
            int buffered = 0;
            Vector<UnsignedInteger32> requests = new Vector<UnsignedInteger32>();
            in = new BufferedInputStream(in, buffersize);
            while ((buffered = in.read(buf)) != -1) {
                requests.addElement(this.postWriteRequest(handle, transfered, buf, 0, buffered));
                transfered += (long)buffered;
                if (progress != null) {
                    if (progress.isCancelled()) {
                        throw new TransferCancelledException();
                    }
                    progress.progressed(transfered);
                }
                if (requests.size() <= outstandingRequests) continue;
                UnsignedInteger32 requestId = (UnsignedInteger32)requests.elementAt(0);
                requests.removeElementAt(0);
                this.getOKRequestStatus(requestId);
            }
            Enumeration e = requests.elements();
            while (e.hasMoreElements()) {
                this.getOKRequestStatus((UnsignedInteger32)e.nextElement());
            }
            requests.removeAllElements();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (EOFException ex) {
            try {
                this.close();
            }
            catch (SshIOException ex1) {
                throw ex1.getRealException();
            }
            catch (IOException ex1) {
                throw new SshException(ex1.getMessage(), 6);
            }
            throw new SftpStatusException(7, "The SFTP channel terminated unexpectedly");
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
        catch (OutOfMemoryError ex) {
            throw new SshException("Resource Shortage: try reducing the local file buffer size", 4);
        }
    }

    public void performOptimizedRead(byte[] handle, long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedRead(handle, length, blocksize, out, outstandingRequests, progress, 0L);
    }

    public void performOptimizedRead(byte[] handle, long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Performing optimized read length=" + length + " postion=" + position + " blocksize=" + blocksize + " outstandingRequests=" + outstandingRequests);
        }
        if (length <= 0L) {
            length = Long.MAX_VALUE;
        }
        try {
            if (blocksize < 1 || blocksize > 32768) {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Blocksize to large for some SFTP servers, reseting to 32K");
                }
                blocksize = 32768;
            }
            if (position < 0L) {
                throw new SshException("Position value must be greater than zero!", 4);
            }
            byte[] tmp = new byte[blocksize];
            int i = this.readFile(handle, new UnsignedInteger64(0L), tmp, 0, tmp.length);
            if (i == -1) {
                return;
            }
            if ((long)i > position) {
                out.write(tmp, (int)position, (int)((long)i - position));
                length -= (long)i - position;
                position = i;
            }
            if (position + length <= (long)i) {
                return;
            }
            if (i < blocksize && length > (long)i) {
                blocksize = i;
            }
            tmp = null;
            long numBlocks = length / (long)blocksize;
            long osr = outstandingRequests;
            if (position > 0L && progress != null) {
                progress.progressed(position);
            }
            Vector<UnsignedInteger32> requests = new Vector<UnsignedInteger32>(outstandingRequests);
            long offset = position;
            if (numBlocks < osr) {
                osr = numBlocks + 1L;
            }
            if (osr <= 0L) {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "We calculated zero outstanding requests! numBlocks=" + numBlocks + " outstandingRequests=" + outstandingRequests + " blocksize=" + blocksize + " length=" + length + " position=" + position);
                }
                osr = 1L;
            }
            long expected = numBlocks + 2L;
            int completed = 0;
            long transfered = position;
            i = 0;
            while ((long)i < osr) {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Posting request for file offset " + offset);
                }
                requests.addElement(this.postReadRequest(handle, offset, blocksize));
                offset += (long)blocksize;
                if (progress != null && progress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                ++i;
            }
            do {
                UnsignedInteger32 requestId = (UnsignedInteger32)requests.elementAt(0);
                requests.removeElementAt(0);
                SftpMessage bar = this.getResponse(requestId);
                if (bar.getType() == 103) {
                    int dataLen = (int)bar.readInt();
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Get " + dataLen + " bytes of data");
                    }
                    out.write(bar.array(), bar.getPosition(), dataLen);
                    ++completed;
                    bar.dispose();
                    if (progress != null) {
                        progress.progressed(transfered += (long)dataLen);
                    }
                } else {
                    if (bar.getType() == 101) {
                        int status = (int)bar.readInt();
                        if (status == 1) {
                            if (Log.isDebugEnabled()) {
                                Log.debug(this, "Received file EOF");
                            }
                            return;
                        }
                        if (this.version >= 3) {
                            String desc = bar.readString().trim();
                            if (Log.isDebugEnabled()) {
                                Log.debug(this, "Received status " + desc);
                            }
                            throw new SftpStatusException(status, desc);
                        }
                        if (Log.isDebugEnabled()) {
                            Log.debug(this, "Received status " + status);
                        }
                        throw new SftpStatusException(status);
                    }
                    this.close();
                    throw new SshException("The server responded with an unexpected message", 6);
                }
                if (!requests.isEmpty() && (long)(completed + requests.size()) >= expected) continue;
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Posting request for file offset " + offset);
                }
                requests.addElement(this.postReadRequest(handle, offset, blocksize));
                offset += (long)blocksize;
            } while (progress == null || !progress.isCancelled());
            throw new TransferCancelledException();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (EOFException ex) {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Channel has reached EOF", ex);
            }
            try {
                this.close();
            }
            catch (SshIOException ex1) {
                throw ex1.getRealException();
            }
            catch (IOException ex1) {
                throw new SshException(ex1.getMessage(), 6);
            }
            throw new SftpStatusException(7, "The SFTP channel terminated unexpectedly");
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public void performSynchronousRead(byte[] handle, int blocksize, OutputStream out, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Performing synchronous read postion=" + position + " blocksize=" + blocksize);
        }
        if (blocksize < 1 || blocksize > 32768) {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Blocksize to large for some SFTP servers, reseting to 32K");
            }
            blocksize = 32768;
        }
        if (position < 0L) {
            throw new SshException("Position value must be greater than zero!", 4);
        }
        byte[] tmp = new byte[blocksize];
        UnsignedInteger64 offset = new UnsignedInteger64(position);
        if (position > 0L && progress != null) {
            progress.progressed(position);
        }
        try {
            int read;
            while ((read = this.readFile(handle, offset, tmp, 0, tmp.length)) > -1) {
                if (progress != null && progress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                out.write(tmp, 0, read);
                offset = UnsignedInteger64.add(offset, read);
                if (progress == null) continue;
                progress.progressed(offset.longValue());
            }
        }
        catch (IOException e) {
            throw new SshException(e);
        }
    }

    public UnsignedInteger32 postReadRequest(byte[] handle, long offset, int len) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(5);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeInt(len);
            this.sendMessage(msg);
            return requestId;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public int readFile(byte[] handle, UnsignedInteger64 offset, byte[] output, int off, int len) throws SftpStatusException, SshException {
        try {
            if (output.length - off < len) {
                throw new IndexOutOfBoundsException("Output array size is smaller than read length!");
            }
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(5);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.write(offset.toByteArray());
            msg.writeInt(len);
            this.sendMessage(msg);
            SftpMessage bar = this.getResponse(requestId);
            if (bar.getType() == 103) {
                byte[] msgdata = bar.readBinaryString();
                System.arraycopy(msgdata, 0, output, off, msgdata.length);
                return msgdata.length;
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (status == 1) {
                    return -1;
                }
                if (this.version >= 3) {
                    String desc = bar.readString().trim();
                    throw new SftpStatusException(status, desc);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public SftpFile getFile(String path) throws SftpStatusException, SshException {
        String absolute = this.getAbsolutePath(path);
        SftpFile file = new SftpFile(absolute, this.getAttributes(absolute));
        file.sftp = this;
        return file;
    }

    public String getAbsolutePath(SftpFile file) throws SftpStatusException, SshException {
        return this.getAbsolutePath(file.getFilename());
    }

    public void createSymbolicLink(String targetpath, String linkpath) throws SftpStatusException, SshException {
        if (this.version < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(20);
            msg.writeInt(requestId.longValue());
            msg.writeString(linkpath, this.CHARSET_ENCODING);
            msg.writeString(targetpath, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public String getSymbolicLinkTarget(String linkpath) throws SftpStatusException, SshException {
        if (this.version < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(19);
            msg.writeInt(requestId.longValue());
            msg.writeString(linkpath, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            SftpFile[] files = this.extractFiles(this.getResponse(requestId), null);
            return files[0].getAbsolutePath();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.getAbsolutePath("");
    }

    public String getAbsolutePath(String path) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(16);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            SftpMessage bar = this.getResponse(requestId);
            if (bar.getType() == 104) {
                SftpFile[] files = this.extractFiles(bar, null);
                if (files.length != 1) {
                    this.close();
                    throw new SshException("Server responded to SSH_FXP_REALPATH with too many files!", 6);
                }
                return files[0].getAbsolutePath();
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (this.version >= 3) {
                    String desc = bar.readString().trim();
                    throw new SftpStatusException(status, desc);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public int listChildren(SftpFile file, Vector<SftpFile> children) throws SftpStatusException, SshException {
        if (file.isDirectory()) {
            if (file.getHandle() == null && (file = this.openDirectory(file.getAbsolutePath())).getHandle() == null) {
                throw new SftpStatusException(4, "Failed to open directory");
            }
        } else {
            throw new SshException("Cannot list children for this file object", 4);
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(12);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(file.getHandle());
            this.sendMessage(msg);
            SftpMessage bar = this.getResponse(requestId);
            if (bar.getType() == 104) {
                SftpFile[] files = this.extractFiles(bar, file.getAbsolutePath());
                for (int i = 0; i < files.length; ++i) {
                    children.addElement(files[i]);
                }
                return files.length;
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (status == 1) {
                    return -1;
                }
                if (this.version >= 3) {
                    String desc = bar.readString().trim();
                    throw new SftpStatusException(status, desc);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    SftpFile[] extractFiles(SftpMessage bar, String parent) throws SshException {
        try {
            if (parent != null && !parent.endsWith("/")) {
                parent = parent + "/";
            }
            int count = (int)bar.readInt();
            SftpFile[] files = new SftpFile[count];
            String longname = null;
            for (int i = 0; i < files.length; ++i) {
                String shortname = bar.readString(this.CHARSET_ENCODING);
                if (this.version <= 3) {
                    longname = bar.readString(this.CHARSET_ENCODING);
                }
                files[i] = new SftpFile(parent != null ? parent + shortname : shortname, new SftpFileAttributes(this, bar));
                files[i].longname = longname;
                if (longname != null && this.version <= 3) {
                    try {
                        StringTokenizer t = new StringTokenizer(longname);
                        t.nextToken();
                        t.nextToken();
                        String username = t.nextToken();
                        String group = t.nextToken();
                        files[i].getAttributes().setUsername(username);
                        files[i].getAttributes().setGroup(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                files[i].setSFTPSubsystem(this);
            }
            return files;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public void recurseMakeDirectory(String path) throws SftpStatusException, SshException {
        if (path.trim().length() > 0) {
            try {
                SftpFile file = this.openDirectory(path);
                file.close();
            }
            catch (SshException ioe) {
                int idx = 0;
                do {
                    String tmp = (idx = path.indexOf(47, idx)) > -1 ? path.substring(0, idx + 1) : path;
                    try {
                        SftpFile file = this.openDirectory(tmp);
                        file.close();
                    }
                    catch (SshException ioe7) {
                        this.makeDirectory(tmp);
                    }
                } while (idx > -1);
            }
        }
    }

    public SftpFile openFile(String absolutePath, int flags) throws SftpStatusException, SshException {
        return this.openFile(absolutePath, flags, new SftpFileAttributes(this, 5));
    }

    public SftpFile openFile(String absolutePath, int flags, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (attrs == null) {
            attrs = new SftpFileAttributes(this, 5);
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(3);
            msg.writeInt(requestId.longValue());
            msg.writeString(absolutePath, this.CHARSET_ENCODING);
            msg.writeInt(flags);
            msg.write(attrs.toByteArray());
            this.sendMessage(msg);
            byte[] handle = this.getHandleResponse(requestId);
            SftpFile file = new SftpFile(absolutePath, null);
            file.setHandle(handle);
            file.setSFTPSubsystem(this);
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 26, true).addAttribute("FILE_NAME", file.getAbsolutePath()));
            return file;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    private String getSafeHandle(byte[] handle) {
        return Base64.encodeBytes(handle, 0, handle.length, true);
    }

    private byte[] getSafeHandle(String handle) {
        return Base64.decode(handle);
    }

    public SftpFile openDirectory(String path) throws SftpStatusException, SshException {
        String absolutePath = this.getAbsolutePath(path);
        SftpFileAttributes attrs = this.getAttributes(absolutePath);
        if (!attrs.isDirectory()) {
            throw new SftpStatusException(4, path + " is not a directory");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(11);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            byte[] handle = this.getHandleResponse(requestId);
            SftpFile file = new SftpFile(absolutePath, attrs);
            file.setHandle(handle);
            file.setSFTPSubsystem(this);
            return file;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    void closeHandle(byte[] handle) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(4);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public void closeFile(SftpFile file) throws SftpStatusException, SshException {
        if (file.getHandle() != null) {
            this.closeHandle(file.getHandle());
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 25, true).addAttribute("FILE_NAME", file.getAbsolutePath()));
            file.setHandle(null);
        }
    }

    public void removeDirectory(String path) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(15);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 29, true).addAttribute("DIRECTORY_PATH", path));
    }

    public void removeFile(String filename) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(13);
            msg.writeInt(requestId.longValue());
            msg.writeString(filename, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 28, true).addAttribute("FILE_NAME", filename));
    }

    public void renameFile(String oldpath, String newpath) throws SftpStatusException, SshException {
        if (this.version < 2) {
            throw new SftpStatusException(8, "Renaming files is not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(18);
            msg.writeInt(requestId.longValue());
            msg.writeString(oldpath, this.CHARSET_ENCODING);
            msg.writeString(newpath, this.CHARSET_ENCODING);
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 27, true).addAttribute("FILE_NAME", oldpath).addAttribute("FILE_NEW_NAME", newpath));
    }

    public SftpFileAttributes getAttributes(String path) throws SftpStatusException, SshException {
        return this.getAttributes(path, 17);
    }

    public SftpFileAttributes getLinkAttributes(String path) throws SftpStatusException, SshException {
        return this.getAttributes(path, 7);
    }

    protected SftpFileAttributes getAttributes(String path, int messageId) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(messageId);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            if (this.version > 3) {
                msg.writeInt(-2147483139L);
            }
            this.sendMessage(msg);
            SftpMessage bar = this.getResponse(requestId);
            return this.extractAttributes(bar);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    SftpFileAttributes extractAttributes(SftpMessage bar) throws SftpStatusException, SshException {
        try {
            if (bar.getType() == 105) {
                return new SftpFileAttributes(this, bar);
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (this.version >= 3) {
                    String msg = bar.readString().trim();
                    throw new SftpStatusException(status, msg);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message.", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public SftpFileAttributes getAttributes(SftpFile file) throws SftpStatusException, SshException {
        try {
            if (file.getHandle() == null) {
                return this.getAttributes(file.getAbsolutePath());
            }
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(8);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(file.getHandle());
            if (this.version > 3) {
                msg.writeInt(-2147483139L);
            }
            this.sendMessage(msg);
            return this.extractAttributes(this.getResponse(requestId));
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public void makeDirectory(String path) throws SftpStatusException, SshException {
        this.makeDirectory(path, new SftpFileAttributes(this, 2));
    }

    public void makeDirectory(String path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(14);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.write(attrs.toByteArray());
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    byte[] getHandleResponse(UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        try {
            SftpMessage bar = this.getResponse(requestId);
            if (bar.getType() == 102) {
                return bar.readBinaryString();
            }
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (this.version >= 3) {
                    String msg = bar.readString().trim();
                    throw new SftpStatusException(status, msg);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message!", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    public void getOKRequestStatus(UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        try {
            SftpMessage bar = this.getResponse(requestId);
            if (bar.getType() == 101) {
                int status = (int)bar.readInt();
                if (status == 0) {
                    return;
                }
                if (this.version >= 3) {
                    String msg = bar.readString().trim();
                    throw new SftpStatusException(status, msg);
                }
                throw new SftpStatusException(status);
            }
            this.close();
            throw new SshException("The server responded with an unexpected message!", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    SftpMessage getResponse(UnsignedInteger32 requestId) throws SshException {
        MessageHolder holder = new MessageHolder();
        while (holder.msg == null) {
            try {
                if (!this.sync.requestBlock(requestId, holder)) continue;
                SftpMessage msg = new SftpMessage(this.nextMessage());
                this.responses.put(new UnsignedInteger32(msg.getMessageId()), msg);
            }
            catch (InterruptedException e) {
                try {
                    this.close();
                }
                catch (SshIOException ex) {
                    throw ex.getRealException();
                }
                catch (IOException ex1) {
                    throw new SshException(ex1.getMessage(), 6);
                }
                throw new SshException("The thread was interrupted", 6);
            }
            catch (IOException ex) {
                throw new SshException(5, (Throwable)ex);
            }
            finally {
                this.sync.releaseBlock();
            }
        }
        return this.responses.remove(requestId);
    }

    UnsignedInteger32 nextRequestId() {
        this.requestId = UnsignedInteger32.add(this.requestId, 1);
        return this.requestId;
    }

    class SftpThreadSynchronizer {
        boolean isBlocking = false;

        SftpThreadSynchronizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestBlock(UnsignedInteger32 requestId, MessageHolder holder) throws InterruptedException {
            if (SftpSubsystemChannel.this.responses.containsKey(requestId)) {
                holder.msg = SftpSubsystemChannel.this.responses.get(requestId);
                return false;
            }
            SftpThreadSynchronizer sftpThreadSynchronizer = this;
            synchronized (sftpThreadSynchronizer) {
                boolean canBlock;
                boolean bl = canBlock = !this.isBlocking;
                if (SftpSubsystemChannel.this.responses.containsKey(requestId)) {
                    holder.msg = SftpSubsystemChannel.this.responses.get(requestId);
                    return false;
                }
                if (canBlock) {
                    this.isBlocking = true;
                } else {
                    this.wait();
                }
                return canBlock;
            }
        }

        public synchronized void releaseBlock() {
            this.isBlocking = false;
            this.notifyAll();
        }
    }
}

