/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.logging.Log;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentFactory;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.Digest;
import com.sshtools.ssh.components.SshCipher;
import com.sshtools.ssh.components.SshDsaPrivateKey;
import com.sshtools.ssh.components.SshDsaPublicKey;
import com.sshtools.ssh.components.SshHmac;
import com.sshtools.ssh.components.SshKeyPair;
import com.sshtools.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.ssh.components.SshRsaPrivateKey;
import com.sshtools.ssh.components.SshRsaPublicKey;
import com.sshtools.ssh.components.SshSecureRandomGenerator;
import com.sshtools.ssh.components.jce.AES128Cbc;
import com.sshtools.ssh.components.jce.AES128Ctr;
import com.sshtools.ssh.components.jce.AES192Cbc;
import com.sshtools.ssh.components.jce.AES192Ctr;
import com.sshtools.ssh.components.jce.AES256Cbc;
import com.sshtools.ssh.components.jce.AES256Ctr;
import com.sshtools.ssh.components.jce.AbstractDigest;
import com.sshtools.ssh.components.jce.AbstractHmac;
import com.sshtools.ssh.components.jce.AbstractJCECipher;
import com.sshtools.ssh.components.jce.ArcFour;
import com.sshtools.ssh.components.jce.ArcFour128;
import com.sshtools.ssh.components.jce.ArcFour256;
import com.sshtools.ssh.components.jce.BlowfishCbc;
import com.sshtools.ssh.components.jce.DiffieHellmanEcdhNistp256;
import com.sshtools.ssh.components.jce.DiffieHellmanEcdhNistp384;
import com.sshtools.ssh.components.jce.HmacMD5;
import com.sshtools.ssh.components.jce.HmacMD596;
import com.sshtools.ssh.components.jce.HmacSha1;
import com.sshtools.ssh.components.jce.HmacSha196;
import com.sshtools.ssh.components.jce.HmacSha256;
import com.sshtools.ssh.components.jce.HmacSha512;
import com.sshtools.ssh.components.jce.JCEAlgorithms;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.ssh.components.jce.MD5Digest;
import com.sshtools.ssh.components.jce.SHA1Digest;
import com.sshtools.ssh.components.jce.SHA256Digest;
import com.sshtools.ssh.components.jce.SHA384Digest;
import com.sshtools.ssh.components.jce.SHA512Digest;
import com.sshtools.ssh.components.jce.SecureRND;
import com.sshtools.ssh.components.jce.Ssh2DsaPrivateKey;
import com.sshtools.ssh.components.jce.Ssh2DsaPublicKey;
import com.sshtools.ssh.components.jce.Ssh2EcdsaSha2Nist256PublicKey;
import com.sshtools.ssh.components.jce.Ssh2EcdsaSha2Nist384PublicKey;
import com.sshtools.ssh.components.jce.Ssh2EcdsaSha2Nist521PublicKey;
import com.sshtools.ssh.components.jce.Ssh2RsaPrivateCrtKey;
import com.sshtools.ssh.components.jce.Ssh2RsaPrivateKey;
import com.sshtools.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.ssh.components.jce.SshX509DsaPublicKey;
import com.sshtools.ssh.components.jce.SshX509RsaPublicKey;
import com.sshtools.ssh.components.jce.SshX509RsaSha1PublicKey;
import com.sshtools.ssh.components.jce.TripleDesCbc;
import com.sshtools.ssh.components.jce.TripleDesCtr;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCEComponentManager
extends ComponentManager
implements JCEAlgorithms {
    SecureRND rnd;

    public JCEComponentManager() {
        try {
            Class<?> cls = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            Provider bc = (Provider)cls.newInstance();
            Security.addProvider(bc);
            JCEComponentManager.initializeProviderForAlgorithm("DH", bc);
        }
        catch (Throwable t) {
            Log.error(this, "Could not find BouncyCastle provider diffie-hellman-group14-sha1 may not be available");
        }
    }

    public static void initializeDefaultProvider(Provider provider) {
        JCEProvider.initializeDefaultProvider(provider);
    }

    public static void initializeProviderForAlgorithm(String jceAlgorithm, Provider provider) {
        JCEProvider.initializeProviderForAlgorithm(jceAlgorithm, provider);
    }

    public static String getSecureRandomAlgorithm() {
        return JCEProvider.getSecureRandomAlgorithm();
    }

    public static void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        JCEProvider.setSecureRandomAlgorithm(secureRandomAlgorithm);
    }

    public static Provider getProviderForAlgorithm(String jceAlgorithm) {
        return JCEProvider.getProviderForAlgorithm(jceAlgorithm);
    }

    public static SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return JCEProvider.getSecureRandom();
    }

    @Override
    public SshDsaPrivateKey createDsaPrivateKey(BigInteger p, BigInteger q, BigInteger g, BigInteger x, BigInteger y) throws SshException {
        return new Ssh2DsaPrivateKey(p, q, g, x, y);
    }

    @Override
    public SshDsaPublicKey createDsaPublicKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) throws SshException {
        try {
            return new Ssh2DsaPublicKey(p, q, g, y);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshDsaPublicKey createDsaPublicKey() {
        return new Ssh2DsaPublicKey();
    }

    @Override
    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger crtCoefficient) throws SshException {
        try {
            BigInteger primeExponentP = primeP.subtract(BigInteger.ONE);
            primeExponentP = privateExponent.mod(primeExponentP);
            BigInteger primeExponentQ = primeQ.subtract(BigInteger.ONE);
            primeExponentQ = privateExponent.mod(primeExponentQ);
            return new Ssh2RsaPrivateCrtKey(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) throws SshException {
        try {
            return new Ssh2RsaPrivateCrtKey(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPrivateKey createRsaPrivateKey(BigInteger modulus, BigInteger privateExponent) throws SshException {
        try {
            return new Ssh2RsaPrivateKey(modulus, privateExponent);
        }
        catch (Throwable t) {
            throw new SshException(t);
        }
    }

    @Override
    public SshRsaPublicKey createRsaPublicKey(BigInteger modulus, BigInteger publicExponent) throws SshException {
        try {
            return new Ssh2RsaPublicKey(modulus, publicExponent);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshRsaPublicKey createSsh2RsaPublicKey() throws SshException {
        return new Ssh2RsaPublicKey();
    }

    @Override
    public SshKeyPair generateDsaKeyPair(int bits) throws SshException {
        try {
            KeyPairGenerator keyGen = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyPairGenerator.getInstance("DSA") : KeyPairGenerator.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            keyGen.initialize(bits);
            KeyPair keypair = keyGen.genKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            SshKeyPair pair = new SshKeyPair();
            pair.setPrivateKey(new Ssh2DsaPrivateKey((DSAPrivateKey)privateKey, (DSAPublicKey)publicKey));
            pair.setPublicKey(new Ssh2DsaPublicKey((DSAPublicKey)publicKey));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshKeyPair generateRsaKeyPair(int bits) throws SshException {
        try {
            KeyPairGenerator keyGen = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyPairGenerator.getInstance("RSA") : KeyPairGenerator.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            keyGen.initialize(bits);
            KeyPair keypair = keyGen.genKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            SshKeyPair pair = new SshKeyPair();
            if (!(privateKey instanceof RSAPrivateCrtKey)) {
                throw new SshException("RSA key generation requires RSAPrivateCrtKey as private key type.", 16);
            }
            pair.setPrivateKey(new Ssh2RsaPrivateCrtKey((RSAPrivateCrtKey)privateKey));
            pair.setPublicKey(new Ssh2RsaPublicKey((RSAPublicKey)publicKey));
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    public SshSecureRandomGenerator getRND() throws SshException {
        try {
            return this.rnd == null ? new SecureRND() : this.rnd;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SshException(e);
        }
    }

    @Override
    protected void initializeDigestFactory(ComponentFactory digests) {
        if (this.testDigest("MD5", MD5Digest.class)) {
            digests.add("MD5", MD5Digest.class);
        }
        if (this.testDigest("SHA-1", SHA1Digest.class)) {
            digests.add("SHA-1", SHA1Digest.class);
        }
        if (this.testDigest("SHA1", SHA1Digest.class)) {
            digests.add("SHA1", SHA1Digest.class);
        }
        if (this.testDigest("SHA-256", SHA256Digest.class)) {
            digests.add("SHA-256", SHA256Digest.class);
        }
        if (this.testDigest("SHA-384", SHA384Digest.class)) {
            digests.add("SHA-384", SHA384Digest.class);
        }
        if (this.testDigest("SHA-512", SHA512Digest.class)) {
            digests.add("SHA-512", SHA512Digest.class);
        }
    }

    @Override
    protected void initializeHmacFactory(ComponentFactory hmacs) {
        if (this.testHMac("hmac-md5", HmacMD5.class)) {
            hmacs.add("hmac-md5", HmacMD5.class);
        }
        if (this.testHMac("hmac-sha1", HmacSha1.class)) {
            hmacs.add("hmac-sha1", HmacSha1.class);
        }
        if (this.testHMac("hmac-md5-96", HmacMD596.class)) {
            hmacs.add("hmac-md5-96", HmacMD596.class);
        }
        if (this.testHMac("hmac-sha1-96", HmacSha196.class)) {
            hmacs.add("hmac-sha1-96", HmacSha196.class);
        }
        if (this.testHMac("hmac-sha256", HmacSha256.class)) {
            hmacs.add("hmac-sha256", HmacSha256.class);
            hmacs.add("hmac-sha2-256", HmacSha256.class);
            hmacs.add("hmac-sha256@ssh.com", HmacSha256.class);
        }
        if (this.testHMac("hmac-sha512", HmacSha512.class)) {
            hmacs.add("hmac-sha512", HmacSha512.class);
            hmacs.add("hmac-sha512@ssh.com", HmacSha512.class);
        }
    }

    @Override
    protected void initializeKeyExchangeFactory(ComponentFactory keyexchange) {
        try {
            Class<?> DiffieHellmanGroup14Sha12 = Class.forName("com.sshtools.ssh.components.jce.DiffieHellmanGroup14Sha1");
            Class<?> DiffieHellmanGroup1Sha12 = Class.forName("com.sshtools.ssh.components.jce.DiffieHellmanGroup1Sha1");
            Class<?> DiffieHellmanGroupExchangeSha12 = Class.forName("com.sshtools.ssh.components.jce.DiffieHellmanGroupExchangeSha1");
            Class<?> DiffieHellmanGroupExchangeSha2562 = Class.forName("com.sshtools.ssh.components.jce.DiffieHellmanGroupExchangeSha256");
            if (this.testKeyExchangeAlgorithm("diffie-hellman-group14-sha1", DiffieHellmanGroup14Sha12)) {
                keyexchange.add("diffie-hellman-group14-sha1", DiffieHellmanGroup14Sha12);
            }
            if (this.testKeyExchangeAlgorithm("diffie-hellman-group1-sha1", DiffieHellmanGroup1Sha12)) {
                keyexchange.add("diffie-hellman-group1-sha1", DiffieHellmanGroup1Sha12);
            }
            if (this.testKeyExchangeAlgorithm("diffie-hellman-group-exchange-sha1", DiffieHellmanGroupExchangeSha12)) {
                keyexchange.add("diffie-hellman-group-exchange-sha1", DiffieHellmanGroupExchangeSha12);
            }
            if (this.testKeyExchangeAlgorithm("diffie-hellman-group-exchange-sha256", DiffieHellmanGroupExchangeSha2562)) {
                keyexchange.add("diffie-hellman-group-exchange-sha256", DiffieHellmanGroupExchangeSha2562);
            }
            keyexchange.add("ecdh-sha2-nistp256", DiffieHellmanEcdhNistp256.class);
            keyexchange.add("ecdh-sha2-nistp384", DiffieHellmanEcdhNistp384.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void initializePublicKeyFactory(ComponentFactory publickeys) {
        publickeys.add("ssh-dss", Ssh2DsaPublicKey.class);
        publickeys.add("ssh-rsa", Ssh2RsaPublicKey.class);
        publickeys.add("x509v3-sign-rsa", SshX509RsaPublicKey.class);
        publickeys.add("x509v3-sign-dss", SshX509DsaPublicKey.class);
        publickeys.add("x509v3-sign-rsa-sha1", SshX509RsaSha1PublicKey.class);
        publickeys.add("ecdsa-sha2-nistp256", Ssh2EcdsaSha2Nist256PublicKey.class);
        publickeys.add("ecdsa-sha2-nistp384", Ssh2EcdsaSha2Nist384PublicKey.class);
        publickeys.add("ecdsa-sha2-nistp521", Ssh2EcdsaSha2Nist521PublicKey.class);
    }

    @Override
    protected void initializeSsh2CipherFactory(ComponentFactory ciphers) {
        if (this.testJCECipher("3des-ctr", TripleDesCtr.class)) {
            ciphers.add("3des-ctr", TripleDesCtr.class);
        }
        if (this.testJCECipher("aes128-ctr", AES128Ctr.class)) {
            ciphers.add("aes128-ctr", AES128Ctr.class);
        }
        if (this.testJCECipher("aes192-ctr", AES192Ctr.class)) {
            ciphers.add("aes192-ctr", AES192Ctr.class);
        }
        if (this.testJCECipher("aes256-ctr", AES256Ctr.class)) {
            ciphers.add("aes256-ctr", AES256Ctr.class);
        }
    }

    public void installCBCCiphers(ComponentFactory ciphers) {
        if (this.testJCECipher("3des-cbc", TripleDesCbc.class)) {
            ciphers.add("3des-cbc", TripleDesCbc.class);
        }
        if (this.testJCECipher("blowfish-cbc", BlowfishCbc.class)) {
            ciphers.add("blowfish-cbc", BlowfishCbc.class);
        }
        if (this.testJCECipher("aes128-cbc", AES128Cbc.class)) {
            ciphers.add("aes128-cbc", AES128Cbc.class);
        }
        if (this.testJCECipher("aes192-cbc", AES192Cbc.class)) {
            ciphers.add("aes192-cbc", AES192Cbc.class);
        }
        if (this.testJCECipher("aes256-cbc", AES256Cbc.class)) {
            ciphers.add("aes256-cbc", AES256Cbc.class);
        }
    }

    public void installArcFourCiphers(ComponentFactory ciphers) {
        if (this.testJCECipher("arcfour", ArcFour.class)) {
            ciphers.add("arcfour", ArcFour.class);
        }
        if (this.testJCECipher("arcfour128", ArcFour128.class)) {
            ciphers.add("arcfour128", ArcFour128.class);
        }
        if (this.testJCECipher("arcfour256", ArcFour256.class)) {
            ciphers.add("arcfour256", ArcFour256.class);
        }
    }

    private boolean testKeyExchangeAlgorithm(String name, Class<?> keyExchangeAlgorithmClass) {
        String provider = "[unknown]";
        Object SshKeyExchangeClient_Instance = null;
        try {
            String clientId = "SSH-2.0-SOFTWARE_VERSION_COMMENTS";
            String serverId = "SSH-2.0-ExampleSSHD_1.2.3_Comments";
            byte[] clientKexInit = new byte[]{20, 9, 23, -34, -78, 80, 43, 43, -33, -62, 73, 10, 4, 125, -72, -88, -20, 0, 0, 0, 27, 100, 105, 102, 102, 105, 101, 45, 104, 101, 108, 108, 109, 97, 110, 45, 103, 114, 111, 117, 112, 49, 52, 45, 115, 104, 97, 49, 0, 0, 0, 15, 115, 115, 104, 45, 100, 115, 115, 44, 115, 115, 104, 45, 114, 115, 97, 0, 0, 0, 32, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 0, 0, 0, 32, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 0, 0, 0, 18, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 0, 0, 0, 18, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] serverKexInit = new byte[]{20, 23, 119, -40, -10, 11, -1, -102, 84, -3, 119, 47, -92, 81, 17, -51, -53, 0, 0, 0, 54, 100, 105, 102, 102, 105, 101, 45, 104, 101, 108, 108, 109, 97, 110, 45, 103, 114, 111, 117, 112, 49, 45, 115, 104, 97, 49, 44, 100, 105, 102, 102, 105, 101, 45, 104, 101, 108, 108, 109, 97, 110, 45, 103, 114, 111, 117, 112, 49, 52, 45, 115, 104, 97, 49, 0, 0, 0, 15, 115, 115, 104, 45, 100, 115, 115, 44, 115, 115, 104, 45, 114, 115, 97, 0, 0, 0, 111, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 44, 97, 101, 115, 49, 57, 50, 45, 99, 98, 99, 44, 97, 101, 115, 50, 53, 54, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 50, 56, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 57, 50, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 50, 53, 54, 45, 99, 98, 99, 44, 99, 97, 115, 116, 49, 50, 56, 45, 99, 98, 99, 0, 0, 0, 111, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 44, 97, 101, 115, 49, 57, 50, 45, 99, 98, 99, 44, 97, 101, 115, 50, 53, 54, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 50, 56, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 57, 50, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 50, 53, 54, 45, 99, 98, 99, 44, 99, 97, 115, 116, 49, 50, 56, 45, 99, 98, 99, 0, 0, 0, 43, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 44, 104, 109, 97, 99, 45, 109, 100, 53, 45, 57, 54, 44, 104, 109, 97, 99, 45, 115, 104, 97, 49, 45, 57, 54, 0, 0, 0, 43, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 44, 104, 109, 97, 99, 45, 109, 100, 53, 45, 57, 54, 44, 104, 109, 97, 99, 45, 115, 104, 97, 49, 45, 57, 54, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            SshKeyExchangeClient_Instance = keyExchangeAlgorithmClass.newInstance();
            Method test = keyExchangeAlgorithmClass.getMethod("performClientExchange", String.class, String.class, byte[].class, byte[].class);
            test.invoke(SshKeyExchangeClient_Instance, clientId, serverId, clientKexInit, serverKexInit);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SshException) {
                if (e.getCause().getCause() instanceof NoSuchAlgorithmException) {
                    Log.info(this, "   " + name + " will not be supported: " + e.getCause().getCause().getMessage());
                    return false;
                }
                if (e.getCause().getCause() instanceof InvalidAlgorithmParameterException) {
                    Log.info(this, "   " + name + " will not be supported: " + e.getCause().getCause().getMessage());
                    return false;
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Method test = keyExchangeAlgorithmClass.getMethod("getProvider", new Class[0]);
            provider = (String)test.invoke(SshKeyExchangeClient_Instance, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Log.info(this, "   " + name + " will be supported using JCEProvider " + provider);
        return true;
    }

    private boolean testJCECipher(String name, Class<?> cls) {
        try {
            SshCipher c = (SshCipher)cls.newInstance();
            byte[] tmp = new byte[1024];
            c.init(0, tmp, tmp);
            if (c instanceof AbstractJCECipher) {
                Log.info(this, "   " + name + " will be supported using JCE Provider " + ((AbstractJCECipher)c).getProvider());
            }
            return true;
        }
        catch (Throwable e) {
            Log.info(this, "   " + name + " will not be supported: " + e.getMessage());
            return false;
        }
    }

    private boolean testDigest(String name, Class<?> cls) {
        try {
            Digest c = (Digest)cls.newInstance();
            if (c instanceof AbstractDigest) {
                Log.info(this, "   " + name + " will be supported using JCE Provider " + ((AbstractDigest)c).getProvider());
            }
            return true;
        }
        catch (Throwable e) {
            Log.info(this, "   " + name + " will not be supported: " + e.getMessage());
            return false;
        }
    }

    private boolean testHMac(String name, Class<?> cls) {
        try {
            SshHmac c = (SshHmac)cls.newInstance();
            byte[] tmp = new byte[1024];
            c.init(tmp);
            if (c instanceof AbstractHmac) {
                Log.info(this, "   " + name + " will be supported using JCE Provider " + ((AbstractHmac)c).getProvider());
            }
            return true;
        }
        catch (Throwable e) {
            Log.info(this, "   " + name + " will not be supported: " + e.getMessage());
            return false;
        }
    }
}

