/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.components.SshPrivateKey;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.util.ByteArrayWriter;
import com.sshtools.util.SimpleASNReader;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;

public class Ssh2EcdsaSha2NistPrivateKey
implements SshPrivateKey {
    String name;
    String spec;
    String curve;
    ECPrivateKey prv;

    public Ssh2EcdsaSha2NistPrivateKey(ECPrivateKey prv) throws IOException {
        this.prv = prv;
        String curve = prv.getParams().toString();
        if (curve.contains("prime256v1") || curve.contains("secp256r1")) {
            this.curve = "secp256r1";
            this.name = "ecdsa-sha2-nistp256";
            this.spec = "SHA256/ECDSA";
        } else if (curve.contains("secp384r1")) {
            this.curve = "secp384r1";
            this.name = "ecdsa-sha2-nistp384";
            this.spec = "SHA384/ECDSA";
        } else if (curve.contains("secp521r1")) {
            this.curve = "secp521r1";
            this.name = "ecdsa-sha2-nistp521";
            this.spec = "SHA512/ECDSA";
        } else {
            throw new IOException("Unsupported curve name " + curve);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] data) throws IOException {
        try {
            Signature sig = JCEProvider.getProviderForAlgorithm(this.spec) == null ? Signature.getInstance(this.spec) : Signature.getInstance(this.spec, JCEProvider.getProviderForAlgorithm(this.spec));
            sig.initSign(this.prv);
            sig.update(data);
            byte[] sigRaw = sig.sign();
            ByteArrayWriter baw = new ByteArrayWriter();
            try {
                SimpleASNReader asn = new SimpleASNReader(sigRaw);
                asn.getByte();
                asn.getLength();
                asn.getByte();
                byte[] r = asn.getData();
                asn.getByte();
                byte[] s = asn.getData();
                baw.writeBinaryString(r);
                baw.writeBinaryString(s);
                byte[] byArray = baw.toByteArray();
                return byArray;
            }
            catch (IOException ioe) {
                throw new IOException("DER decode failed: " + ioe.getMessage());
            }
            finally {
                baw.close();
            }
        }
        catch (Exception e) {
            throw new IOException("Error in " + this.name + " sign: " + e.getMessage());
        }
    }

    public String getAlgorithm() {
        return this.name;
    }

    public PrivateKey getJCEPrivateKey() {
        return this.prv;
    }
}

