/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.ssh.PasswordAuthentication;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh2.AuthenticationClient;
import com.sshtools.ssh2.AuthenticationProtocol;
import com.sshtools.ssh2.AuthenticationResult;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;

public class Ssh2PasswordAuthentication
extends PasswordAuthentication
implements AuthenticationClient {
    String newpassword;
    boolean passwordChangeRequired = false;
    static final int SSH_MSG_USERAUTH_PASSWD_CHANGEREQ = 60;

    public void setNewPassword(String newpassword) {
        this.newpassword = newpassword;
    }

    public boolean requiresPasswordChange() {
        return this.passwordChangeRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(AuthenticationProtocol authentication, String servicename) throws SshException, AuthenticationResult {
        try {
            if (this.getUsername() == null || this.getPassword() == null) {
                throw new SshException("Username or password not set!", 4);
            }
            if (this.passwordChangeRequired && this.newpassword == null) {
                throw new SshException("You must set a new password!", 4);
            }
            ByteArrayWriter msg = new ByteArrayWriter();
            try {
                msg.writeBoolean(this.passwordChangeRequired);
                msg.writeString(this.getPassword());
                if (this.passwordChangeRequired) {
                    msg.writeString(this.newpassword);
                }
                authentication.sendRequest(this.getUsername(), servicename, "password", msg.toByteArray());
            }
            finally {
                try {
                    msg.close();
                }
                catch (IOException iOException) {}
            }
            byte[] response = authentication.readMessage();
            if (response[0] != 60) {
                authentication.transport.disconnect(2, "Unexpected message received");
                throw new SshException("Unexpected response from Authentication Protocol", 3);
            }
            this.passwordChangeRequired = true;
            throw new AuthenticationResult(2);
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
    }
}

