/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.ssh.PublicKeyAuthentication;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.SshRsaPublicKey;
import com.sshtools.ssh2.AuthenticationClient;
import com.sshtools.ssh2.AuthenticationProtocol;
import com.sshtools.ssh2.AuthenticationResult;
import com.sshtools.ssh2.SignatureGenerator;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;

public class Ssh2PublicKeyAuthentication
extends PublicKeyAuthentication
implements AuthenticationClient {
    static final int SSH_MSG_USERAUTH_PK_OK = 60;
    SignatureGenerator generator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(AuthenticationProtocol authentication, String servicename) throws SshException, AuthenticationResult {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            try {
                byte[] encoded;
                block22: {
                    if (this.getPublicKey() == null) {
                        throw new SshException("Public key not set!", 4);
                    }
                    if (this.getPrivateKey() == null && this.generator == null && this.isAuthenticating()) {
                        throw new SshException("Private key or signature generator not set!", 4);
                    }
                    if (this.getUsername() == null) {
                        throw new SshException("Username not set!", 4);
                    }
                    baw.writeBinaryString(authentication.getSessionIdentifier());
                    baw.write(50);
                    baw.writeString(this.getUsername());
                    baw.writeString(servicename);
                    baw.writeString("publickey");
                    baw.writeBoolean(this.isAuthenticating());
                    try {
                        if (this.getPublicKey() instanceof SshRsaPublicKey && ((SshRsaPublicKey)this.getPublicKey()).getVersion() == 1) {
                            SshRsaPublicKey pk = (SshRsaPublicKey)this.getPublicKey();
                            baw.writeString("ssh-rsa");
                            ByteArrayWriter baw2 = new ByteArrayWriter();
                            try {
                                baw2.writeString("ssh-rsa");
                                baw2.writeBigInteger(pk.getPublicExponent());
                                baw2.writeBigInteger(pk.getModulus());
                                encoded = baw2.toByteArray();
                                baw.writeBinaryString(encoded);
                                break block22;
                            }
                            finally {
                                baw2.close();
                            }
                        }
                        baw.writeString(this.getPublicKey().getAlgorithm());
                        encoded = this.getPublicKey().getEncoded();
                        baw.writeBinaryString(encoded);
                    }
                    catch (Throwable t) {
                        throw new SshException("Unsupported public key type " + this.getPublicKey().getAlgorithm(), 4);
                    }
                }
                ByteArrayWriter baw2 = new ByteArrayWriter();
                try {
                    baw2.writeBoolean(this.isAuthenticating());
                    baw2.writeString(this.getPublicKey().getAlgorithm());
                    baw2.writeBinaryString(encoded);
                    if (this.isAuthenticating()) {
                        byte[] signature = this.generator != null ? this.generator.sign(this.getPublicKey(), baw.toByteArray()) : this.getPrivateKey().sign(baw.toByteArray());
                        ByteArrayWriter sig = new ByteArrayWriter();
                        try {
                            sig.writeString(this.getPublicKey().getAlgorithm());
                            sig.writeBinaryString(signature);
                            baw2.writeBinaryString(sig.toByteArray());
                        }
                        finally {
                            sig.close();
                        }
                    }
                    authentication.sendRequest(this.getUsername(), servicename, "publickey", baw2.toByteArray());
                    byte[] response = authentication.readMessage();
                    if (response[0] == 60) {
                        throw new AuthenticationResult(5);
                    }
                    authentication.transport.disconnect(2, "Unexpected message " + response[0] + " received");
                    throw new SshException("Unexpected message " + response[0] + " received", 3);
                }
                catch (Throwable throwable) {
                    baw2.close();
                    throw throwable;
                }
            }
            catch (IOException ex) {
                throw new SshException(ex, 5);
            }
        }
        catch (Throwable throwable) {
            try {
                baw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setSignatureGenerator(SignatureGenerator generator) {
        this.generator = generator;
    }
}

