/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.forwarding;

import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.Permissions;
import com.sshtools.common.ssh.SshConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ForwardingPolicy
extends Permissions {
    public static final int ALLOW_FORWARDING = 1;
    public static final int GATEWAY_FORWARDING = 2;
    List<String> permit = new ArrayList<String>();
    private int forwardingMaxPacketSize = 65536;
    private int forwardingMaxWindowSize = 327680;
    private int forwardingMinWindowSize = 32768;

    public ForwardingPolicy allowGatewayForwarding() {
        this.add(2);
        return this;
    }

    public ForwardingPolicy denyGatewayForwarding() {
        this.remove(2);
        return this;
    }

    public ForwardingPolicy grantForwarding(String host) {
        if (host.indexOf(58) == -1) {
            host = host + ":*";
        }
        this.permit.add(host);
        return this;
    }

    public ForwardingPolicy revokeForwarding(String host) {
        if (host.indexOf(58) == -1) {
            host = host + ":*";
        }
        this.permit.remove(host);
        return this;
    }

    public boolean checkInterfacePermitted(SshConnection con, String originHost, int originPort) {
        boolean allow = this.check(1);
        if (allow) {
            try {
                InetAddress addr = InetAddress.getByName(originHost);
                allow = addr.isLoopbackAddress() | this.check(2);
            }
            catch (UnknownHostException e) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Failed to determine local forwarding originators interface {}", (Throwable)e, (Object[])new Object[]{originHost});
                }
                return false;
            }
        }
        return allow;
    }

    public boolean checkHostPermitted(SshConnection con, String host, int port) {
        boolean allow = this.check(1);
        if (allow) {
            boolean bl = allow = this.permit.size() == 0;
            if (!allow) {
                String s;
                String p = host + ":" + port;
                String p2 = host + ":*";
                Iterator<String> iterator = this.permit.iterator();
                while (iterator.hasNext() && !(allow = (s = iterator.next()).equals(p) || s.equals(p2))) {
                }
            }
            return allow;
        }
        return allow;
    }

    public ForwardingPolicy allowForwarding() {
        this.add(1);
        return this;
    }

    public ForwardingPolicy denyForwarding() {
        this.remove(1);
        return this;
    }

    public int getForwardingMaxPacketSize() {
        return this.forwardingMaxPacketSize;
    }

    public void setForwardingMaxPacketSize(int forwardingMaxPacketSize) {
        this.forwardingMaxPacketSize = forwardingMaxPacketSize;
    }

    public int getForwardingMaxWindowSize() {
        return this.forwardingMaxWindowSize;
    }

    public void setForwardingMaxWindowSize(int forwardingMaxWindowSize) {
        this.forwardingMaxWindowSize = forwardingMaxWindowSize;
    }

    public int getForwardingMinWindowSize() {
        return this.forwardingMinWindowSize;
    }

    public void setForwardingMinWindowSize(int forwardingMinWindowSize) {
        this.forwardingMinWindowSize = forwardingMinWindowSize;
    }
}

