/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.nio;

import com.sshtools.common.files.nio.AbstractFileBasicAttributes;
import com.sshtools.common.files.nio.AbstractFilePath;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class AbstractFileAttributeView
implements BasicFileAttributeView {
    private final AbstractFilePath path;

    static <V extends FileAttributeView> V get(AbstractFilePath path, Class<V> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            try {
                return (V)((FileAttributeView)((Object)new AbstractFileBasicAttributes(path.getAbstractFile())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static AbstractFileAttributeView get(AbstractFilePath path, String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type.equals("basic")) {
            return new AbstractFileAttributeView(path);
        }
        return null;
    }

    private AbstractFileAttributeView(AbstractFilePath path) {
        this.path = path;
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public AbstractFileBasicAttributes readAttributes() throws IOException {
        return this.path.getAttributes();
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
    }

    Object attribute(Attribute id, AbstractFileBasicAttributes attributes) {
        switch (id) {
            case size: {
                return attributes.size();
            }
            case creationTime: {
                return attributes.creationTime();
            }
            case lastAccessTime: {
                return attributes.lastAccessTime();
            }
            case lastModifiedTime: {
                return attributes.lastModifiedTime();
            }
            case isDirectory: {
                return attributes.isDirectory();
            }
            case isRegularFile: {
                return attributes.isRegularFile();
            }
            case isSymbolicLink: {
                return attributes.isSymbolicLink();
            }
            case isOther: {
                return attributes.isOther();
            }
            case fileKey: {
                return attributes.fileKey();
            }
        }
        return null;
    }

    Map<String, Object> readAttributes(String attributes) throws IOException {
        AbstractFileBasicAttributes zfas = this.readAttributes();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if ("*".equals(attributes)) {
            for (Attribute id : Attribute.values()) {
                try {
                    map.put(id.name(), this.attribute(id, zfas));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else {
            String[] as;
            for (String a : as = attributes.split(",")) {
                try {
                    map.put(a, this.attribute(Attribute.valueOf(a), zfas));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    void setAttribute(String attribute, Object value) throws IOException {
        try {
            if (Attribute.valueOf(attribute) == Attribute.lastModifiedTime) {
                this.setTimes((FileTime)value, null, null);
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("'" + attribute + "' is unknown or read-only attribute");
        }
    }

    private static enum Attribute {
        attributes,
        certificates,
        contentEncoding,
        contentType,
        creationTime,
        fileKey,
        isDirectory,
        isOther,
        isRegularFile,
        isSymbolicLink,
        lastAccessTime,
        lastModifiedTime,
        size;

    }
}

