/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.nio;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class AbstractFileSeekableByteChannel
implements SeekableByteChannel {
    AbstractFile file;
    File tmpfile;
    SeekableByteChannel tmp;

    AbstractFileSeekableByteChannel(AbstractFile file) throws IOException {
        this.file = file;
        this.tmpfile = File.createTempFile("abfs", "tmp");
        this.tmp = Files.newByteChannel(this.tmpfile.toPath(), new OpenOption[0]);
    }

    @Override
    public boolean isOpen() {
        return this.tmp.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.tmp.close();
        try (OutputStream out = this.file.getOutputStream();
             FileInputStream in = new FileInputStream(this.tmpfile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (PermissionDeniedException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.tmp.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.tmp.write(src);
    }

    @Override
    public long position() throws IOException {
        return this.tmp.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        return this.tmp.position(newPosition);
    }

    @Override
    public long size() throws IOException {
        return this.tmp.size();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.tmp.truncate(size);
    }
}

