/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractFileImpl<T extends AbstractFile>
implements AbstractFile {
    protected AbstractFileFactory<T> fileFactory;

    public AbstractFileImpl(AbstractFileFactory<T> fileFactory) {
        this.fileFactory = fileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        if (src.isDirectory()) {
            this.createFolder();
            for (AbstractFile f : src.getChildren()) {
                this.resolveFile(f.getName()).copyFrom(f);
            }
        } else if (src.isFile()) {
            InputStream in = src.getInputStream();
            OutputStream out = this.getOutputStream();
            try {
                this.copy(in, out);
            }
            finally {
                IOUtils.closeStream((InputStream)in);
                IOUtils.closeStream((OutputStream)out);
            }
        } else {
            throw new IOException("Cannot copy object that is not directory or a regular file");
        }
    }

    public void linkTo(String target) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        if (this.isDirectory()) {
            target.createFolder();
            for (AbstractFile f : this.getChildren()) {
                target.resolveFile(f.getName()).copyFrom(f);
                f.delete(false);
            }
        } else if (this.isFile()) {
            InputStream in = this.getInputStream();
            OutputStream out = target.getOutputStream();
            try {
                this.copy(in, out);
            }
            finally {
                IOUtils.closeStream((InputStream)in);
                IOUtils.closeStream((OutputStream)out);
            }
        } else {
            throw new IOException("Cannot move object that is not directory or a regular file");
        }
        this.delete(false);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
        if (!append) {
            return this.getOutputStream();
        }
        return new AppendOutputStream();
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int r;
            byte[] buf = new byte[4096];
            while ((r = in.read(buf)) > -1) {
                out.write(buf, 0, r);
            }
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        finally {
            out.close();
            in.close();
        }
    }

    public AbstractFileFactory<T> getFileFactory() {
        return this.fileFactory;
    }

    protected abstract int doHashCode();

    public final int hashCode() {
        return this.doHashCode();
    }

    protected abstract boolean doEquals(Object var1);

    public final boolean equals(Object obj) {
        return this.doEquals(obj);
    }

    class AppendOutputStream
    extends OutputStream {
        AbstractFileRandomAccess content;

        AppendOutputStream() throws IOException, PermissionDeniedException {
            if (!AbstractFileImpl.this.exists()) {
                try {
                    AbstractFileImpl.this.createNewFile();
                }
                catch (PermissionDeniedException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            this.content = AbstractFileImpl.this.openFile(true);
            try {
                this.content.seek(AbstractFileImpl.this.getAttributes().getSize().longValue());
            }
            catch (PermissionDeniedException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.content.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.content.write(buf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.content.close();
        }
    }
}

