/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.PublicKeyAuthenticationProvider;
import com.sshtools.common.auth.UniversalAuthenticatorAccountDatabase;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.publickey.SshPublicKeyFile;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class UniversalAuthenticationProvider
implements PublicKeyAuthenticationProvider {
    String hostname;
    int port;
    UniversalAuthenticatorAccountDatabase accountDatabase;

    public UniversalAuthenticationProvider(UniversalAuthenticatorAccountDatabase accountDatabase) {
        this(accountDatabase, "gateway.jadaptive.com", 443);
    }

    public UniversalAuthenticationProvider(UniversalAuthenticatorAccountDatabase accountDatabase, String hostname) {
        this(accountDatabase, hostname, 443);
    }

    public UniversalAuthenticationProvider(UniversalAuthenticatorAccountDatabase accountDatabase, String hostname, int port) {
        this.accountDatabase = accountDatabase;
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public boolean isAuthorizedKey(SshPublicKey key, SshConnection con) throws IOException {
        Set<String> gatewayAccounts = this.accountDatabase.getAccounts(con.getUsername());
        if (gatewayAccounts == null) {
            return false;
        }
        for (String gatewayAccount : gatewayAccounts) {
            for (SshPublicKey gatewayKey : this.getGatewayKeys(gatewayAccount)) {
                if (!gatewayKey.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<SshPublicKey> getGatewayKeys(String username) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("https://");
        buf.append(this.hostname);
        if (this.port != 443) {
            buf.append(":");
            buf.append(this.port);
        }
        buf.append("/app/api/agent/authorizedKeys/");
        buf.append(username);
        URL url = new URL(buf.toString());
        InputStream in = url.openStream();
        ArrayList<SshPublicKey> keys = new ArrayList<SshPublicKey>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                keys.add(SshKeyUtils.getPublicKey(line));
            }
        }
        return keys;
    }

    @Override
    public Iterator<SshPublicKeyFile> getKeys(SshConnection con) throws PermissionDeniedException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(SshPublicKey key, SshConnection con) throws IOException, PermissionDeniedException, SshException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(SshPublicKey key, String comment, SshConnection con) throws IOException, PermissionDeniedException, SshException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkKey(SshPublicKey key, SshConnection con) throws IOException {
        return this.isAuthorizedKey(key, con);
    }
}

