/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.nio;

import com.sshtools.common.files.nio.AbstractFileNIOFileSystem;
import com.sshtools.common.files.nio.AbstractFilePath;
import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AbstractFileDirectoryStream
implements DirectoryStream<Path> {
    private final DirectoryStream.Filter<? super Path> filter;
    private final AbstractFileNIOFileSystem fs;
    private volatile Iterator<Path> iterator;
    private volatile boolean open = true;
    private final Path path;

    AbstractFileDirectoryStream(AbstractFilePath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.fs = path.getFileSystem();
        this.path = path.normalize();
        this.filter = filter;
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new NotDirectoryException(path.toString());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.open = false;
    }

    @Override
    public synchronized Iterator<Path> iterator() {
        if (!this.open) {
            throw new ClosedDirectoryStreamException();
        }
        if (this.iterator != null) {
            throw new IllegalStateException();
        }
        try {
            this.iterator = this.fs.iterator(this.path, this.filter);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                if (!AbstractFileDirectoryStream.this.open) {
                    return false;
                }
                return AbstractFileDirectoryStream.this.iterator.hasNext();
            }

            @Override
            public synchronized Path next() {
                if (!AbstractFileDirectoryStream.this.open) {
                    throw new NoSuchElementException();
                }
                return AbstractFileDirectoryStream.this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

