/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components;

import com.sshtools.common.publickey.SignatureGenerator;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public class SshKeyPair
implements SignatureGenerator {
    SshPrivateKey privatekey;
    SshPublicKey publickey;

    public SshPrivateKey getPrivateKey() {
        return this.privatekey;
    }

    public SshPublicKey getPublicKey() {
        return this.publickey;
    }

    public static SshKeyPair getKeyPair(SshPrivateKey prv, SshPublicKey pub) {
        SshKeyPair pair = new SshKeyPair();
        pair.publickey = pub;
        pair.privatekey = prv;
        return pair;
    }

    public void setPrivateKey(SshPrivateKey privatekey) {
        this.privatekey = privatekey;
    }

    public void setPublicKey(SshPublicKey publickey) {
        this.publickey = publickey;
    }

    public int hashCode() {
        return this.privatekey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshKeyPair) {
            SshKeyPair other = (SshKeyPair)obj;
            if (other.privatekey != null && other.publickey != null && this.privatekey != null && this.publickey != null) {
                return other.privatekey.equals(this.privatekey) && other.publickey.equals(this.publickey);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sign(SshPublicKey key, String signingAlgorithm, byte[] data) throws SshException, IOException {
        try (ByteArrayWriter sig = new ByteArrayWriter();){
            byte[] s = this.getPrivateKey().sign(data, signingAlgorithm);
            sig.writeString(signingAlgorithm);
            sig.writeBinaryString(s);
            byte[] byArray = sig.toByteArray();
            return byArray;
        }
    }

    @Override
    public Collection<SshPublicKey> getPublicKeys() throws IOException {
        return Arrays.asList(this.getPublicKey());
    }
}

