/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files;

import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.files.FileVolume;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.MultipartTransfer;
import com.sshtools.common.sftp.OpenFile;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.files.PseduoRandomOpenFile;
import com.sshtools.common.sftp.files.RandomAccessOpenFile;
import com.sshtools.common.util.UnsignedInteger32;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;

public interface AbstractFile {
    public String getName();

    public InputStream getInputStream() throws IOException, PermissionDeniedException;

    public boolean exists() throws IOException, PermissionDeniedException;

    default public boolean existsNoFollowLinks() throws IOException, PermissionDeniedException {
        return this.exists();
    }

    public List<AbstractFile> getChildren() throws IOException, PermissionDeniedException;

    public String getAbsolutePath() throws IOException, PermissionDeniedException;

    public AbstractFile getParentFile() throws IOException, PermissionDeniedException;

    public boolean isDirectory() throws IOException, PermissionDeniedException;

    public boolean isFile() throws IOException, PermissionDeniedException;

    public OutputStream getOutputStream() throws IOException, PermissionDeniedException;

    public boolean isHidden() throws IOException, PermissionDeniedException;

    public boolean createFolder() throws PermissionDeniedException, IOException;

    public boolean isReadable() throws IOException, PermissionDeniedException;

    public boolean delete(boolean var1) throws IOException, PermissionDeniedException;

    public SftpFileAttributes getAttributes() throws FileNotFoundException, IOException, PermissionDeniedException;

    default public SftpFileAttributes getAttributesNoFollowLinks() throws FileNotFoundException, IOException, PermissionDeniedException {
        return this.getAttributes();
    }

    public void refresh();

    public long lastModified() throws IOException, PermissionDeniedException;

    public long length() throws IOException, PermissionDeniedException;

    public boolean isWritable() throws IOException, PermissionDeniedException;

    public boolean createNewFile() throws PermissionDeniedException, IOException;

    public void truncate() throws PermissionDeniedException, IOException;

    public void setAttributes(SftpFileAttributes var1) throws IOException;

    public String getCanonicalPath() throws IOException, PermissionDeniedException;

    public boolean supportsRandomAccess();

    default public OpenFile open(UnsignedInteger32 flags, Optional<UnsignedInteger32> accessFlags, byte[] handle) throws IOException, PermissionDeniedException {
        if (this.supportsRandomAccess()) {
            return new RandomAccessOpenFile(this, flags, handle);
        }
        return new PseduoRandomOpenFile(this, flags, handle);
    }

    public AbstractFileRandomAccess openFile(boolean var1) throws IOException, PermissionDeniedException;

    public OutputStream getOutputStream(boolean var1) throws IOException, PermissionDeniedException;

    public AbstractFile resolveFile(String var1) throws IOException, PermissionDeniedException;

    public AbstractFileFactory<? extends AbstractFile> getFileFactory();

    @Deprecated(since="3.1.0", forRemoval=true)
    default public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    default public void symlinkFrom(String target) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    default public void linkTo(String target) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    default public void linkFrom(String target) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    default public String readSymbolicLink() throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    default public boolean supportsMultipartTransfers() {
        return false;
    }

    default public MultipartTransfer startMultipartUpload(AbstractFile targetFile) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    default public void copyFrom(AbstractFile src) throws IOException, PermissionDeniedException {
        block16: {
            if (src.isDirectory()) {
                this.createFolder();
                for (AbstractFile f : src.getChildren()) {
                    this.resolveFile(f.getName()).copyFrom(f);
                }
            } else {
                if (src.isFile()) {
                    try (InputStream in = src.getInputStream();
                         OutputStream out = this.getOutputStream();){
                        in.transferTo(out);
                        break block16;
                    }
                }
                throw new IOException("Cannot copy object that is not directory or a regular file");
            }
        }
    }

    default public void moveTo(AbstractFile target) throws IOException, PermissionDeniedException {
        block16: {
            if (this.isDirectory()) {
                target.createFolder();
                for (AbstractFile f : this.getChildren()) {
                    target.resolveFile(f.getName()).copyFrom(f);
                    f.delete(false);
                }
            } else {
                if (this.isFile()) {
                    try (InputStream in = this.getInputStream();
                         OutputStream out = target.getOutputStream();){
                        in.transferTo(out);
                        break block16;
                    }
                }
                throw new IOException("Cannot move object that is not directory or a regular file");
            }
        }
        this.delete(false);
    }

    default public FileVolume getVolume() throws IOException {
        throw new UnsupportedOperationException("File storage information is not available on this file system.");
    }
}

