/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey;

import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.OpenSSHPublicKeyFile;
import com.sshtools.common.publickey.SECSHPublicKeyFile;
import com.sshtools.common.publickey.SshPublicKeyFile;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPublicKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int SECSH_FORMAT = 1;
    @Deprecated
    public static final int OPENSSL_FORMAT = 4;

    public static SshPublicKey decodeSSH2PublicKey(byte[] encoded) throws IOException {
        try (ByteArrayReader bar = new ByteArrayReader(encoded);){
            String algorithm = bar.readString();
            try {
                SshPublicKey publickey = ComponentManager.getInstance().supportedPublicKeys().getInstance(algorithm);
                publickey.init(encoded, 0, encoded.length);
                SshPublicKey sshPublicKey = publickey;
                return sshPublicKey;
            }
            catch (SshException ex) {
                try {
                    throw new SshIOException(ex);
                }
                catch (OutOfMemoryError ex2) {
                    throw new IOException("An error occurred parsing a public key file! Is the file corrupt?");
                }
            }
        }
    }

    public static SshPublicKey decodeSSH2PublicKey(String algorithm, byte[] encoded) throws IOException {
        try {
            SshPublicKey publickey = ComponentManager.getInstance().supportedPublicKeys().getInstance(algorithm);
            publickey.init(encoded, 0, encoded.length);
            return publickey;
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
    }

    public static SshPublicKeyFile parse(byte[] formattedkey) throws IOException {
        try {
            if (SECSHPublicKeyFile.isFormatted(formattedkey, SECSHPublicKeyFile.BEGIN, SECSHPublicKeyFile.END)) {
                return new SECSHPublicKeyFile(formattedkey);
            }
            if (OpenSSHPublicKeyFile.isFormatted(formattedkey)) {
                return new OpenSSHPublicKeyFile(formattedkey);
            }
            throw new IOException("Unable to parse key, format could not be identified");
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw e;
            }
            Log.error((String)"Cannot parse public key", (Throwable)e, (Object[])new Object[0]);
            throw new IOException("An error occurred parsing a public key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPublicKeyFile parse(InputStream in) throws IOException {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((read = in.read()) > -1) {
                out.write(read);
            }
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFileFactory.parse(out.toByteArray());
            return sshPublicKeyFile;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPublicKeyFile create(SshPublicKey key, String comment, int format) throws IOException {
        return SshPublicKeyFileFactory.create(key, null, comment, format);
    }

    public static SshPublicKeyFile create(SshPublicKey key, String options, String comment, int format) throws IOException {
        switch (format) {
            case 0: {
                return new OpenSSHPublicKeyFile(key, comment, options);
            }
            case 1: {
                return new SECSHPublicKeyFile(key, comment);
            }
        }
        throw new IOException("Invalid format type specified!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(SshPublicKey key, String comment, int format, File toFile) throws IOException {
        SshPublicKeyFile pub = SshPublicKeyFileFactory.create(key, comment, format);
        try (FileOutputStream out = new FileOutputStream(toFile);){
            out.write(pub.getFormattedKey());
            out.flush();
        }
    }

    public static void convertFile(File keyFile, int toFormat, File toFile) throws IOException {
        SshPublicKeyFile pub = SshPublicKeyFileFactory.parse(new FileInputStream(keyFile));
        SshPublicKeyFileFactory.createFile(pub.toPublicKey(), pub.getComment(), toFormat, toFile);
    }
}

