/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp;

import com.sshtools.common.logger.Log;
import com.sshtools.common.sftp.ACL;
import com.sshtools.common.sftp.PosixPermissions;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class SftpFileAttributes {
    public static final long SSH_FILEXFER_ATTR_SIZE = 1L;
    public static final long SSH_FILEXFER_ATTR_UIDGID = 2L;
    public static final long SSH_FILEXFER_ATTR_PERMISSIONS = 4L;
    public static final long SSH_FILEXFER_ATTR_ACCESSTIME = 8L;
    public static final long SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final long VERSION_3_FLAGS = -2147483633L;
    public static final long SSH_FILEXFER_ATTR_CREATETIME = 16L;
    public static final long SSH_FILEXFER_ATTR_MODIFYTIME = 32L;
    public static final long SSH_FILEXFER_ATTR_ACL = 64L;
    public static final long SSH_FILEXFER_ATTR_OWNERGROUP = 128L;
    public static final long SSH_FILEXFER_ATTR_SUBSECOND_TIMES = 256L;
    public static final long VERSION_4_FLAGS = -2147483139L;
    public static final long SSH_FILEXFER_ATTR_BITS = 512L;
    public static final long VERSION_5_FLAGS = -2147482627L;
    public static final long SSH_FILEXFER_ATTR_ALLOCATION_SIZE = 1024L;
    public static final long SSH_FILEXFER_ATTR_TEXT_HINT = 2048L;
    public static final long SSH_FILEXFER_ATTR_MIME_TYPE = 4096L;
    public static final long SSH_FILEXFER_ATTR_LINK_COUNT = 8192L;
    public static final long SSH_FILEXFER_ATTR_UNTRANSLATED = 16384L;
    public static final long SSH_FILEXFER_ATTR_CTIME = 32768L;
    public static final long VERSION_6_FLAGS = -2147418115L;
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    public static final int SSH_FILEXFER_TYPE_SOCKET = 6;
    public static final int SSH_FILEXFER_TYPE_CHAR_DEVICE = 7;
    public static final int SSH_FILEXFER_TYPE_BLOCK_DEVICE = 8;
    public static final int SSH_FILEXFER_TYPE_FIFO = 9;
    public static final int SSH_FILEXFER_ATTR_FLAGS_READONLY = 1;
    public static final int SSH_FILEXFER_ATTR_FLAGS_SYSTEM = 2;
    public static final int SSH_FILEXFER_ATTR_FLAGS_HIDDEN = 4;
    public static final int SSH_FILEXFER_ATTR_FLAGS_CASE_INSENSITIVE = 8;
    public static final int SSH_FILEXFER_ATTR_FLAGS_ARCHIVE = 16;
    public static final int SSH_FILEXFER_ATTR_FLAGS_ENCRYPTED = 32;
    public static final int SSH_FILEXFER_ATTR_FLAGS_COMPRESSED = 64;
    public static final int SSH_FILEXFER_ATTR_FLAGS_SPARSE = 128;
    public static final int SSH_FILEXFER_ATTR_FLAGS_APPEND_ONLY = 256;
    public static final int SSH_FILEXFER_ATTR_FLAGS_IMMUTABLE = 512;
    public static final int SSH_FILEXFER_ATTR_FLAGS_SYNC = 1024;
    public static final int SSH_FILEXFER_ATTR_FLAGS_TRANSLATION_ERR = 2048;
    public static final int SFX_ACL_CONTROL_INCLUDED = 1;
    public static final int SFX_ACL_CONTROL_PRESENT = 2;
    public static final int SFX_ACL_CONTROL_INHERITED = 4;
    public static final int SFX_ACL_AUDIT_ALARM_INCLUDED = 16;
    public static final int SFX_ACL_AUDIT_ALARM_INHERITED = 32;
    public static final int SSH_FILEXFER_ATTR_KNOWN_TEXT = 0;
    public static final int SSH_FILEXFER_ATTR_GUESSED_TEXT = 1;
    public static final int SSH_FILEXFER_ATTR_KNOWN_BINARY = 2;
    public static final int SSH_FILEXFER_ATTR_GUESSED_BINARY = 0;
    public static final int S_IFMT = 61440;
    public static final int S_MODE_MASK = 4095;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private final String charsetEncoding;
    private final Optional<Long> supportedAttributeMask;
    private final Optional<Long> supportedAttributeBits;
    private final Optional<UnsignedInteger64> allocationSize;
    private final Optional<FileTime> lastAttributesModifiedTime;
    private final Optional<UnsignedInteger32> aclFlags;
    private final List<ACL> acls;
    private final Optional<UnsignedInteger32> attributeBits;
    private final Optional<String> mimeType;
    private final Optional<Byte> textHint;
    private final Optional<UnsignedInteger32> attributeBitsValid;
    private final Optional<Integer> linkCount;
    private final Optional<String> untranslatedName;
    private int type;
    private Optional<Integer> uid;
    private Optional<Integer> gid;
    private long flags;
    private Optional<String> username;
    private Optional<String> group;
    private Optional<UnsignedInteger64> size;
    private Optional<FileTime> lastAccessTime;
    private Optional<FileTime> createTime;
    private Optional<FileTime> lastModifiedTime;
    private Map<String, byte[]> extendedAttributes;
    private Optional<PosixPermissions> permissions;

    private static boolean isFlagSet(long flag, long flags, int version, Optional<Long> supportedAttributeMask) {
        if (version >= 5 && supportedAttributeMask.isPresent()) {
            boolean set;
            boolean bl = set = (flags & (flag & 0xFFFFFFFFL)) == (flag & 0xFFFFFFFFL);
            if (set) {
                set = (supportedAttributeMask.get() & (flag & 0xFFFFFFFFL)) == (flag & 0xFFFFFFFFL);
            }
            return set;
        }
        return (flags & (flag & 0xFFFFFFFFL)) == (flag & 0xFFFFFFFFL);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public SftpFileAttributes(ByteArrayReader bar, int version, String charsetEncoding) throws IOException {
        this(SftpFileAttributesBuilder.of(bar, version, charsetEncoding));
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public SftpFileAttributes(int type, String charsetEncoding) {
        this(SftpFileAttributesBuilder.create().withType(type).withCharsetEncoding(charsetEncoding));
    }

    private SftpFileAttributes(SftpFileAttributesBuilder builder) {
        this.size = builder.size;
        this.type = builder.type;
        this.charsetEncoding = builder.calcCharset();
        this.supportedAttributeBits = builder.supportedAttributeBits;
        this.supportedAttributeMask = builder.supportedAttributeMask;
        this.flags = builder.flags;
        this.allocationSize = builder.allocationSize;
        this.uid = builder.uid;
        this.username = builder.username;
        this.gid = builder.gid;
        this.group = builder.group;
        this.permissions = builder.permissions;
        this.lastAccessTime = builder.lastAccessTime;
        this.createTime = builder.createTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastAttributesModifiedTime = builder.lastAttributesModifiedTime;
        this.acls = Collections.unmodifiableList(new ArrayList<ACL>(builder.acls));
        this.aclFlags = builder.aclFlags;
        this.attributeBits = builder.attributeBits;
        this.mimeType = builder.mimeType;
        this.textHint = builder.textHint;
        this.attributeBitsValid = builder.attributeBitsValid;
        this.linkCount = builder.linkCount;
        this.untranslatedName = builder.untranslatedName;
        this.extendedAttributes = new HashMap<String, byte[]>(builder.extendedAttributes);
    }

    public List<ACL> acls() {
        return this.acls;
    }

    public UnsignedInteger32 aclsFlag() {
        return this.aclFlags.orElse(UnsignedInteger32.ZERO);
    }

    public Optional<UnsignedInteger32> aclsFlagOr() {
        return this.aclFlags;
    }

    public UnsignedInteger64 allocationSize() {
        return this.allocationSize.orElse(UnsignedInteger64.ZERO);
    }

    public Optional<UnsignedInteger64> allocationSizeOr() {
        return this.allocationSize;
    }

    public UnsignedInteger32 attributeBits() {
        return this.attributeBits.orElse(UnsignedInteger32.ZERO);
    }

    public Optional<UnsignedInteger32> attributeBitsOr() {
        return this.attributeBits;
    }

    public UnsignedInteger32 attributeBitsValid() {
        return this.attributeBitsValid.orElseThrow(() -> new IllegalStateException("No valid attribute bits set."));
    }

    public Optional<UnsignedInteger32> attributeBitsValidOr() {
        return this.attributeBitsValid;
    }

    public String charsetEncoding() {
        return this.charsetEncoding;
    }

    public FileTime createTime() {
        return this.createTime.orElseGet(() -> FileTime.fromMillis(0L));
    }

    public Optional<FileTime> createTimeOr() {
        return this.createTime;
    }

    public byte[] extendedAttribute(String key) {
        return this.extendedAttributeOr(key).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("No such key {0}", key)));
    }

    public Optional<byte[]> extendedAttributeOr(String key) {
        return Optional.ofNullable(this.extendedAttributes.get(key));
    }

    public Map<String, byte[]> extendedAttributes() {
        return Collections.unmodifiableMap(this.extendedAttributes);
    }

    public long flags() {
        return this.flags;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public Date getAccessedDateTime() {
        return new Date(this.lastAccessTime().toMillis());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public UnsignedInteger64 getAccessedTime() {
        return new UnsignedInteger64(this.lastAccessTime().toMillis() / 1000L);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public Date getCreationDateTime() {
        return new Date(this.createTime().toMillis());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public UnsignedInteger64 getCreationTime() {
        return new UnsignedInteger64(this.createTime().toMillis() / 1000L);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public Map<String, byte[]> getExtendedAttributes() {
        return this.extendedAttributes();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public String getGID() {
        return this.group.orElseGet(() -> this.gid.map(g -> g.toString()).orElse(null));
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public String getMaskString() {
        return this.toMaskString();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public int getModeType() {
        return this.toModeType();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public Date getModifiedDateTime() {
        return new Date(this.lastModifiedTime().toMillis());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public UnsignedInteger64 getModifiedTime() {
        return new UnsignedInteger64(this.lastModifiedTime().toMillis() / 1000L);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public String getPermissionsString() {
        return this.toPermissionsString();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public PosixPermissions getPosixPermissions() {
        return this.permissions();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public UnsignedInteger64 getSize() {
        return this.size();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public int getType() {
        return this.type();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public String getUID() {
        return this.usernameOr().orElse(this.uid.map(u -> u.toString()).orElse(null));
    }

    public int gid() {
        return this.gid.orElse(0);
    }

    public Optional<Integer> gidOr() {
        return this.gid;
    }

    public String group() {
        return this.group.orElse("");
    }

    public Optional<String> groupOr() {
        return this.group;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean hasAccessTime() {
        return this.hasLastAccessTime();
    }

    public boolean hasAclFlags() {
        return this.aclFlags.isPresent();
    }

    public boolean hasAllocationSize() {
        return this.allocationSize.isPresent();
    }

    public boolean hasAttributeBits() {
        return this.attributeBits.isPresent();
    }

    public boolean hasCreateTime() {
        return this.createTime.isPresent();
    }

    public boolean hasExtendedAttribute(String key) {
        return this.extendedAttributes.containsKey(key);
    }

    public boolean hasGid() {
        return this.gid.isPresent();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean hasGID() {
        return this.hasGid();
    }

    public boolean hasGroup() {
        return this.group.isPresent();
    }

    public boolean hasLastAccessTime() {
        return this.lastAccessTime.isPresent();
    }

    public boolean hasLastAttributesModifiedTime() {
        return this.lastAttributesModifiedTime.isPresent();
    }

    public boolean hasLastModifiedTime() {
        return this.lastModifiedTime.isPresent();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean hasModifiedTime() {
        return this.hasLastModifiedTime();
    }

    public boolean hasPermissions() {
        return this.permissions.isPresent();
    }

    public boolean hasSize() {
        return this.size.isPresent();
    }

    public boolean hasSubSecondTimes() {
        return (this.flags & 0x100L) != 0L;
    }

    public boolean hasSupportedAttributeBits() {
        return this.supportedAttributeBits.isPresent();
    }

    public boolean hasSupportedAttributeMask() {
        return this.supportedAttributeMask.isPresent();
    }

    public boolean hasUid() {
        return this.uid.isPresent();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public boolean hasUID() {
        return this.hasUid();
    }

    public boolean hasUsername() {
        return this.username.isPresent();
    }

    public boolean isAppendOnly() {
        return this.isAttributeBitSet(256L);
    }

    public boolean isArchive() {
        return this.isAttributeBitSet(16L);
    }

    public boolean isAttributeBitSet(long attributeBit) {
        return this.attributeBits.isPresent() && (this.attributeBits.get().longValue() & (attributeBit & 0xFFFFFFFFL)) == (attributeBit & 0xFFFFFFFFL);
    }

    public boolean isBlock() {
        return this.type == 8;
    }

    public boolean isCaseInsensitive() {
        return this.isAttributeBitSet(8L);
    }

    public boolean isCharacter() {
        return this.type == 7;
    }

    public boolean isSpecial() {
        return this.type == 4;
    }

    public boolean isCompressed() {
        return this.isAttributeBitSet(64L);
    }

    public boolean isDirectory() {
        return this.type == 2;
    }

    public boolean isEncrypted() {
        return this.isAttributeBitSet(32L);
    }

    public boolean isFifo() {
        return this.type == 9;
    }

    public boolean isFile() {
        return this.type == 1;
    }

    public boolean isHidden() {
        return this.isAttributeBitSet(4L);
    }

    public boolean isImmutable() {
        return this.isAttributeBitSet(512L);
    }

    public boolean isLink() {
        return this.type == 3;
    }

    public boolean isReadOnly() {
        return this.isAttributeBitSet(1L);
    }

    public boolean isSocket() {
        return this.type == 6;
    }

    public boolean isSparse() {
        return this.isAttributeBitSet(128L);
    }

    public boolean isSync() {
        return this.isAttributeBitSet(1024L);
    }

    public boolean isSubSecondTimes() {
        return (this.flags & 0x100L) != 0L;
    }

    public boolean isSystem() {
        return this.isAttributeBitSet(2L);
    }

    public FileTime lastAccessTime() {
        return this.lastAccessTime.orElseGet(() -> FileTime.fromMillis(0L));
    }

    public Optional<FileTime> lastAccessTimeOr() {
        return this.lastAccessTime;
    }

    public FileTime lastAttributesModifiedTime() {
        return this.lastAttributesModifiedTime.orElseGet(() -> FileTime.fromMillis(0L));
    }

    public Optional<FileTime> lastAttributesModifiedTimeOr() {
        return this.lastAttributesModifiedTime;
    }

    public FileTime lastModifiedTime() {
        return this.lastModifiedTime.orElseGet(() -> FileTime.fromMillis(0L));
    }

    public Optional<FileTime> lastModifiedTimeOr() {
        return this.lastModifiedTime;
    }

    public int linkCount() {
        return this.linkCount.orElse(0);
    }

    public Optional<Integer> linkCountOr() {
        return this.linkCount;
    }

    public String mimeType() {
        return this.mimeType.orElse("application/octet-stream");
    }

    public Optional<String> mimeTypeOr() {
        return this.mimeType;
    }

    public PosixPermissions permissions() {
        return this.permissions.orElse(PosixPermissions.EMPTY);
    }

    public Optional<PosixPermissions> permissionsOr() {
        return this.permissions;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void removeExtendedAttribute(String attrName) {
        this.extendedAttributes.remove(attrName);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setExtendedAttribute(String attrName, byte[] attrValue) {
        this.flags |= Integer.MIN_VALUE;
        this.extendedAttributes.put(attrName, attrValue);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setExtendedAttributes(Map<String, byte[]> attributes) {
        this.flags |= Integer.MIN_VALUE;
        this.extendedAttributes = attributes;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setGID(String gid) {
        if (gid == null) {
            throw new IllegalArgumentException("gid cannot be null!");
        }
        if (!gid.matches("\\d+")) {
            throw new IllegalArgumentException("gid must be a group id containing only digits");
        }
        this.flags |= 0x80L;
        this.flags |= 2L;
        this.gid = Optional.of(Integer.parseInt(gid));
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setGroup(String group) {
        this.flags |= 0x80L;
        this.group = Optional.ofNullable(group);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setPermissions(PosixPermissions newPermissions) {
        this.setPermissions(newPermissions.asUInt32());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setPermissions(String newPermissions) {
        int cp = this.getModeType();
        cp |= this.permissions.map(PosixPermissions::asInt).orElse(0) & 0xFFFFF000;
        cp = (int)((long)cp | PosixPermissions.PosixPermissionsBuilder.create().fromLaxFileModeString(newPermissions).build().asLong());
        this.setPermissions(new UnsignedInteger32((long)cp));
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setPermissions(UnsignedInteger32 permissions) {
        if (permissions != null) {
            if (this.type == 0) {
                this.type = (permissions.longValue() & 0x4000L) == 16384L ? 2 : ((permissions.longValue() & 0x8000L) == 32768L ? 1 : ((permissions.longValue() & 0x2000L) == 8192L ? 4 : ((permissions.longValue() & 0x6000L) == 24576L ? 4 : ((permissions.longValue() & 0x1000L) == 4096L ? 4 : ((permissions.longValue() & 0xF000L) == 61440L ? 4 : ((permissions.longValue() & 0xC000L) == 49152L ? 4 : ((permissions.longValue() & 0xA000L) == 40960L ? 3 : 5)))))));
            }
            this.permissions = Optional.of(PosixPermissions.PosixPermissionsBuilder.create().fromBitmask(permissions.longValue()).build());
            this.flags |= 4L;
        } else {
            this.flags &= 0xFFFFFFFFFFFFFFFBL;
            this.permissions = Optional.empty();
        }
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setPermissionsFromMaskString(String mask) {
        this.setPermissions(PosixPermissions.PosixPermissionsBuilder.create().fromMaskString(mask).build());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setPermissionsFromUmaskString(String umask) {
        this.setPermissions(PosixPermissions.PosixPermissionsBuilder.create().fromUmaskString(umask).build());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setSize(UnsignedInteger64 size) {
        this.size = Optional.ofNullable(size);
        this.flags = this.size.isPresent() ? (this.flags |= 1L) : (this.flags &= 0xFFFFFFFFFFFFFFFEL);
    }

    public void setTimes(UnsignedInteger64 atime, UnsignedInteger32 atime_nano, UnsignedInteger64 mtime, UnsignedInteger32 mtime_nano, UnsignedInteger64 ctime, UnsignedInteger32 ctime_nano) {
        this.setTimes(atime, mtime, ctime);
        this.flags |= 0x100L;
        this.lastAccessTime = this.lastAccessTime.map(ft -> FileTime.from(ft.toInstant().plusNanos(atime_nano == null ? 0L : atime_nano.longValue())));
        this.lastModifiedTime = this.lastModifiedTime.map(ft -> FileTime.from(ft.toInstant().plusNanos(mtime_nano == null ? 0L : mtime_nano.longValue())));
        this.createTime = this.createTime.map(ft -> FileTime.from(ft.toInstant().plusNanos(ctime_nano == null ? 0L : ctime_nano.longValue())));
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setTimes(UnsignedInteger64 atime, UnsignedInteger64 mtime) {
        Optional<Object> optional = this.lastAccessTime = atime == null ? Optional.empty() : Optional.of(FileTime.fromMillis(atime.longValue() * 1000L));
        this.flags = this.lastAccessTime.isPresent() ? (this.flags |= 8L) : (this.flags &= 0xFFFFFFFFFFFFFFF7L);
        Optional<Object> optional2 = this.lastModifiedTime = mtime == null ? Optional.empty() : Optional.of(FileTime.fromMillis(mtime.longValue() * 1000L));
        this.flags = this.lastModifiedTime.isPresent() ? (this.flags |= 0x20L) : (this.flags &= 0xFFFFFFFFFFFFFFDFL);
        this.flags &= 0xFFFFFFFFFFFFFEFFL;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setTimes(UnsignedInteger64 atime, UnsignedInteger64 mtime, UnsignedInteger64 ctime) {
        this.setTimes(atime, mtime);
        Optional<Object> optional = this.createTime = ctime == null ? Optional.empty() : Optional.of(FileTime.fromMillis(ctime.longValue() * 1000L));
        this.flags = this.lastModifiedTime.isPresent() ? (this.flags |= 0x10L) : (this.flags &= 0xFFFFFFFFFFFFFFEFL);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setUID(String uid) {
        if (uid == null) {
            throw new IllegalArgumentException("uid cannot be null!");
        }
        if (!uid.matches("\\d+")) {
            throw new IllegalArgumentException("uid must be a user id containing only digits");
        }
        this.flags |= 0x80L;
        this.flags |= 2L;
        this.uid = Optional.of(Integer.parseInt(uid));
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setUsername(String username) {
        this.flags |= 0x80L;
        this.username = Optional.of(username);
    }

    public UnsignedInteger64 size() {
        return this.size.orElse(UnsignedInteger64.ZERO);
    }

    public Optional<UnsignedInteger64> sizeOr() {
        return this.size;
    }

    public long supportedAttributeBits() {
        return this.supportedAttributeBits.orElse(0L);
    }

    public Optional<Long> supportedAttributeBitsOr() {
        return this.supportedAttributeBits;
    }

    public long supportedAttributeMask() {
        return this.supportedAttributeMask.orElse(0L);
    }

    public Optional<Long> supportedAttributeMaskOr() {
        return this.supportedAttributeMask;
    }

    public byte textHint() {
        return this.textHint.orElseThrow(() -> new IllegalStateException("No text hint set."));
    }

    public Optional<Byte> textHintOr() {
        return this.textHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray(int version) throws IOException {
        try (ByteArrayWriter baw = new ByteArrayWriter();){
            Object object;
            switch (version) {
                case 6: {
                    baw.writeInt(this.flags & 0xFFFFFFFF8000FFFDL);
                    break;
                }
                case 5: {
                    baw.writeInt(this.flags & 0xFFFFFFFF800003FDL);
                    break;
                }
                case 4: {
                    baw.writeInt(this.flags & 0xFFFFFFFF800001FDL);
                    break;
                }
                default: {
                    baw.writeInt(this.flags & 0xFFFFFFFF8000000FL);
                }
            }
            if (version > 3) {
                baw.write(this.type);
            }
            if (this.isFlagSet(1L, version)) {
                baw.write(this.size.orElse(UnsignedInteger64.ZERO).toByteArray());
            }
            if (version <= 3 && this.isFlagSet(2L, version)) {
                baw.writeInt(this.uid.orElse(0).intValue());
                baw.writeInt(this.gid.orElse(0).intValue());
            } else if (version > 3 && this.isFlagSet(128L, version)) {
                baw.writeString(this.username.orElseGet(() -> this.uid.map(Long::toString).orElse("")), this.charsetEncoding);
                baw.writeString(this.group.orElseGet(() -> this.gid.map(Long::toString).orElse("")), this.charsetEncoding);
            }
            if (this.isFlagSet(4L, version)) {
                baw.writeInt(this.permissions.map(PosixPermissions::asLong).orElse(0L) & 0xFFFL | (long)this.toModeType());
            }
            if (version <= 3 && this.isFlagSet(8L, version)) {
                baw.writeInt(this.lastAccessTime.map(a -> a.to(TimeUnit.SECONDS)).orElse(0L).longValue());
                baw.writeInt(this.lastModifiedTime.map(a -> a.to(TimeUnit.SECONDS)).orElse(0L).longValue());
            } else if (version > 3) {
                if (this.isFlagSet(8L, version)) {
                    baw.writeUINT64(this.lastAccessTime.map(a -> a.to(TimeUnit.SECONDS)).orElse(0L).longValue());
                    if (this.isFlagSet(256L, version)) {
                        baw.writeUINT32(new UnsignedInteger32(this.lastAccessTime.map(this::nanosFromFileTime).orElse(0L).longValue()));
                    }
                }
                if (this.isFlagSet(16L, version)) {
                    baw.writeUINT64(this.createTime.map(a -> a.to(TimeUnit.SECONDS)).orElse(0L).longValue());
                    if (this.isFlagSet(256L, version)) {
                        baw.writeUINT32(new UnsignedInteger32(this.createTime.map(this::nanosFromFileTime).orElse(0L).longValue()));
                    }
                }
                if (this.isFlagSet(32L, version)) {
                    baw.writeUINT64(this.lastModifiedTime.map(a -> a.to(TimeUnit.SECONDS)).orElse(0L).longValue());
                    if (this.isFlagSet(256L, version)) {
                        baw.writeUINT32(new UnsignedInteger32(this.lastModifiedTime.map(this::nanosFromFileTime).orElse(0L).longValue()));
                    }
                }
            }
            if (this.isFlagSet(64L, version)) {
                try (ByteArrayWriter tmp = new ByteArrayWriter();){
                    tmp.writeInt(this.acls.size());
                    for (ACL acl : this.acls) {
                        tmp.writeInt(acl.getType());
                        tmp.writeInt(acl.getFlags());
                        tmp.writeInt(acl.getMask());
                        tmp.writeString(acl.getWho());
                    }
                    baw.writeBinaryString(tmp.toByteArray());
                }
            }
            if (version >= 5 && this.isFlagSet(512L, version)) {
                baw.writeInt(this.attributeBits.map(a -> this.supportedAttributeBits.isEmpty() ? a.longValue() : a.longValue() & this.supportedAttributeBits.get()).orElse(0L).longValue());
            }
            if (this.isFlagSet(Integer.MIN_VALUE, version)) {
                baw.writeInt(this.extendedAttributes.size());
                object = this.extendedAttributes.keySet().iterator();
                while (object.hasNext()) {
                    String key = (String)object.next();
                    baw.writeString(key);
                    baw.writeBinaryString(this.extendedAttributes.get(key));
                }
            }
            object = baw.toByteArray();
            return object;
        }
    }

    public String toMaskString() {
        return this.permissions.map(PosixPermissions::asMaskString).orElse("----");
    }

    public int toModeType() {
        switch (this.type) {
            case 2: {
                return 16384;
            }
            case 1: {
                return 32768;
            }
            case 3: {
                return 40960;
            }
            case 7: {
                return 8192;
            }
            case 8: {
                return 24576;
            }
            case 9: {
                return 4096;
            }
            case 6: {
                return 49152;
            }
        }
        return 0;
    }

    public String toPermissionsString() {
        StringBuilder str = new StringBuilder();
        switch (this.type) {
            case 8: {
                str.append('b');
                break;
            }
            case 7: {
                str.append('c');
                break;
            }
            case 2: {
                str.append('d');
                break;
            }
            case 9: {
                str.append('p');
                break;
            }
            case 6: {
                str.append('s');
                break;
            }
            case 3: {
                str.append('l');
                break;
            }
            default: {
                str.append('-');
            }
        }
        str.append(this.permissions.map(PosixPermissions::asFileModesString).orElse(""));
        return str.toString();
    }

    public int type() {
        return this.type;
    }

    public int uid() {
        return this.uid.orElse(0);
    }

    public Optional<Integer> uidOr() {
        return this.uid;
    }

    public String untranslatedName() {
        return this.untranslatedName.orElseThrow(() -> new IllegalStateException("No untranslated name set"));
    }

    public Optional<String> untranslatedNameOr() {
        return this.untranslatedName;
    }

    public String username() {
        return this.username.orElse("");
    }

    public Optional<String> usernameOr() {
        return this.username;
    }

    private boolean isFlagSet(long flag, int version) {
        return SftpFileAttributes.isFlagSet(flag, this.flags, version, this.supportedAttributeMask);
    }

    private long nanosFromFileTime(FileTime filetime) {
        return Integer.toUnsignedLong(filetime.toInstant().getNano());
    }

    public Optional<String> bestUsernameOr() {
        return this.username.or(() -> this.uid.map(u -> String.valueOf(u)));
    }

    public String bestUsername() {
        return this.bestUsernameOr().orElse("nouser");
    }

    public Optional<String> bestGroupOr() {
        return this.group.or(() -> this.gid.map(g -> String.valueOf(g)));
    }

    public String bestGroup() {
        return this.bestGroupOr().orElse("nogroup");
    }

    public static final class SftpFileAttributesBuilder {
        private Optional<FileTime> lastAccessTime = Optional.empty();
        private Optional<FileTime> createTime = Optional.empty();
        private Optional<FileTime> lastModifiedTime = Optional.empty();
        private Optional<FileTime> lastAttributesModifiedTime = Optional.empty();
        private Optional<UnsignedInteger64> size = Optional.empty();
        private Optional<UnsignedInteger64> allocationSize = Optional.empty();
        private int type = 0;
        private long flags = 0L;
        private Optional<String> charsetEncoding = Optional.empty();
        private int version = 4;
        private Optional<Long> supportedAttributeMask = Optional.empty();
        private Optional<Long> supportedAttributeBits = Optional.empty();
        private Optional<PosixPermissions> permissions = Optional.empty();
        private Optional<Integer> uid = Optional.empty();
        private Optional<String> username = Optional.empty();
        private Optional<Integer> gid = Optional.empty();
        private Optional<String> group = Optional.empty();
        private Optional<UnsignedInteger32> aclFlags = Optional.empty();
        private final List<ACL> acls = new ArrayList<ACL>();
        private final Map<String, byte[]> extendedAttributes = new HashMap<String, byte[]>();
        private Optional<UnsignedInteger32> attributeBits = Optional.empty();
        private Optional<String> mimeType = Optional.empty();
        private Optional<Byte> textHint = Optional.empty();
        private Optional<UnsignedInteger32> attributeBitsValid = Optional.empty();
        private Optional<Integer> linkCount = Optional.empty();
        private Optional<String> untranslatedName = Optional.empty();

        public static SftpFileAttributesBuilder create() {
            return new SftpFileAttributesBuilder();
        }

        public static SftpFileAttributesBuilder ofType(int type, String charsetEncoding) {
            return new SftpFileAttributesBuilder().withType(type).withCharsetEncoding(charsetEncoding);
        }

        public static SftpFileAttributesBuilder of(ByteArrayReader bar, int version, String charsetEncoding) throws IOException {
            return new SftpFileAttributesBuilder().asVersion(version).withCharsetEncoding(charsetEncoding).fromPacket(bar);
        }

        private SftpFileAttributesBuilder() {
        }

        public SftpFileAttributesBuilder addAcls(ACL ... acls) {
            return this.addAcls(Arrays.asList(acls));
        }

        public SftpFileAttributesBuilder addAcls(Collection<ACL> acls) {
            this.acls.addAll(acls);
            this.flags |= 2L;
            return this;
        }

        public SftpFileAttributesBuilder addExtendedAttribute(String key, byte[] value) {
            this.extendedAttributes.put(key, value);
            this.flags |= Integer.MIN_VALUE;
            return this;
        }

        public SftpFileAttributesBuilder addExtendedAttributes(Map<String, byte[]> extendedAttributes) {
            this.extendedAttributes.putAll(extendedAttributes);
            this.flags |= Integer.MIN_VALUE;
            return this;
        }

        public SftpFileAttributesBuilder asVersion(int version) {
            this.version = version;
            return this;
        }

        public SftpFileAttributes build() {
            return new SftpFileAttributes(this);
        }

        public SftpFileAttributesBuilder removeExtendedAttribute(String key) {
            this.extendedAttributes.remove(key);
            this.flags |= Integer.MIN_VALUE;
            return this;
        }

        public SftpFileAttributesBuilder withAclFlags(long aclFlags) {
            return this.withAclFlags(new UnsignedInteger32(aclFlags));
        }

        public SftpFileAttributesBuilder withAclFlags(Optional<UnsignedInteger32> aclFlags) {
            this.aclFlags = aclFlags;
            this.flags |= 2L;
            return this;
        }

        public SftpFileAttributesBuilder withAclFlags(UnsignedInteger32 aclFlags) {
            return this.withAclFlags(Optional.of(aclFlags));
        }

        public SftpFileAttributesBuilder withAcls(ACL ... acls) {
            return this.withAcls(Arrays.asList(acls));
        }

        public SftpFileAttributesBuilder withAcls(Collection<ACL> acls) {
            this.acls.clear();
            return this.addAcls(acls);
        }

        public SftpFileAttributesBuilder withAppendOnly(boolean value) {
            this.setAttributeBit(256L, value);
            return this;
        }

        public SftpFileAttributesBuilder withArchive(boolean value) {
            this.setAttributeBit(16L, value);
            return this;
        }

        public SftpFileAttributesBuilder withAttributeBits(int attributeBits) {
            return this.withAttributeBits(new UnsignedInteger32((long)attributeBits));
        }

        public SftpFileAttributesBuilder withAttributeBits(Optional<UnsignedInteger32> attributeBits) {
            this.attributeBits = attributeBits;
            return this;
        }

        public SftpFileAttributesBuilder withAttributeBits(UnsignedInteger32 attributeBits) {
            return this.withAttributeBits(Optional.of(attributeBits));
        }

        public SftpFileAttributesBuilder withCaseSensitive(boolean value) {
            this.setAttributeBit(8L, value);
            return this;
        }

        public SftpFileAttributesBuilder withCharsetEncoding(Charset charsetEncoding) {
            return this.withCharsetEncoding(charsetEncoding.name());
        }

        public SftpFileAttributesBuilder withCharsetEncoding(Optional<String> charsetEncoding) {
            this.charsetEncoding = charsetEncoding;
            return this;
        }

        public SftpFileAttributesBuilder withCharsetEncoding(String charsetEncoding) {
            return this.withCharsetEncoding(Optional.ofNullable(charsetEncoding));
        }

        public SftpFileAttributesBuilder withCompressed(boolean value) {
            this.setAttributeBit(64L, value);
            return this;
        }

        public SftpFileAttributesBuilder withCreateTime(FileTime createTime) {
            return this.withCreateTime(Optional.ofNullable(createTime));
        }

        public SftpFileAttributesBuilder withCreateTime(long createTimeMs) {
            return this.withCreateTime(FileTime.fromMillis(createTimeMs));
        }

        public SftpFileAttributesBuilder withCreateTime(Optional<FileTime> createTime) {
            this.createTime = createTime;
            this.flags = this.createTime.isPresent() ? (this.flags |= 0x10L) : (this.flags &= 0xFFFFFFFFFFFFFFEFL);
            return this;
        }

        public SftpFileAttributesBuilder withEncrypted(boolean value) {
            this.setAttributeBit(32L, value);
            return this;
        }

        public SftpFileAttributesBuilder withExtendedAttributes(Map<String, byte[]> extendedAttributes) {
            this.extendedAttributes.clear();
            return this.addExtendedAttributes(extendedAttributes);
        }

        public SftpFileAttributesBuilder withFileAttributes(SftpFileAttributes attributes) {
            this.size = attributes.size;
            this.type = attributes.type;
            this.charsetEncoding = Optional.of(attributes.charsetEncoding);
            this.supportedAttributeBits = attributes.supportedAttributeBits;
            this.supportedAttributeMask = attributes.supportedAttributeMask;
            this.flags = attributes.flags;
            this.allocationSize = attributes.allocationSize;
            this.uid = attributes.uid;
            this.gid = attributes.gid;
            this.username = attributes.username;
            this.group = attributes.group;
            this.permissions = attributes.permissions;
            this.lastAccessTime = attributes.lastAccessTime;
            this.createTime = attributes.createTime;
            this.lastModifiedTime = attributes.lastModifiedTime;
            this.lastAttributesModifiedTime = attributes.lastAttributesModifiedTime;
            this.acls.clear();
            this.acls.addAll(attributes.acls);
            this.aclFlags = attributes.aclFlags;
            this.extendedAttributes.clear();
            this.extendedAttributes.putAll(attributes.extendedAttributes);
            this.attributeBits = attributes.attributeBits;
            this.mimeType = attributes.mimeType;
            this.textHint = attributes.textHint;
            this.attributeBitsValid = attributes.attributeBitsValid;
            this.linkCount = attributes.linkCount;
            this.untranslatedName = attributes.untranslatedName;
            return this;
        }

        public SftpFileAttributesBuilder withFlags(long flags) {
            this.flags = flags;
            return this;
        }

        public SftpFileAttributesBuilder withGid(int gid) {
            return this.withGid(Optional.of(gid));
        }

        public SftpFileAttributesBuilder withGid(Optional<Integer> gid) {
            this.gid = gid;
            this.flags = this.gid.isPresent() || this.uid.isPresent() ? (this.flags |= 2L) : (this.flags &= 0xFFFFFFFFFFFFFFFDL);
            return this;
        }

        public SftpFileAttributesBuilder withUidOrUsername(Optional<String> attribute) {
            if (attribute.isEmpty()) {
                this.username = Optional.empty();
                this.uid = Optional.empty();
            } else {
                try {
                    this.uid = Optional.of(Integer.parseInt(attribute.get()));
                    this.username = Optional.empty();
                }
                catch (NumberFormatException iae) {
                    this.uid = Optional.empty();
                    this.username = Optional.ofNullable(attribute.get());
                }
            }
            return this;
        }

        public SftpFileAttributesBuilder withUidOrUsername(String attribute) {
            return this.withUidOrUsername(Optional.ofNullable(attribute));
        }

        public SftpFileAttributesBuilder withGidOrGroup(Optional<String> attribute) {
            if (attribute.isEmpty()) {
                this.group = Optional.empty();
                this.gid = Optional.empty();
            } else {
                try {
                    this.gid = Optional.of(Integer.parseInt(attribute.get()));
                    this.group = Optional.empty();
                }
                catch (NumberFormatException iae) {
                    this.gid = Optional.empty();
                    this.group = Optional.ofNullable(attribute.get());
                }
            }
            return this;
        }

        public SftpFileAttributesBuilder withGidOrGroup(String attribute) {
            return this.withGidOrGroup(Optional.ofNullable(attribute));
        }

        public SftpFileAttributesBuilder withGroup(Optional<String> group) {
            this.group = group;
            this.flags = this.username.isPresent() || this.group.isPresent() ? (this.flags |= 0x80L) : (this.flags &= 0xFFFFFFFFFFFFFF7FL);
            return this;
        }

        public SftpFileAttributesBuilder withGroup(String group) {
            return this.withGroup(Optional.of(group));
        }

        public SftpFileAttributesBuilder withHidden(boolean value) {
            this.setAttributeBit(4L, value);
            return this;
        }

        public SftpFileAttributesBuilder withImmutable(boolean value) {
            this.setAttributeBit(512L, value);
            return this;
        }

        public SftpFileAttributesBuilder withLastAccessTime(FileTime atime) {
            return this.withLastAccessTime(Optional.ofNullable(atime));
        }

        public SftpFileAttributesBuilder withLastAccessTime(long atimeMs) {
            return this.withLastAccessTime(FileTime.fromMillis(atimeMs));
        }

        public SftpFileAttributesBuilder withLastAccessTime(Optional<FileTime> atime) {
            this.lastAccessTime = atime;
            this.flags = this.lastAccessTime.isPresent() ? (this.flags |= 8L) : (this.flags &= 0xFFFFFFFFFFFFFFF7L);
            return this;
        }

        public SftpFileAttributesBuilder withLastModifiedTime(FileTime lastModifiedTime) {
            return this.withLastModifiedTime(Optional.ofNullable(lastModifiedTime));
        }

        public SftpFileAttributesBuilder withLastModifiedTime(long lastModifiedTimeMs) {
            return this.withLastModifiedTime(FileTime.fromMillis(lastModifiedTimeMs));
        }

        public SftpFileAttributesBuilder withLastModifiedTime(Optional<FileTime> lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            this.flags = this.lastModifiedTime.isPresent() ? (this.flags |= 0x20L) : (this.flags &= 0xFFFFFFFFFFFFFFDFL);
            return this;
        }

        public SftpFileAttributesBuilder withPermissions(Collection<PosixFilePermission> permissions) {
            return this.withPermissions(PosixPermissions.PosixPermissionsBuilder.create().withPermissions(permissions).build());
        }

        public SftpFileAttributesBuilder withPermissions(Optional<PosixPermissions> permissions) {
            this.permissions = permissions;
            this.flags = this.permissions.isPresent() ? (this.flags |= 4L) : (this.flags &= 0xFFFFFFFFFFFFFFFBL);
            return this;
        }

        public SftpFileAttributesBuilder withPermissions(PosixFilePermission ... permissions) {
            return this.withPermissions(Arrays.asList(permissions));
        }

        public SftpFileAttributesBuilder withPermissions(PosixPermissions permissions) {
            return this.withPermissions(Optional.of(permissions));
        }

        public SftpFileAttributesBuilder withReadOnly(boolean value) {
            this.setAttributeBit(1L, value);
            return this;
        }

        public SftpFileAttributesBuilder withSize(long size) {
            return this.withSize(new UnsignedInteger64(size));
        }

        public SftpFileAttributesBuilder withSize(Optional<UnsignedInteger64> size) {
            this.size = size;
            this.flags = this.size.isPresent() ? (this.flags |= 1L) : (this.flags &= 0xFFFFFFFFFFFFFFFEL);
            return this;
        }

        public SftpFileAttributesBuilder withSize(UnsignedInteger64 size) {
            return this.withSize(Optional.of(size));
        }

        public SftpFileAttributesBuilder withSparse(boolean value) {
            this.setAttributeBit(128L, value);
            return this;
        }

        public SftpFileAttributesBuilder withSubSecondsTimes(boolean subSecondTimes) {
            this.flags = subSecondTimes ? (this.flags |= 0x100L) : (this.flags &= 0xFFFFFFFFFFFFFEFFL);
            return this;
        }

        public SftpFileAttributesBuilder withSupportedAttributeBits(long supportedAttributeBits) {
            return this.withSupportedAttributeBits(Optional.of(supportedAttributeBits));
        }

        public SftpFileAttributesBuilder withSupportedAttributeBits(Optional<Long> supportedAttributeBits) {
            this.supportedAttributeBits = supportedAttributeBits;
            return this;
        }

        public SftpFileAttributesBuilder withSupportedAttributeMask(long supportedAttributeMask) {
            return this.withSupportedAttributeMask(Optional.of(supportedAttributeMask));
        }

        public SftpFileAttributesBuilder withSupportedAttributeMask(Optional<Long> supportedAttributeMask) {
            this.supportedAttributeMask = supportedAttributeMask;
            return this;
        }

        public SftpFileAttributesBuilder withSync(boolean value) {
            this.setAttributeBit(1024L, value);
            return this;
        }

        public SftpFileAttributesBuilder withSystem(boolean value) {
            this.setAttributeBit(2L, value);
            return this;
        }

        public SftpFileAttributesBuilder withType(int type) {
            this.type = type;
            return this;
        }

        public SftpFileAttributesBuilder withUid(int uid) {
            return this.withUid(Optional.of(uid));
        }

        public SftpFileAttributesBuilder withUid(Optional<Integer> uid) {
            this.uid = uid;
            this.flags = this.uid.isPresent() || this.gid.isPresent() ? (this.flags |= 2L) : (this.flags &= 0xFFFFFFFFFFFFFFFDL);
            return this;
        }

        public SftpFileAttributesBuilder withUsername(Optional<String> username) {
            this.username = username;
            this.flags = this.username.isPresent() || this.group.isPresent() ? (this.flags |= 0x80L) : (this.flags &= 0xFFFFFFFFFFFFFF7FL);
            return this;
        }

        public SftpFileAttributesBuilder withUsername(String username) {
            return this.withUsername(Optional.of(username));
        }

        String calcCharset() {
            return this.charsetEncoding.map(e -> {
                try {
                    "1234567890".getBytes((String)e);
                    return e;
                }
                catch (UnsupportedEncodingException ex) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)(e + " is not a supported character set encoding. Defaulting to ISO-8859-1"), (Object[])new Object[0]);
                    }
                    return "ISO-8859-1";
                }
            }).orElse("ISO-8859-1");
        }

        SftpFileAttributesBuilder fromPacket(ByteArrayReader bar) throws IOException {
            byte[] raw;
            String charsetEncoding = this.calcCharset();
            this.flags = bar.available() >= 4 ? bar.readInt() : 0L;
            this.type = 0;
            if (this.version > 3 && bar.available() > 0) {
                this.type = bar.read();
            }
            if (this.isFlagSet(1L, this.version) && bar.available() >= 8) {
                raw = new byte[8];
                bar.read(raw);
                this.size = Optional.of(new UnsignedInteger64(raw));
            } else {
                this.size = Optional.empty();
            }
            if (this.isFlagSet(1024L, this.version) && bar.available() >= 8) {
                raw = new byte[8];
                bar.read(raw);
                this.allocationSize = Optional.of(new UnsignedInteger64(raw));
            } else {
                this.allocationSize = Optional.empty();
            }
            if (this.version <= 3 && this.isFlagSet(2L, this.version) && bar.available() >= 8) {
                this.uid = Optional.of((int)bar.readInt());
                this.gid = Optional.of((int)bar.readInt());
            } else if (this.version > 3 && this.isFlagSet(128L, this.version) && bar.available() > 0) {
                this.username = Optional.of(bar.readString(charsetEncoding));
                this.group = Optional.of(bar.readString(charsetEncoding));
                this.uid = Optional.ofNullable(this.username.map(u -> {
                    try {
                        return Integer.parseInt(u);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }).orElse(null));
                this.gid = Optional.ofNullable(this.group.map(g -> {
                    try {
                        return Integer.parseInt(g);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }).orElse(null));
            } else {
                this.username = Optional.empty();
                this.uid = Optional.empty();
                this.group = Optional.empty();
                this.gid = Optional.empty();
            }
            if (this.isFlagSet(4L, this.version) && bar.available() >= 4) {
                int ifmt;
                long fullPermissionsMask = bar.readInt();
                this.permissions = Optional.of(PosixPermissions.PosixPermissionsBuilder.create().withBitmaskFlags(fullPermissionsMask).build());
                if (this.version <= 3 && (ifmt = (int)fullPermissionsMask & 0xF000) > 0) {
                    this.type = ifmt == 32768 ? 1 : (ifmt == 40960 ? 3 : (ifmt == 8192 ? 7 : (ifmt == 24576 ? 8 : (ifmt == 16384 ? 2 : (ifmt == 4096 ? 9 : (ifmt == 49152 ? 6 : (ifmt == 61440 ? 4 : 5)))))));
                }
            } else {
                this.permissions = Optional.empty();
            }
            if (this.type == 0) {
                this.type = 5;
            }
            this.lastModifiedTime = Optional.empty();
            this.createTime = Optional.empty();
            this.lastAccessTime = Optional.empty();
            this.lastAttributesModifiedTime = Optional.empty();
            if (this.version <= 3 && this.isFlagSet(8L, this.version) && bar.available() >= 8) {
                this.lastAccessTime = Optional.of(FileTime.from(bar.readInt(), TimeUnit.SECONDS));
                this.lastModifiedTime = Optional.of(FileTime.from(bar.readInt(), TimeUnit.SECONDS));
            } else if (this.version > 3 && bar.available() > 0) {
                if (this.isFlagSet(8L, this.version) && bar.available() >= 8) {
                    long atimeSeconds = bar.readUINT64().longValue();
                    this.lastAccessTime = this.isFlagSet(256L, this.version) && bar.available() >= 4 ? Optional.of(FileTime.from(Instant.ofEpochSecond(atimeSeconds).plusNanos(bar.readUINT32().longValue()))) : Optional.of(FileTime.from(atimeSeconds, TimeUnit.SECONDS));
                } else {
                    this.lastAccessTime = Optional.empty();
                }
            }
            if (this.version > 3 && bar.available() > 0 && this.isFlagSet(16L, this.version) && bar.available() >= 8) {
                long ctimeSeconds = bar.readUINT64().longValue();
                this.createTime = this.isFlagSet(256L, this.version) && bar.available() >= 4 ? Optional.of(FileTime.from(Instant.ofEpochSecond(ctimeSeconds).plusNanos(bar.readUINT32().longValue()))) : Optional.of(FileTime.from(ctimeSeconds, TimeUnit.SECONDS));
            }
            if (this.version > 3 && bar.available() > 0 && this.isFlagSet(32L, this.version) && bar.available() >= 8) {
                long mtimeSeconds = bar.readUINT64().longValue();
                this.lastModifiedTime = this.isFlagSet(256L, this.version) && bar.available() >= 4 ? Optional.of(FileTime.from(Instant.ofEpochSecond(mtimeSeconds).plusNanos(bar.readUINT32().longValue()))) : Optional.of(FileTime.from(mtimeSeconds, TimeUnit.SECONDS));
            }
            if (this.version >= 6 && bar.available() > 0 && this.isFlagSet(32768L, this.version) && bar.available() >= 8) {
                long ctimeSeconds = bar.readUINT64().longValue();
                this.lastAttributesModifiedTime = this.isFlagSet(256L, this.version) && bar.available() >= 4 ? Optional.of(FileTime.from(Instant.ofEpochSecond(ctimeSeconds).plusNanos(bar.readUINT32().longValue()))) : Optional.of(FileTime.from(ctimeSeconds, TimeUnit.SECONDS));
            }
            this.aclFlags = Optional.empty();
            this.acls.clear();
            if (this.version > 3 && this.isFlagSet(64L, this.version) && bar.available() >= 4) {
                int length;
                if (this.version >= 6 && bar.available() >= 4) {
                    this.aclFlags = Optional.of(bar.readUINT32());
                }
                if ((length = (int)bar.readInt()) > 0 && bar.available() >= length) {
                    int count = (int)bar.readInt();
                    for (int i = 0; i < count; ++i) {
                        this.acls.add(new ACL((int)bar.readInt(), (int)bar.readInt(), (int)bar.readInt(), bar.readString()));
                    }
                }
            }
            this.attributeBits = this.version >= 5 && this.isFlagSet(512L, this.version) && bar.available() >= 4 ? Optional.of(bar.readUINT32()) : Optional.empty();
            this.attributeBitsValid = Optional.empty();
            this.textHint = Optional.empty();
            this.mimeType = Optional.empty();
            this.linkCount = Optional.empty();
            this.untranslatedName = Optional.empty();
            if (this.version >= 6) {
                if (this.isFlagSet(512L, this.version) && bar.available() >= 4) {
                    this.attributeBitsValid = Optional.of(bar.readUINT32());
                }
                if (this.isFlagSet(2048L, this.version) && bar.available() >= 1) {
                    this.textHint = Optional.of((byte)bar.read());
                }
                if (this.isFlagSet(4096L, this.version) && bar.available() >= 4) {
                    this.mimeType = Optional.of(bar.readString());
                }
                if (this.isFlagSet(8192L, this.version) && bar.available() >= 4) {
                    this.linkCount = Optional.of(bar.readUINT32().intValue());
                }
                if (this.isFlagSet(16384L, this.version) && bar.available() >= 4) {
                    this.untranslatedName = Optional.of(bar.readString());
                }
            }
            this.extendedAttributes.clear();
            if (this.version >= 3 && this.isFlagSet(Integer.MIN_VALUE, this.version) && bar.available() >= 4) {
                int count = (int)bar.readInt();
                for (int i = 0; i < count; ++i) {
                    this.extendedAttributes.put(bar.readString(), bar.readBinaryString());
                }
            }
            return this;
        }

        boolean isFlagSet(long flag, int version) {
            return SftpFileAttributes.isFlagSet(flag, this.flags, version, this.supportedAttributeMask);
        }

        void setAttributeBit(long attributeBit, boolean value) {
            this.flags |= 0x200L;
            this.attributeBits = value ? Optional.of(new UnsignedInteger32(this.attributeBits.map(UnsignedInteger32::longValue).orElse(0L) | attributeBit)) : Optional.of(new UnsignedInteger32(this.attributeBits.map(UnsignedInteger32::longValue).orElse(0L) & (attributeBit ^ 0xFFFFFFFFFFFFFFFFL)));
        }
    }
}

