/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.UnsupportedFileOperationException;
import com.sshtools.common.sftp.extensions.AbstractSftpExtension;
import com.sshtools.common.util.ByteArrayReader;
import java.io.IOException;

public class HardLinkExtension
extends AbstractSftpExtension {
    public static final String EXTENSION_NAME = "hardlink@openssh.com";

    public HardLinkExtension() {
        super(EXTENSION_NAME, true);
    }

    @Override
    public void processMessage(ByteArrayReader msg, int requestId, SftpSubsystem sftp) {
        try {
            sftp.getFileSystem().createLink(msg.readString(), msg.readString());
            sftp.sendStatusMessage(requestId, 0, "The hard link operation completed.");
        }
        catch (IOException e) {
            sftp.sendStatusMessage(requestId, 4, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            sftp.sendStatusMessage(requestId, 3, e.getMessage());
        }
        catch (UnsupportedFileOperationException e) {
            sftp.sendStatusMessage(requestId, 8, e.getMessage());
        }
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
    }
}

