/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions.multipart;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.MultipartTransfer;
import com.sshtools.common.sftp.SftpExtension;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CreateMultipartFileExtension
implements SftpExtension {
    public static final String EXTENSION_NAME = "create-multipart-file@sshtools.com";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(ByteArrayReader bar, int requestId, SftpSubsystem sftp) {
        String path = null;
        try {
            AbstractFileSystem fs = sftp.getFileSystem();
            path = sftp.checkDefaultPath(bar.readString(sftp.getCharsetEncoding()));
            Object targetFile = fs.getFileFactory().getFile(path);
            if (!targetFile.supportsMultipartTransfers()) {
                sftp.sendStatusMessage(requestId, 8, "Path does not support multipart extensions");
                return;
            }
            MultipartTransfer t = fs.startMultipartUpload((AbstractFile)targetFile);
            try (Packet reply = new Packet();){
                reply.write(201);
                reply.writeInt(requestId);
                reply.writeBinaryString(Utils.getUTF8Bytes((String)t.getUuid()));
                reply.writeInt(t.getMinimumPartSize());
                reply.write(0);
                sftp.sendMessage(reply);
            }
        }
        catch (FileNotFoundException ioe) {
            sftp.sendStatusMessage(requestId, 2, ioe.getMessage());
        }
        catch (IOException ioe2) {
            sftp.sendStatusMessage(requestId, 4, ioe2.getMessage());
        }
        catch (PermissionDeniedException pde) {
            sftp.sendStatusMessage(requestId, 3, pde.getMessage());
        }
        finally {
            bar.close();
        }
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDeclaredInVersion() {
        return true;
    }

    @Override
    public byte[] getDefaultData() {
        return new byte[0];
    }

    @Override
    public String getName() {
        return EXTENSION_NAME;
    }
}

