/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationQueues;
import com.sshtools.common.ssh.ExecutorServiceProvider;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class ExecutorOperationSupport<T extends ExecutorServiceProvider> {
    public static final Integer MESSAGES_INCOMING = ExecutorOperationQueues.generateUniqueQueue("ExecutorOperationSupport.in");
    public static final Integer MESSAGES_OUTGOING = ExecutorOperationQueues.generateUniqueQueue("ExecutorOperationSupport.out");
    public static final Integer EVENTS = ExecutorOperationQueues.generateUniqueQueue("ExecutorOperationSupport.events");
    public static final Integer CALLBACKS = ExecutorOperationQueues.generateUniqueQueue("ExecutorOperationSupport.callbacks");
    boolean shutdown = false;
    String queueName;
    ConcurrentHashMap<Integer, OperationTask> operationQueues = new ConcurrentHashMap();

    protected ExecutorOperationSupport(String queueName) {
        this.queueName = queueName;
    }

    public abstract T getContext();

    public void addOutgoingTask(ConnectionAwareTask r) {
        this.addTask(MESSAGES_OUTGOING, r);
    }

    public void addIncomingTask(ConnectionAwareTask r) {
        this.addTask(MESSAGES_INCOMING, r);
    }

    public void addTask(Integer queue, ConnectionAwareTask r) {
        if (!this.operationQueues.containsKey(queue)) {
            this.operationQueues.put(queue, new OperationTask());
        }
        this.operationQueues.get(queue).addTask(r);
    }

    public void cleanupOperations(ConnectionAwareTask doCleanup) {
        for (OperationTask task : this.operationQueues.values()) {
            if (!task.running) continue;
            task.cleanupOperations();
        }
        this.addTask(EVENTS, doCleanup);
    }

    class OperationTask
    implements Runnable {
        boolean running = false;
        Future<?> operationFuture = null;
        LinkedList<Runnable> subsystemOperations = new LinkedList();

        OperationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Log.isTraceEnabled()) {
                Log.trace((String)"{}: Operation task is starting", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
            }
            do {
                this.executeAllTasks();
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"{}: No more tasks, will wait for a few more seconds before completing task", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
                }
                OperationTask operationTask = this;
                synchronized (operationTask) {
                    this.running = !this.subsystemOperations.isEmpty();
                }
            } while (this.running);
            if (Log.isTraceEnabled()) {
                Log.trace((String)"{}: Operation task has ended", (Object[])new Object[0]);
            }
        }

        public synchronized void addTask(Runnable r) {
            this.subsystemOperations.addLast(r);
            if (!this.running) {
                this.running = true;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"{}: Starting new subsystem task", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
                }
                this.operationFuture = ExecutorOperationSupport.this.getContext().getExecutorService().submit(this);
            } else {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAllTasks() {
            block7: while (true) {
                try {
                    while (true) {
                        Runnable r = null;
                        OperationTask operationTask = this;
                        synchronized (operationTask) {
                            if (this.subsystemOperations.isEmpty()) {
                                return;
                            }
                            r = this.subsystemOperations.removeFirst();
                        }
                        if (r != null) {
                            try {
                                r.run();
                                continue block7;
                            }
                            catch (Throwable t) {
                                Log.error((String)"{}: Caught exception in operation remainingTasks={}", (Object[])new Object[]{ExecutorOperationSupport.this.queueName, this.subsystemOperations.size(), t});
                                continue;
                            }
                        }
                        if (!Log.isWarnEnabled()) continue;
                        Log.warn((String)"{}: Unexpected null task in operation queue", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
                    }
                }
                catch (Throwable t) {
                    Log.error((String)"{}: Caught exception in operation remainingTasks={}", (Object[])new Object[]{ExecutorOperationSupport.this.queueName, this.subsystemOperations.size(), t});
                    continue;
                }
                break;
            }
        }

        protected synchronized void cleanupOperations() {
            if (!ExecutorOperationSupport.this.shutdown) {
                ExecutorService executorService;
                ExecutorOperationSupport.this.shutdown = true;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"{}: Submitting clean up operation to executor service", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
                }
                if (!(executorService = ExecutorOperationSupport.this.getContext().getExecutorService()).isShutdown()) {
                    executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (OperationTask.this.operationFuture != null) {
                                if (Log.isTraceEnabled()) {
                                    Log.trace((String)"{}: Cleaning up operations", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
                                }
                                try {
                                    if (Log.isTraceEnabled()) {
                                        Log.trace((String)"{}: Waiting for operations to complete", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
                                    }
                                    OperationTask.this.operationFuture.get();
                                    if (Log.isTraceEnabled()) {
                                        Log.trace((String)"{}: All operations have completed", (Object[])new Object[]{ExecutorOperationSupport.this.queueName});
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (ExecutionException executionException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
            }
        }
    }
}

