/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components;

import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.util.Utils;
import java.io.UnsupportedEncodingException;

public class DigestUtils {
    public static byte[] digest(String name, byte[] b) {
        try {
            Digest digest = JCEComponentManager.getDefaultInstance().getDigest(name);
            digest.putBytes(b);
            return digest.doFinal();
        }
        catch (SshException e) {
            throw new IllegalArgumentException(String.format("%s is not a supported digest", name));
        }
    }

    public static byte[] digest(String name, byte[] b, int off, int len) {
        try {
            Digest digest = JCEComponentManager.getDefaultInstance().getDigest(name);
            digest.putBytes(b, off, len);
            return digest.doFinal();
        }
        catch (SshException e) {
            throw new IllegalArgumentException(String.format("%s is not a supported digest", name));
        }
    }

    public static byte[] md5(byte[] b) {
        return DigestUtils.digest("MD5", b);
    }

    public static byte[] md5(byte[] b, int off, int len) {
        return DigestUtils.digest("MD5", b, off, len);
    }

    public static byte[] sha1(byte[] b) {
        return DigestUtils.digest("SHA-1", b);
    }

    public static byte[] sha256(byte[] b) {
        return DigestUtils.digest("SHA-256", b);
    }

    public static byte[] sha384(byte[] b) {
        return DigestUtils.digest("SHA-384", b);
    }

    public static byte[] sha512(byte[] b) {
        return DigestUtils.digest("SHA-512", b);
    }

    public static String sha1Hex(String string) {
        try {
            return DigestUtils.sha1Hex(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding error. This system does not support UTF-8!");
        }
    }

    public static String sha1Hex(byte[] b) {
        return Utils.bytesToHex((byte[])DigestUtils.sha1(b));
    }

    public static String sha256Hex(String string) {
        try {
            return DigestUtils.sha256Hex(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding error. This system does not support UTF-8!");
        }
    }

    public static String sha256Hex(byte[] b) {
        return Utils.bytesToHex((byte[])DigestUtils.sha256(b));
    }

    public static String sha384Hex(String string) {
        try {
            return DigestUtils.sha384Hex(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding error. This system does not support UTF-8!");
        }
    }

    public static String sha384Hex(byte[] b) {
        return Utils.bytesToHex((byte[])DigestUtils.sha384(b));
    }

    public static String sha512Hex(String string) {
        try {
            return DigestUtils.sha512Hex(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding error. This system does not support UTF-8!");
        }
    }

    public static String sha512Hex(byte[] b) {
        return Utils.bytesToHex((byte[])DigestUtils.sha512(b));
    }
}

