/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sshd.config;

import com.sshtools.common.sshd.config.SshdConfigFileEntry;
import java.util.Objects;

public class SshdConfigKeyValueEntry
extends SshdConfigFileEntry {
    private String key;
    private String value;
    private boolean commentedOut;
    private boolean indented;
    private SshdConfigKeyValueEntry next;

    public SshdConfigKeyValueEntry(String key, String value) {
        this(key, value, false, false);
    }

    public SshdConfigKeyValueEntry(String key, String value, boolean commentedOut, boolean indented) {
        this.key = key;
        this.value = value;
        this.commentedOut = commentedOut;
        this.indented = indented;
    }

    @Override
    public String getFormattedLine() {
        if (this.indented) {
            if (this.commentedOut) {
                return String.format("#\t%s %s", this.key, this.value);
            }
            return String.format("\t%s %s", this.key, this.value);
        }
        if (this.commentedOut) {
            return String.format("#%s %s", this.key, this.value);
        }
        return String.format("%s %s", this.key, this.value);
    }

    @Override
    public boolean hasNext() {
        return Objects.nonNull(this.next);
    }

    @Override
    public SshdConfigKeyValueEntry getNext() {
        if (!this.hasNext()) {
            return null;
        }
        return this.next;
    }

    @Override
    public void setNext(SshdConfigFileEntry next) {
        if (!((SshdConfigKeyValueEntry)next).getKey().equals(this.getKey())) {
            throw new IllegalArgumentException("Next value and this entry must have the same key " + this.getKey());
        }
        this.next = (SshdConfigKeyValueEntry)next;
    }

    @Override
    public boolean isCommentedOut() {
        return this.commentedOut;
    }

    public String toString() {
        return this.getFormattedLine();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public boolean hasParts() {
        return this.value.contains(",") || this.value.contains(" ");
    }

    public boolean hasCommaSV() {
        return this.value.contains(",");
    }

    public boolean hasSpaceSV() {
        return this.value.contains(" ");
    }

    public String[] getValueParts() {
        if (this.value.contains(",")) {
            return this.value.split(",");
        }
        if (this.value.contains(" ")) {
            return this.value.split("\\s");
        }
        return new String[]{this.value};
    }

    @Override
    public void setCommentedOut(boolean commentedOut) {
        this.commentedOut = commentedOut;
    }
}

