/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.permissions.PermissionDeniedException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractFileImpl<T extends AbstractFile>
implements AbstractFile {
    protected AbstractFileFactory<T> fileFactory;

    public AbstractFileImpl(AbstractFileFactory<T> fileFactory) {
        this.fileFactory = fileFactory;
    }

    @Override
    public void symlinkTo(String target) throws IOException, PermissionDeniedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws IOException, PermissionDeniedException {
        if (!append) {
            return this.getOutputStream();
        }
        return new AppendOutputStream();
    }

    public AbstractFileFactory<T> getFileFactory() {
        return this.fileFactory;
    }

    protected abstract int doHashCode();

    public final int hashCode() {
        return this.doHashCode();
    }

    protected abstract boolean doEquals(Object var1);

    public final boolean equals(Object obj) {
        return this.doEquals(obj);
    }

    class AppendOutputStream
    extends OutputStream {
        AbstractFileRandomAccess content;

        AppendOutputStream() throws IOException, PermissionDeniedException {
            if (!AbstractFileImpl.this.exists()) {
                try {
                    AbstractFileImpl.this.createNewFile();
                }
                catch (PermissionDeniedException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            this.content = AbstractFileImpl.this.openFile(true);
            try {
                this.content.seek(AbstractFileImpl.this.getAttributes().size().longValue());
            }
            catch (PermissionDeniedException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.content.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.content.write(buf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.content.close();
        }
    }
}

