/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.components.jce.JCEAlgorithms;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;

public class JCEProvider
implements JCEAlgorithms {
    static Provider defaultProvider = null;
    static Provider bcProvider = null;
    static Hashtable<String, Provider> specficProviders = new Hashtable();
    static String secureRandomAlgorithm = null;
    static Boolean bcEnabled = null;
    static String ecdsaAlgorithmName = "EC";
    static String rsaOAEPSHA256WithMG1Padding = "RSA/None/OAEPWithSHA256AndMGF1Padding";
    static String rsaOAEPSHA1WithMG1Padding = "RSA/None/OAEPWithSHA1AndMGF1Padding";
    static boolean enableSC = false;
    static SecureRandom secureRandom;

    public static void initializeDefaultProvider(Provider provider) {
        defaultProvider = provider;
    }

    public static void initializeDefaultProvider(String name) throws NoSuchProviderException {
        Provider provider = Security.getProvider(name);
        if (provider == null) {
            throw new NoSuchProviderException();
        }
        JCEProvider.initializeDefaultProvider(provider);
    }

    public static void initializeProviderForAlgorithm(String jceAlgorithm, Provider provider) {
        if ("executable".equals(System.getProperty("org.graalvm.nativeimage.kind", ""))) {
            Log.warn((String)"Leaving provider configuration as running a native build.", (Object[])new Object[0]);
        } else {
            specficProviders.put(jceAlgorithm, provider);
        }
    }

    public static void initializeProviderForAlgorithm(String jceAlgorithm, String name) throws NoSuchProviderException {
        Provider provider = Security.getProvider(name);
        if (provider == null) {
            throw new NoSuchProviderException();
        }
        JCEProvider.initializeProviderForAlgorithm(jceAlgorithm, provider);
    }

    public static String getSecureRandomAlgorithm() {
        return secureRandomAlgorithm;
    }

    public static void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        JCEProvider.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public static Provider getProviderForAlgorithm(String jceAlgorithm) {
        if (specficProviders.containsKey(jceAlgorithm)) {
            return specficProviders.get(jceAlgorithm);
        }
        return defaultProvider;
    }

    public static SecureRandom getSecureRandom() {
        if (secureRandom == null) {
            try {
                if (JCEProvider.getSecureRandomAlgorithm() != null) {
                    secureRandom = JCEProvider.getProviderForAlgorithm(JCEProvider.getSecureRandomAlgorithm()) == null ? SecureRandom.getInstance(JCEProvider.getSecureRandomAlgorithm()) : SecureRandom.getInstance(JCEProvider.getSecureRandomAlgorithm(), JCEProvider.getProviderForAlgorithm(JCEProvider.getSecureRandomAlgorithm()));
                    return secureRandom;
                }
                secureRandom = new SecureRandom();
            }
            catch (NoSuchAlgorithmException e) {
                secureRandom = new SecureRandom();
                return secureRandom;
            }
        }
        return secureRandom;
    }

    public static Provider getDefaultProvider() {
        return defaultProvider;
    }

    static void setBCProvider(Provider provider) {
        bcProvider = provider;
    }

    public static boolean hasBCProvider() {
        return bcProvider != null && bcEnabled != false;
    }

    public static Provider getBCProvider() {
        if (bcProvider == null) {
            JCEProvider.configureBC();
        }
        return bcProvider;
    }

    public static void enableSpongyCastle(boolean makeDefault) {
        enableSC = true;
        JCEProvider.enableBouncyCastle(makeDefault);
    }

    public static void enableBouncyCastle(boolean makeDefault) {
        if ("executable".equals(System.getProperty("org.graalvm.nativeimage.kind", ""))) {
            Log.warn((String)"Leaving provider configuration as running a native build.", (Object[])new Object[0]);
            return;
        }
        BC_FLAVOR bcFlavor = JCEProvider.configureBC();
        if (bcProvider == null) {
            throw new IllegalStateException("Bouncycastle JCE provider cannot be found on the classpath");
        }
        bcEnabled = true;
        boolean add = true;
        for (Provider p : Security.getProviders()) {
            if (!p.getName().equals(bcProvider.getName())) continue;
            add = false;
            break;
        }
        if (add) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Adding Bouncycastle {} provider to Security Providers", (Object[])new Object[]{bcProvider.getName()});
            }
            if (bcFlavor == BC_FLAVOR.SC) {
                Security.insertProviderAt(bcProvider, 1);
            } else {
                Security.addProvider(bcProvider);
            }
        }
        if (!bcFlavor.equals((Object)BC_FLAVOR.SC)) {
            JCEProvider.setECDSAAlgorithmName("ECDSA");
        }
        JCEProvider.setRSAOAEPSHA256AlgorithmName("RSA/None/OAEPWithSHA256AndMGF1Padding");
        JCEProvider.setRSAOAEPSHA1AlgorithmName("RSA/None/OAEPWithSHA1AndMGF1Padding");
        if (makeDefault) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Configuring Bouncycastle {} provider as default for all algorithms", (Object[])new Object[]{bcProvider.getName()});
            }
            JCEProvider.initializeDefaultProvider(bcProvider);
        } else {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Configuring DH support with Bouncycastle {} provider", (Object[])new Object[]{bcProvider.getName()});
            }
            JCEProvider.initializeProviderForAlgorithm("DH", bcProvider);
            JCEProvider.initializeProviderForAlgorithm("DH_KeyAgreement", bcProvider);
            JCEProvider.initializeProviderForAlgorithm("DH_KeyFactory", bcProvider);
            JCEProvider.initializeProviderForAlgorithm("DH_KeyGenerator", bcProvider);
        }
    }

    private static BC_FLAVOR configureBC() {
        try {
            if (enableSC) {
                Class<?> cls = Class.forName("org.spongycastle.jce.provider.BouncyCastleProvider");
                bcProvider = (Provider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                return BC_FLAVOR.SC;
            }
        }
        catch (Throwable cls) {
            // empty catch block
        }
        try {
            Class<?> cls = Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            bcProvider = (Provider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            return BC_FLAVOR.BCFIPS;
        }
        catch (Throwable t) {
            try {
                Class<?> cls = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                bcProvider = (Provider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                return BC_FLAVOR.BC;
            }
            catch (Throwable f) {
                throw new IllegalStateException("Bouncycastle, BCFIPS or SpongyCastle is not installed");
            }
        }
    }

    public static KeyFactory getDHKeyFactory() throws NoSuchAlgorithmException {
        try {
            return JCEProvider.getProviderForAlgorithm("DH_KeyFactory") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH_KeyFactory"));
        }
        catch (NoSuchAlgorithmException e) {
            return KeyFactory.getInstance("DH");
        }
    }

    public static KeyAgreement getDHKeyAgreement() throws NoSuchAlgorithmException {
        try {
            return JCEProvider.getProviderForAlgorithm("DH_KeyGenerator") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH_KeyGenerator"));
        }
        catch (NoSuchAlgorithmException e) {
            return KeyAgreement.getInstance("DH");
        }
    }

    public static KeyPairGenerator getDHKeyGenerator() throws NoSuchAlgorithmException {
        try {
            return JCEProvider.getProviderForAlgorithm("DH_KeyAgreement") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH_KeyAgreement"));
        }
        catch (NoSuchAlgorithmException e) {
            return KeyPairGenerator.getInstance("DH");
        }
    }

    public static void disableBouncyCastle() {
        try {
            KeyPairGenerator.getInstance("ECDSA");
            JCEProvider.setECDSAAlgorithmName("ECDSA");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                KeyPairGenerator.getInstance("EC");
                JCEProvider.setECDSAAlgorithmName("EC");
            }
            catch (NoSuchAlgorithmException e1) {
                Log.error((String)"Unable to determine correct Elliptic Curve algorithm name ", (Object[])new Object[0]);
            }
        }
        try {
            Cipher.getInstance("RSA/NONE/OAEPWithSHA-256AndMGF1Padding");
            JCEProvider.setRSAOAEPSHA256AlgorithmName("RSA/None/OAEPWithSHA-256AndMGF1Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            try {
                Cipher.getInstance("RSA/v/OAEPWithSHA256AndMGF1Padding");
                JCEProvider.setRSAOAEPSHA256AlgorithmName("RSA/None/OAEPWithSHA256AndMGF1Padding");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e1) {
                Log.error((String)"Unable to determine correct JCE algorithm name for RSA/None/OAEPWithSHA256AndMGF1Padding", (Object[])new Object[0]);
            }
        }
        try {
            Cipher.getInstance("RSA/v/OAEPWithSHA-1AndMGF1Padding");
            JCEProvider.setRSAOAEPSHA256AlgorithmName("RSA/None/OAEPWithSHA-1AndMGF1Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            try {
                Cipher.getInstance("RSA/NONE/OAEPWithSHA1AndMGF1Padding");
                JCEProvider.setRSAOAEPSHA256AlgorithmName("RSA/None/OAEPWithSHA1AndMGF1Padding");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e1) {
                Log.error((String)"Unable to determine correct JCE algorithm name for RSA/None/OAEPWithSHA1AndMGF1Padding", (Object[])new Object[0]);
            }
        }
        if (JCEProvider.isBCEnabled()) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Disabling support for Bouncycastle {} provider", (Object[])new Object[]{bcProvider.getName()});
            }
            Security.removeProvider(bcProvider.getName());
            JCEProvider.initializeDefaultProvider((Provider)null);
            specficProviders.remove("DH");
        }
        bcEnabled = false;
    }

    public static boolean isBCEnabled() {
        if (bcProvider == null) {
            return false;
        }
        return bcProvider != null && bcEnabled != null && bcEnabled != false;
    }

    public static String getECDSAAlgorithmName() {
        return ecdsaAlgorithmName;
    }

    public static void setECDSAAlgorithmName(String ecdsaAlgorithmName) {
        JCEProvider.ecdsaAlgorithmName = ecdsaAlgorithmName;
    }

    public static boolean isBCDisabled() {
        return bcEnabled != null && bcEnabled == false;
    }

    public static void setRSAOAEPSHA256AlgorithmName(String rsaOAEPWithMG1Padding) {
        rsaOAEPSHA256WithMG1Padding = rsaOAEPWithMG1Padding;
    }

    public static String getRSAOAEPSHA256AlgorithmName() {
        return rsaOAEPSHA256WithMG1Padding;
    }

    public static String getRSAOAEPSHA1AlgorithmName() {
        return rsaOAEPSHA1WithMG1Padding;
    }

    public static void setRSAOAEPSHA1AlgorithmName(String rsaOAEPWithMG1Padding) {
        rsaOAEPSHA1WithMG1Padding = rsaOAEPWithMG1Padding;
    }

    public static KeyFactory getKeyFactory(String alg) throws NoSuchAlgorithmException {
        if (JCEProvider.getProviderForAlgorithm(alg) == null) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Getting key factory algorithm {} from default provider", (Object[])new Object[]{alg});
            }
            return KeyFactory.getInstance(alg);
        }
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Getting key factory algorithm {} from provider {}", (Object[])new Object[]{alg, JCEProvider.getProviderForAlgorithm(alg)});
        }
        return KeyFactory.getInstance(alg, JCEProvider.getProviderForAlgorithm(alg));
    }

    public static Signature getSignature(String alg) throws NoSuchAlgorithmException {
        if (JCEProvider.getProviderForAlgorithm(alg) == null) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Getting signature algorithm {} from default provider", (Object[])new Object[]{alg});
            }
            return Signature.getInstance(alg);
        }
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Getting signature algorithm {} from provider {}", (Object[])new Object[]{alg, JCEProvider.getProviderForAlgorithm(alg)});
        }
        return Signature.getInstance(alg, JCEProvider.getProviderForAlgorithm(alg));
    }

    static enum BC_FLAVOR {
        BC,
        BCFIPS,
        SC;

    }
}

