/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sshd.config;

import com.sshtools.common.publickey.authorized.Patterns;
import com.sshtools.common.sshd.config.BlankEntry;
import com.sshtools.common.sshd.config.CommentEntry;
import com.sshtools.common.sshd.config.ListOrderedMap;
import com.sshtools.common.sshd.config.SshdConfigFile;
import com.sshtools.common.sshd.config.SshdConfigFileCursor;
import com.sshtools.common.sshd.config.SshdConfigFileEntry;
import com.sshtools.common.sshd.config.SshdConfigKeyValueEntry;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class Entry {
    AtomicInteger commentKey = new AtomicInteger(1);
    AtomicInteger blankKey = new AtomicInteger(1);
    protected SshdConfigFile sshdConfigFile;
    protected Map<String, SshdConfigFileEntry> keyEntries = new ListOrderedMap<String, SshdConfigFileEntry>();

    public Entry(SshdConfigFile sshdConfigFile) {
        this.sshdConfigFile = sshdConfigFile;
    }

    protected ListOrderedMap<String, SshdConfigFileEntry> getKeyEntriesOrderedMap() {
        return (ListOrderedMap)this.keyEntries;
    }

    public String getValue(String key) {
        SshdConfigFileEntry e = this.getEntry(key);
        if (Objects.isNull(e)) {
            throw new NoSuchElementException(String.format("No value exists for key %s", key));
        }
        return e.getValue();
    }

    public SshdConfigFileEntry getEntry(String key) {
        return this.getKeyEntries().get(key);
    }

    public Map<String, SshdConfigFileEntry> getKeyEntries() {
        return this.executeRead(new Callable<Map<String, SshdConfigFileEntry>>(){

            @Override
            public Map<String, SshdConfigFileEntry> call() throws Exception {
                return Entry.this.keyEntries;
            }
        });
    }

    public SshdConfigFileEntry find(final String key) {
        return this.executeRead(new Callable<SshdConfigFileEntry>(){

            @Override
            public SshdConfigFileEntry call() throws Exception {
                return Entry.this.keyEntries.get(key);
            }
        });
    }

    public void enable(String key, String value) {
        SshdConfigFileEntry e = this.find(key);
        if (Objects.nonNull(e)) {
            e.setValue(value);
            e.setCommentedOut(false);
        } else {
            this.appendEntry(new SshdConfigKeyValueEntry(key, value));
        }
    }

    public void disable(String key) {
        SshdConfigFileEntry e = this.find(key);
        if (Objects.nonNull(e)) {
            e.setCommentedOut(true);
        }
    }

    public SshdConfigKeyValueEntry findKeyValueEntry(final String key) {
        return this.executeRead(new Callable<SshdConfigKeyValueEntry>(){

            @Override
            public SshdConfigKeyValueEntry call() throws Exception {
                SshdConfigFileEntry keyValueEntry = Entry.this.keyEntries.get(key);
                if (!(keyValueEntry instanceof SshdConfigKeyValueEntry)) {
                    throw new IllegalArgumentException(String.format("Value with key `%s` is not Key Value entry of type SshdConfigKeyValueEntry", key));
                }
                return (SshdConfigKeyValueEntry)keyValueEntry;
            }
        });
    }

    public int findEntryIndex(final String key) {
        return this.executeRead(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Entry.this.getKeyEntriesOrderedMap().indexOf(key);
            }
        });
    }

    public SshdConfigFileEntry findEntryAtIndex(final int index) {
        return this.executeRead(new Callable<SshdConfigFileEntry>(){

            @Override
            public SshdConfigFileEntry call() throws Exception {
                return Entry.this.getKeyEntriesOrderedMap().getValue(index);
            }
        });
    }

    public void addCommentForEntry(final String key, final CommentEntry commentEntry) {
        this.executeWrite(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int index = Entry.this.findEntryIndex(key);
                if (index == -1) {
                    throw new IllegalArgumentException(String.format("Entry with key `%s` not found.", key));
                }
                Entry.this.getKeyEntriesOrderedMap().put(index, Entry.this.getCommentEntryKey(), commentEntry);
                return null;
            }
        });
    }

    public void addBeginingComment(final CommentEntry commentEntry) {
        this.executeWrite(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Entry.this.getKeyEntriesOrderedMap().put(0, Entry.this.getCommentEntryKey(), commentEntry);
                return null;
            }
        });
    }

    public void updateEntry(final String key, final String value) {
        this.executeWrite(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SshdConfigFileEntry entry = Entry.this.getKeyEntriesOrderedMap().get(key);
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Entry with key `%s` not found.", key));
                }
                if (entry instanceof CommentEntry || entry instanceof BlankEntry) {
                    throw new IllegalArgumentException("Entry is not a valid entry is Comment or Blank");
                }
                SshdConfigKeyValueEntry keyValueEntry = (SshdConfigKeyValueEntry)entry;
                keyValueEntry.setValue(value);
                return null;
            }
        });
    }

    public void deleteEntry(final String key) {
        this.executeWrite(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int index = Entry.this.findEntryIndex(key);
                if (index == -1) {
                    throw new IllegalArgumentException(String.format("Entry with key `%s` not found.", key));
                }
                Entry.this.getKeyEntriesOrderedMap().removeIndex(index);
                return null;
            }
        });
    }

    public void deleteEntry(final String key, final String value) {
        this.executeWrite(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int index = Entry.this.findEntryIndex(key);
                if (index == -1) {
                    throw new IllegalArgumentException(String.format("Entry with key `%s` not found.", key));
                }
                SshdConfigFileEntry e = Entry.this.getKeyEntriesOrderedMap().getValue(index);
                if (e.getValue().equals(value)) {
                    Entry.this.getKeyEntriesOrderedMap().removeIndex(index);
                    if (e.hasNext()) {
                        Entry.this.getKeyEntriesOrderedMap().put(index, key, e.getNext());
                    }
                } else {
                    SshdConfigKeyValueEntry kv = (SshdConfigKeyValueEntry)e;
                    while (e.hasNext()) {
                        if ((e = e.getNext()).getValue().equals(value)) {
                            if (e.hasNext()) {
                                kv.setNext(e.getNext());
                                break;
                            }
                            kv.setNext(null);
                            break;
                        }
                        kv = (SshdConfigKeyValueEntry)e;
                    }
                }
                return null;
            }
        });
    }

    public int addEntry(final int index, final SshdConfigFileEntry sshdConfigFileEntry) {
        return this.executeWrite(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                String key = Entry.this.resolveKey(sshdConfigFileEntry);
                if (Entry.this.keyEntries.isEmpty()) {
                    Entry.this.getKeyEntriesOrderedMap().put(key, sshdConfigFileEntry);
                    return 0;
                }
                int indexToStartLookingFrom = index == -1 ? Entry.this.keyEntries.size() - 1 : index;
                int indexToEnter = Entry.this.findLastValidEntry(indexToStartLookingFrom) + 1;
                Entry.this.getKeyEntriesOrderedMap().put(indexToEnter, key, sshdConfigFileEntry);
                return indexToEnter;
            }
        });
    }

    public void append(String key, String value) {
        this.appendEntry(new SshdConfigKeyValueEntry(key, value));
    }

    public void appendEntry(final SshdConfigFileEntry sshdConfigFileEntry) {
        this.executeWrite(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String key = Entry.this.resolveKey(sshdConfigFileEntry);
                if (Entry.this.keyEntries.containsKey(key)) {
                    SshdConfigFileEntry entry = Entry.this.keyEntries.get(key);
                    while (entry.hasNext()) {
                        entry = entry.getNext();
                    }
                    entry.setNext(sshdConfigFileEntry);
                } else {
                    Entry.this.keyEntries.put(key, sshdConfigFileEntry);
                }
                return null;
            }
        });
    }

    public Boolean entryMatches(final String key, final Collection<String> patterns) {
        return this.executeRead(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String[] parts;
                SshdConfigKeyValueEntry sshdConfigFileEntry = (SshdConfigKeyValueEntry)Entry.this.getKeyEntries().get(key);
                if (sshdConfigFileEntry != null && (parts = sshdConfigFileEntry.getValueParts()) != null) {
                    for (String part : parts) {
                        if (!Patterns.matchesWithCIDR(patterns, part)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private String resolveKey(SshdConfigFileEntry sshdConfigFileEntry) {
        String key = null;
        if (sshdConfigFileEntry instanceof SshdConfigKeyValueEntry) {
            key = ((SshdConfigKeyValueEntry)sshdConfigFileEntry).getKey();
        } else if (sshdConfigFileEntry instanceof BlankEntry) {
            key = this.getBlankEntryKey();
        } else if (sshdConfigFileEntry instanceof CommentEntry) {
            key = this.getCommentEntryKey();
        }
        return key;
    }

    private int findLastValidEntry(final int index) {
        return this.executeRead(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int localIndex = index;
                SshdConfigFileEntry value = Entry.this.getKeyEntriesOrderedMap().getValue(localIndex);
                while (!(localIndex <= 0 || value instanceof SshdConfigKeyValueEntry || value instanceof CommentEntry && ((CommentEntry)value).isNotLoaded())) {
                    value = Entry.this.getKeyEntriesOrderedMap().getValue(--localIndex);
                }
                return localIndex;
            }
        });
    }

    public String getBlankEntryKey() {
        return String.format("Blank%d", this.blankKey.getAndIncrement());
    }

    public String getCommentEntryKey() {
        return String.format("Comment%d", this.commentKey.getAndIncrement());
    }

    protected <T> T executeRead(Callable<T> callable) {
        return this.sshdConfigFile.executeRead(callable);
    }

    protected <T> T executeWrite(Callable<T> callable) {
        return this.sshdConfigFile.executeWrite(callable);
    }

    public static abstract class AbstractEntryBuilder<T> {
        protected SshdConfigFileCursor cursor = new SshdConfigFileCursor();
        protected int pointer = -1;
        protected SshdConfigFile file;

        protected abstract Entry getManagedInstance();

        public T updateEntry(String key, String value) {
            this.getManagedInstance().updateEntry(key, value);
            return (T)this;
        }

        public T deleteEntry(String key) {
            this.getManagedInstance().deleteEntry(key);
            return (T)this;
        }

        public T addComment(String comment) {
            this.addEntry(new CommentEntry(comment));
            return (T)this;
        }

        public T addCommentForEntry(String key, String comment) {
            this.getManagedInstance().addCommentForEntry(key, new CommentEntry(comment));
            return (T)this;
        }

        public T addCommentForEntry(String key, CommentEntry commentEntry) {
            this.getManagedInstance().addCommentForEntry(key, commentEntry);
            return (T)this;
        }

        public T addBeginingComment(CommentEntry commentEntry) {
            this.getManagedInstance().addBeginingComment(commentEntry);
            return (T)this;
        }

        public T addEntry(final SshdConfigFileEntry sshdConfigFileEntry) {
            return this.file.executeWrite(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    int indexToEnter = this.getManagedInstance().addEntry(pointer, sshdConfigFileEntry);
                    if (pointer != -1) {
                        pointer = indexToEnter;
                    }
                    return this;
                }
            });
        }

        public T appendEntry(SshdConfigFileEntry sshdConfigFileEntry) {
            this.getManagedInstance().appendEntry(sshdConfigFileEntry);
            return (T)this;
        }

        public SshdConfigFileEntry findEntry(String key) {
            return this.getManagedInstance().getKeyEntries().get(key);
        }

        public T findEntry(String key, Result<SshdConfigKeyValueEntry> result) {
            SshdConfigKeyValueEntry sshdConfigFileEntry = (SshdConfigKeyValueEntry)this.getManagedInstance().getKeyEntries().get(key);
            result.set(sshdConfigFileEntry);
            return (T)this;
        }

        public T entryMatches(String key, Collection<String> patterns, Result<Boolean> result) {
            result.set(this.entryMatches(key, patterns));
            return (T)this;
        }

        public Boolean entryMatches(String key, Collection<String> patterns) {
            return this.getManagedInstance().entryMatches(key, patterns);
        }

        public int findEntryIndex(String key) {
            return this.getManagedInstance().findEntryIndex(key);
        }

        public SshdConfigFileEntry findEntryAtIndex(int index) {
            return this.getManagedInstance().findEntryAtIndex(index);
        }

        public T findEntryIndex(String key, Result<Integer> result) {
            int index = this.getManagedInstance().findEntryIndex(key);
            result.set(index);
            return (T)this;
        }

        public T findEntryToEdit(final String key) {
            return this.file.executeWrite(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    int index = this.getManagedInstance().getKeyEntriesOrderedMap().indexOf(key);
                    if (index == -1) {
                        throw new IllegalArgumentException(String.format("Entry with key `%s` not found.", key));
                    }
                    pointer = index;
                    return this;
                }
            });
        }

        public T resetPointer() {
            return this.file.executeWrite(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    pointer = -1;
                    return this;
                }
            });
        }

        public SshdConfigFileCursor cursor() {
            return this.cursor;
        }

        public static interface Result<T> {
            public T get();

            public void set(T var1);
        }
    }
}

