/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.LocalForwardingFactoryImpl;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.permissions.UnauthorizedException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ConnectionStateListener;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.RemoteForward;
import com.sshtools.synergy.ssh.SocketListeningForwardingFactoryImpl;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConnectionProtocolClient
extends ConnectionProtocol<SshClientContext> {
    Map<String, RemoteForward> remoteForwards = new HashMap<String, RemoteForward>();

    public ConnectionProtocolClient(TransportProtocol<SshClientContext> transport, String username) {
        super(transport, username);
    }

    protected boolean isClient() {
        return true;
    }

    protected void onStart() {
        SshClientContext context = this.getContext();
        this.con = context.getConnectionManager().registerConnection((ConnectionProtocol)this);
        this.addTask(ExecutorOperationSupport.EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.con, new Runnable(){

            @Override
            public void run() {
                for (ConnectionStateListener connectionStateListener : ConnectionProtocolClient.this.getContext().getStateListeners()) {
                    connectionStateListener.connected((SshConnection)ConnectionProtocolClient.this.con);
                }
            }
        }));
    }

    protected void onStop() {
    }

    public int startLocalForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws UnauthorizedException, SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)("Requesting local forwarding on " + addressToBind + ":" + portToBind + " to " + destinationHost + ":" + destinationPort), (Object[])new Object[0]);
        }
        if (!this.getContext().getForwardingPolicy().checkInterfacePermitted((SshConnection)this.con, addressToBind, portToBind)) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("User not permitted to forward on " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
            }
            throw new UnauthorizedException();
        }
        int port = this.getContext().getForwardingManager().startListening(addressToBind, portToBind, this.con, (SocketListeningForwardingFactoryImpl)new LocalForwardingFactoryImpl(destinationHost, destinationPort));
        if (Log.isInfoEnabled()) {
            Log.info((String)("Local forwarding is now active on local interface " + addressToBind + ":" + portToBind + " forwarding to remote " + destinationHost + ":" + destinationPort), (Object[])new Object[0]);
        }
        return port;
    }

    public void stopLocalForwarding() {
        this.getContext().getForwardingManager().stopForwarding(this.getConnection());
    }

    public void stopLocalForwarding(String addressToBind, int portToBind) {
        this.stopLocalForwarding(addressToBind + ":" + portToBind);
    }

    public void stopLocalForwarding(String key) {
        this.getContext().getForwardingManager().stopForwarding(key, this.getConnection());
    }

    public void stopRemoteForwarding(String addressToBind, int portToBind) throws SshException {
        block12: {
            if (Log.isInfoEnabled()) {
                Log.info((String)("Canceling remote forwarding from " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
            }
            ByteArrayWriter msg = new ByteArrayWriter();
            try {
                msg.writeString(addressToBind);
                msg.writeInt(portToBind);
                GlobalRequest request = new GlobalRequest("cancel-tcpip-forward", (SshConnection)this.con, msg.toByteArray());
                this.sendGlobalRequest(request, true);
                request.waitForever();
                if (request.isSuccess()) {
                    if (Log.isInfoEnabled()) {
                        Log.info((String)("Remote forwarding cancelled on remote interface " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
                    }
                    this.remoteForwards.remove(addressToBind + ":" + portToBind);
                    this.getConnection().setProperty("remoteForwards", this.remoteForwards);
                    break block12;
                }
                throw new SshException("Cancel remote forwarding on interface " + addressToBind + ":" + portToBind + " failed", 14);
            }
            catch (IOException e) {
                throw new SshException(5, (Throwable)e);
            }
            finally {
                try {
                    msg.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void stopRemoteForwarding() {
    }

    public int startRemoteForwarding(String addressToBind, int portToBind, String destinationHost, int destinationPort) throws SshException {
        if (Log.isInfoEnabled()) {
            Log.info((String)("Requesting remote forwarding from " + addressToBind + ":" + portToBind + " to " + destinationHost + ":" + destinationPort), (Object[])new Object[0]);
        }
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            msg.writeString(addressToBind);
            msg.writeInt(portToBind);
            GlobalRequest request = new GlobalRequest("tcpip-forward", (SshConnection)this.con, msg.toByteArray());
            this.sendGlobalRequest(request, true);
            request.waitForever();
            if (request.isSuccess()) {
                if (request.getData().length > 0) {
                    try (ByteArrayReader r = new ByteArrayReader(request.getData());){
                        portToBind = (int)r.readInt();
                    }
                }
                if (Log.isInfoEnabled()) {
                    Log.info((String)("Remote forwarding is now active on remote interface " + addressToBind + ":" + portToBind + " forwarding to " + destinationHost + ":" + destinationPort), (Object[])new Object[0]);
                }
                this.remoteForwards.put(addressToBind + ":" + portToBind, new RemoteForward(destinationHost, destinationPort));
                this.getConnection().setProperty("remoteForwards", this.remoteForwards);
                int n = portToBind;
                return n;
            }
            try {
                throw new SshException("Remote forwarding on interface " + addressToBind + ":" + portToBind + " failed", 14);
            }
            catch (IOException e) {
                throw new SshException(5, (Throwable)e);
            }
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SshClientContext getContext() {
        return (SshClientContext)this.getTransport().getContext();
    }

    protected boolean processTCPIPCancel(ByteArrayReader bar, ByteArrayWriter msg) throws IOException {
        return false;
    }

    protected boolean processTCPIPForward(ByteArrayReader bar, ByteArrayWriter response) throws IOException {
        return false;
    }

    public String getName() {
        return "ssh-connection";
    }

    protected ChannelNG<SshClientContext> createChannel(String channeltype, Connection<SshClientContext> con) throws UnsupportedChannelException, PermissionDeniedException, ChannelOpenException {
        return this.getContext().getChannelFactory().createChannel(channeltype, con);
    }
}

