/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.SshClientContext;
import com.sshtools.common.ssh.SecureComponent;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import java.io.IOException;

public class SecurityReporter {
    public static void main(String[] args) throws SshException, IOException {
        SecureComponent obj;
        SshClientContext context = new SshClientContext(SecurityLevel.WEAK);
        System.out.println(String.format("%-15s%-50s%s", "Security Level", "Algorithm", "Score"));
        System.out.println("#####################################################################################");
        System.out.println("Ciphers");
        System.out.println("-------");
        for (String name : context.supportedCiphersCS().order()) {
            obj = (SecureComponent)context.supportedCiphersCS().getInstance(name);
            System.out.println(String.format("%-15s%-50s%d", obj.getSecurityLevel().name(), obj.getAlgorithm(), obj.getPriority()));
        }
        System.out.println();
        System.out.println("Macs");
        System.out.println("----");
        for (String name : context.supportedMacsCS().order()) {
            obj = (SecureComponent)context.supportedMacsCS().getInstance(name);
            System.out.println(String.format("%-15s%-50s%d", obj.getSecurityLevel().name(), obj.getAlgorithm(), obj.getPriority()));
        }
        System.out.println();
        System.out.println("Public Keys");
        System.out.println("-----------");
        for (String name : context.supportedPublicKeys().order()) {
            obj = (SecureComponent)context.supportedPublicKeys().getInstance(name);
            System.out.println(String.format("%-15s%-50s%d", obj.getSecurityLevel().name(), obj.getAlgorithm(), obj.getPriority()));
        }
        System.out.println();
        System.out.println("Key Exchange");
        System.out.println("------------");
        for (String name : context.supportedKeyExchanges().order()) {
            obj = (SecureComponent)context.supportedKeyExchanges().getInstance(name);
            System.out.println(String.format("%-15s%-50s%d", obj.getSecurityLevel().name(), obj.getAlgorithm(), obj.getPriority()));
        }
    }
}

