/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.SshClient;
import com.sshtools.client.tasks.DownloadFileTask;
import com.sshtools.client.tasks.UploadFileTask;
import com.sshtools.common.logger.Log;
import java.io.File;

public class Ssh {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getFile(String host, int port, String username, char[] password, String fromPath, File toFile) {
        try (SshClient client = new SshClient(host, port, username, password);){
            DownloadFileTask task = new DownloadFileTask(client.getConnection(), fromPath, toFile);
            client.addTask(task);
            task.waitForever();
            boolean bl = task.isDone() && task.isSuccess();
            return bl;
        }
        catch (Throwable e) {
            Log.error((String)"getFile failed", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean putFile(String host, int port, String username, char[] password, File fromFile, String toPath) {
        try (SshClient client = new SshClient(host, port, username, password);){
            UploadFileTask task = new UploadFileTask(client.getConnection(), fromFile, toPath);
            client.addTask(task);
            task.waitForever();
            boolean bl = task.isDone() && task.isSuccess();
            return bl;
        }
        catch (Throwable e) {
            Log.error((String)"putFile failed", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
    }
}

