/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.components;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.SshKeyExchangeClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.ECUtils;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;

public class DiffieHellmanEcdh
extends SshKeyExchangeClient
implements SshKeyExchange<SshClientContext> {
    public static final int SSH_MSG_KEX_ECDH_INIT = 30;
    public static final int SSH_MSG_KEX_ECDH_REPLY = 31;
    String name;
    String curve;
    byte[] Q_S;
    byte[] Q_C;
    String clientId;
    String serverId;
    byte[] clientKexInit;
    byte[] serverKexInit;
    SshPrivateKey prvkey;
    SshPublicKey pubkey;
    KeyPairGenerator keyGen;
    KeyAgreement keyAgreement;
    KeyPair keyPair;

    protected DiffieHellmanEcdh(String name, String curve, String hashAlgorithm, SecurityLevel securityLevel, int priority) {
        super(hashAlgorithm, securityLevel, priority);
        this.name = name;
        this.curve = curve;
    }

    public String getAlgorithm() {
        return this.name;
    }

    @Override
    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getDefaultInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putInt(this.Q_C.length);
        hash.putBytes(this.Q_C);
        hash.putInt(this.Q_S.length);
        hash.putBytes(this.Q_S);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public void init(SshTransport<SshClientContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        try {
            this.transport = transport;
            this.clientId = clientId;
            this.serverId = serverId;
            this.clientKexInit = clientKexInit;
            this.serverKexInit = serverKexInit;
            this.firstPacketFollows = firstPacketFollows;
            this.useFirstPacket = useFirstPacket;
            this.initCrypto();
            ECPublicKey ec = (ECPublicKey)this.keyPair.getPublic();
            this.Q_C = ECUtils.toByteArray((ECPoint)ec.getW(), (EllipticCurve)ec.getParams().getCurve());
            transport.postMessage(new SshMessage(){

                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    buf.put((byte)30);
                    buf.putInt(DiffieHellmanEcdh.this.Q_C.length);
                    buf.put(DiffieHellmanEcdh.this.Q_C);
                    return true;
                }

                public void messageSent(Long sequenceNo) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Sent SSH_MSG_KEX_ECDH_INIT", (Object[])new Object[0]);
                    }
                }
            }, true);
        }
        catch (SshException e) {
            throw new SshIOException(e);
        }
        catch (Exception e) {
            throw new SshException((Throwable)e, 9);
        }
    }

    @Override
    public boolean processMessage(byte[] msg) throws SshException, IOException {
        if (msg[0] != 31) {
            return false;
        }
        try (ByteArrayReader reply = new ByteArrayReader(msg, 1, msg.length - 1);){
            this.hostKey = reply.readBinaryString();
            this.Q_S = reply.readBinaryString();
            this.signature = reply.readBinaryString();
            this.keyAgreement.doPhase(ECUtils.decodeKey((byte[])this.Q_S, (String)this.curve), true);
            byte[] tmp = this.keyAgreement.generateSecret();
            if ((tmp[0] & 0x80) == 128) {
                byte[] tmp2 = new byte[tmp.length + 1];
                System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                tmp = tmp2;
            }
            this.secret = new BigInteger(tmp);
            this.calculateExchangeHash();
            this.transport.sendNewKeys();
            boolean bl = true;
            return bl;
        }
    }

    public String getProvider() {
        return this.keyGen.getProvider().getName();
    }

    private void initCrypto() throws InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SshException {
        ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        this.keyGen = JCEProvider.getProviderForAlgorithm((String)JCEProvider.getECDSAAlgorithmName()) == null ? KeyPairGenerator.getInstance(JCEProvider.getECDSAAlgorithmName()) : KeyPairGenerator.getInstance(JCEProvider.getECDSAAlgorithmName(), JCEProvider.getProviderForAlgorithm((String)JCEProvider.getECDSAAlgorithmName()));
        this.keyAgreement = JCEProvider.getProviderForAlgorithm((String)"ECDH") == null ? KeyAgreement.getInstance("ECDH") : KeyAgreement.getInstance("ECDH", JCEProvider.getProviderForAlgorithm((String)"ECDH"));
        ECGenParameterSpec namedSpec = new ECGenParameterSpec(this.curve);
        this.keyGen.initialize(namedSpec);
        this.keyPair = this.keyGen.generateKeyPair();
        this.keyAgreement.init(this.keyPair.getPrivate());
    }

    public void test() throws IOException, SshException {
        try {
            this.initCrypto();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

