/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.common.files.AbstractFileRandomAccess;
import java.io.IOException;
import java.io.InputStream;

public class ChunkInputStream
extends InputStream {
    AbstractFileRandomAccess file;
    long length;

    public ChunkInputStream(AbstractFileRandomAccess file, long length) {
        this.file = file;
        this.length = length;
    }

    @Override
    public int available() throws IOException {
        return this.length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.length;
    }

    @Override
    public int read() throws IOException {
        if (this.length > 0L) {
            int r = this.file.read();
            --this.length;
            return r;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.length > 0L) {
            int max = (int)Math.min((long)len, this.length);
            int r = this.file.read(b, off, max);
            this.length -= (long)r;
            return r;
        }
        return -1;
    }
}

