/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.components;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.SshKeyExchangeClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.ssh.components.DiffieHellmanGroups;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.jce.AbstractKeyExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public abstract class DiffieHellmanGroupExchange
extends SshKeyExchangeClient
implements AbstractKeyExchange {
    static final int SSH_MSG_KEY_DH_GEX_REQUEST_OLD = 30;
    static final int SSH_MSG_KEY_DH_GEX_GROUP = 31;
    static final int SSH_MSG_KEY_DH_GEX_INIT = 32;
    static final int SSH_MSG_KEY_DH_GEX_REPLY = 33;
    static final int SSH_MSG_KEY_DH_GEX_REQUEST = 34;
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO = BigInteger.valueOf(2L);
    BigInteger g = null;
    BigInteger p = null;
    BigInteger e = null;
    BigInteger f = null;
    BigInteger y = null;
    BigInteger x = null;
    UnsignedInteger32 min = null;
    UnsignedInteger32 n = null;
    UnsignedInteger32 max = null;
    KeyPairGenerator dhKeyPairGen;
    KeyAgreement dhKeyAgreement;
    KeyFactory dhKeyFactory;
    KeyPair dhKeyPair;
    String kexAlgorithm;
    String hashAlgorithm;
    static int maxSupportedSize = -1;
    static int minSupportedSize = -1;

    public DiffieHellmanGroupExchange(String kexAlgorithm, String hashAlgorithm, SecurityLevel securityLevel, int priority) {
        super(hashAlgorithm, securityLevel, priority);
        this.kexAlgorithm = kexAlgorithm;
    }

    public String getAlgorithm() {
        return this.kexAlgorithm;
    }

    public void init(final SshTransport<SshClientContext> transport, String clientIdentification, String serverIdentification, byte[] clientKexInit, byte[] serverKexInit, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        this.clientId = clientIdentification;
        this.serverId = serverIdentification;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.firstPacketFollows = firstPacketFollows;
        this.useFirstPacket = useFirstPacket;
        this.transport = transport;
        try {
            this.initCrypto();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SshIOException(new SshException("JCE does not support Diffie Hellman key exchange", 16));
        }
        this.verifyDHPrimeThresholds();
        transport.postMessage(new SshMessage(){

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                int minimumSize = DiffieHellmanGroupExchange.this.maybeLog("Minimum DH prime", Math.min(maxSupportedSize, Math.max(((SshClientContext)transport.getContext()).getMinDHGroupExchangeKeySize(), 1024)));
                int preferredKeySize = DiffieHellmanGroupExchange.this.maybeLog("Preferred DH prime", Math.min(maxSupportedSize, ((SshClientContext)transport.getContext()).getPreferredDHGroupExchangeKeySize()));
                int maximumSize = DiffieHellmanGroupExchange.this.maybeLog("Maximum DH prime", Math.min(maxSupportedSize, ((SshClientContext)transport.getContext()).getMaxDHGroupExchangeKeySize()));
                buf.put((byte)34);
                buf.putInt(minimumSize);
                DiffieHellmanGroupExchange.this.min = new UnsignedInteger32((long)minimumSize);
                buf.putInt(preferredKeySize);
                DiffieHellmanGroupExchange.this.n = new UnsignedInteger32((long)preferredKeySize);
                buf.putInt(maximumSize);
                DiffieHellmanGroupExchange.this.max = new UnsignedInteger32((long)maximumSize);
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_KEY_DH_GEX_REQUEST", (Object[])new Object[0]);
                }
            }
        }, true);
    }

    private int maybeLog(String txt, int size) {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"{} size is {}", (Object[])new Object[]{txt, size});
        }
        return size;
    }

    private void verifyDHPrimeThresholds() {
        if (minSupportedSize == -1) {
            Provider provider = this.dhKeyAgreement.getProvider();
            if (provider != null && provider.getName().equals("BC")) {
                minSupportedSize = 1024;
                maxSupportedSize = 8192;
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Using BC for DH; prime range is {} to {} bits", (Object[])new Object[]{minSupportedSize, maxSupportedSize});
                }
            } else {
                for (BigInteger p : DiffieHellmanGroups.allDefaultGroups()) {
                    try {
                        DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, TWO);
                        this.dhKeyPairGen.initialize(dhSkipParamSpec);
                        KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                        this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                        if (minSupportedSize == -1) {
                            minSupportedSize = p.bitLength();
                        }
                        maxSupportedSize = p.bitLength();
                    }
                    catch (Exception e) {
                        Log.warn((String)"DH prime size {} will not be supported because {}", (Object[])new Object[]{p.bitLength(), e.getMessage()});
                    }
                }
                if (maxSupportedSize == -1) {
                    throw new IllegalStateException("The diffie hellman algorithm does not appear to be configured correctly on this machine");
                }
                if (maxSupportedSize < 2048) {
                    throw new IllegalStateException(String.format("The maximum supported DH prime is %d bits which is smaller than this algorithm requires", maxSupportedSize));
                }
                if (Log.isInfoEnabled()) {
                    Log.info((String)"The supported DH prime range is {} to {} bits", (Object[])new Object[]{minSupportedSize, maxSupportedSize});
                }
            }
        }
    }

    private void initCrypto() throws NoSuchAlgorithmException {
        this.dhKeyFactory = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
        this.dhKeyPairGen = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
        this.dhKeyAgreement = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
    }

    public String getProvider() {
        if (this.dhKeyAgreement != null) {
            return this.dhKeyAgreement.getProvider().getName();
        }
        return "";
    }

    public boolean exchangeGroup(ByteArrayReader msg) throws SshException, IOException {
        switch (msg.read()) {
            case 31: {
                this.p = msg.readBigInteger();
                this.g = msg.readBigInteger();
                break;
            }
            default: {
                return false;
            }
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Received {} bit DH prime with group {}", (Object[])new Object[]{this.p.bitLength(), this.g.toString(16)});
        }
        if (this.p.bitLength() > maxSupportedSize) {
            throw new SshException(String.format("Server sent a prime larger than our configuration can handle! p=%d, max=%d", this.p.bitLength(), maxSupportedSize), 5);
        }
        if (this.g.compareTo(BigInteger.ONE) <= 0) {
            throw new SshException("Invalid DH g value [" + this.g.toString(16) + "]", 3);
        }
        if ((long)this.p.bitLength() < Math.max(this.min.longValue(), 1024L)) {
            throw new SshException("Minimum DH p value not provided [" + this.p.bitLength() + "]", 3);
        }
        try {
            if (Boolean.getBoolean("maverick.dhBypassJCE") || this.p.bitLength() % 64 != 0) {
                this.calculateE();
            } else {
                this.calculateEwithJCE();
            }
        }
        catch (Throwable ex) {
            throw new SshException("Failed to generate DH value", 16);
        }
        final byte[] eBytes = this.e.toByteArray();
        this.transport.postMessage(new SshMessage(){

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                buf.put((byte)32);
                buf.putInt(eBytes.length);
                buf.put(eBytes);
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_KEXDH_INIT", (Object[])new Object[0]);
                }
            }
        }, true);
        return true;
    }

    private void calculateKwithJCE() throws InvalidKeySpecException, InvalidKeyException, IllegalStateException {
        DHPublicKeySpec spec = new DHPublicKeySpec(this.f, this.p, this.g);
        DHPublicKey key = (DHPublicKey)this.dhKeyFactory.generatePublic(spec);
        this.dhKeyAgreement.doPhase(key, true);
        byte[] tmp = this.dhKeyAgreement.generateSecret();
        if ((tmp[0] & 0x80) == 128) {
            byte[] tmp2 = new byte[tmp.length + 1];
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            tmp = tmp2;
        }
        this.secret = new BigInteger(tmp);
    }

    private void calculateK() {
        this.secret = this.f.modPow(this.x, this.p);
    }

    private void calculateEwithJCE() throws SshException, InvalidKeyException {
        KeyPair dhKeyPair = null;
        int retry = 3;
        do {
            if (retry == 0) {
                this.transport.disconnect(3, "Failed to generate key exchange value");
                throw new SshException("Key exchange failed to generate e value", 5);
            }
            --retry;
            try {
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, this.g);
                this.dhKeyPairGen.initialize(dhSkipParamSpec);
                dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                this.e = ((DHPublicKey)dhKeyPair.getPublic()).getY();
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new SshException("Failed to generate DH value: " + ex.getMessage(), 16, (Throwable)ex);
            }
        } while (this.e.compareTo(ONE) < 0 || this.e.compareTo(this.p.subtract(ONE)) > 0);
    }

    private void calculateE() throws SshException, NoSuchAlgorithmException {
        if (Log.isDebugEnabled()) {
            if (Boolean.getBoolean("maverick.dhBypassJCE")) {
                Log.debug((String)"Performing DH e parameter calculation manually because it has been forced by system configuration", (Object[])new Object[0]);
            } else {
                Log.debug((String)"Performing DH e parameter calculation manually because P bit length is not multiple of 64 [{}]", (Object[])new Object[]{this.p.bitLength()});
            }
        }
        int retry = 3;
        do {
            if (retry == 0) {
                this.transport.disconnect(3, "Failed to generate key exchange value");
                throw new SshException("Key exchange failed to generate e value", 5);
            }
            --retry;
            SecureRandom rnd = JCEComponentManager.getSecureRandom();
            int maxBits = this.p.subtract(BigInteger.ONE).divide(new BigInteger("2")).bitLength();
            this.x = new BigInteger(maxBits, rnd);
            this.e = this.g.modPow(this.x, this.p);
        } while (this.e.compareTo(ONE) < 0 || this.e.compareTo(this.p.subtract(ONE)) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processMessage(byte[] m) throws SshException, IOException {
        try (ByteArrayReader msg = new ByteArrayReader(m);){
            if (this.exchangeGroup(msg)) {
                boolean bl = true;
                return bl;
            }
            msg.reset();
            if (msg.read() != 33) {
                boolean bl = false;
                return bl;
            }
            try {
                this.hostKey = msg.readBinaryString();
                this.f = msg.readBigInteger();
                this.signature = msg.readBinaryString();
                if (Log.isTraceEnabled()) {
                    Log.trace((String)("P: " + this.p.toString(16)), (Object[])new Object[0]);
                    Log.trace((String)("G: " + this.g.toString(16)), (Object[])new Object[0]);
                    Log.trace((String)("F: " + this.f.toString(16)), (Object[])new Object[0]);
                    Log.trace((String)("E: " + this.e.toString(16)), (Object[])new Object[0]);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Verifying server DH parameters", (Object[])new Object[0]);
                }
                if (!DiffieHellmanGroups.verifyParameters((BigInteger)this.f, (BigInteger)this.p)) {
                    throw new SshException(String.format("Key exchange detected invalid f value %s", this.f.toString(16)), 3);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Verified DH parameters. Performing DH calculations", (Object[])new Object[0]);
                }
                if (Boolean.getBoolean("maverick.dhBypassJCE") || this.p.bitLength() % 64 != 0) {
                    this.calculateK();
                } else {
                    this.calculateKwithJCE();
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Verifying calculated DH parameters", (Object[])new Object[0]);
                }
                if (!DiffieHellmanGroups.verifyParameters((BigInteger)this.secret, (BigInteger)this.p)) {
                    throw new SshException(String.format("Key exchange detected invalid k value %s", this.e.toString(16)), 3);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Calculating exchange hash", (Object[])new Object[0]);
                }
                this.calculateExchangeHash();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Completed key exchange calculations", (Object[])new Object[0]);
                }
                this.transport.sendNewKeys();
            }
            catch (Exception ex) {
                throw new SshException("Failed to read SSH_MSG_KEXDH_REPLY from message buffer", 5, (Throwable)ex);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)((SshClientContext)this.transport.getContext()).getComponentManager().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putInt(this.min.intValue());
        hash.putInt(this.n.intValue());
        hash.putInt(this.max.intValue());
        hash.putBigInteger(this.p);
        hash.putBigInteger(this.g);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public boolean isKeyExchangeMessage(int messageid) {
        switch (messageid) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public void init(SshTransport<SshClientContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        this.init(transport, clientId, serverId, clientKexInit, serverKexInit, firstPacketFollows, useFirstPacket);
    }

    public void test() throws IOException, SshException {
        try {
            this.initCrypto();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

