/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.client.sftp.SftpHandle;
import com.sshtools.client.sftp.SftpMessage;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.AbstractSubsystem;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.client.tasks.MessageHolder;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.sftp.PosixPermissions;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.RequestFuture;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.Base64;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import com.sshtools.synergy.ssh.ByteArrays;
import com.sshtools.synergy.ssh.PacketPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class SftpChannel
extends AbstractSubsystem {
    private String CHARSET_ENCODING = "UTF-8";
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int OPEN_TEXT = 64;
    static final int STATUS_FX_OK = 0;
    static final int STATUS_FX_EOF = 1;
    static final int SSH_FXP_INIT = 1;
    static final int SSH_FXP_VERSION = 2;
    static final int SSH_FXP_OPEN = 3;
    static final int SSH_FXP_CLOSE = 4;
    static final int SSH_FXP_READ = 5;
    static final int SSH_FXP_WRITE = 6;
    static final int SSH_FXP_LSTAT = 7;
    static final int SSH_FXP_FSTAT = 8;
    static final int SSH_FXP_SETSTAT = 9;
    static final int SSH_FXP_FSETSTAT = 10;
    static final int SSH_FXP_OPENDIR = 11;
    static final int SSH_FXP_READDIR = 12;
    static final int SSH_FXP_REMOVE = 13;
    static final int SSH_FXP_MKDIR = 14;
    static final int SSH_FXP_RMDIR = 15;
    static final int SSH_FXP_REALPATH = 16;
    static final int SSH_FXP_STAT = 17;
    static final int SSH_FXP_RENAME = 18;
    static final int SSH_FXP_READLINK = 19;
    static final int SSH_FXP_SYMLINK = 20;
    static final int SSH_FXP_LINK = 21;
    static final int SSH_FXP_BLOCK = 22;
    static final int SSH_FXP_UNBLOCK = 23;
    public static final int SSH_FXP_STATUS = 101;
    public static final int SSH_FXP_HANDLE = 102;
    public static final int SSH_FXP_DATA = 103;
    public static final int SSH_FXP_NAME = 104;
    public static final int SSH_FXP_ATTRS = 105;
    public static final int SSH_FXP_EXTENDED = 200;
    public static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int MAX_VERSION = 6;
    Long supportedAttributeMask;
    Long supportedAttributeBits;
    Long supportedOpenFileFlags;
    Long supportedAccessMask;
    short supportedOpenBlockVector;
    short supportedBlockVector;
    Integer maxReadSize;
    Set<String> supportedExtensions = new HashSet<String>();
    Set<String> supportedAttrExtensions = new HashSet<String>();
    int version = 6;
    int serverVersion = -1;
    UnsignedInteger32 nextRequestId = new UnsignedInteger32(0L);
    Map<UnsignedInteger32, SftpMessage> responses = new ConcurrentHashMap<UnsignedInteger32, SftpMessage>();
    SftpThreadSynchronizer sync = new SftpThreadSynchronizer();
    Map<String, byte[]> extensions = new HashMap<String, byte[]>();
    Map<byte[], SftpHandle> handles = Collections.synchronizedMap(new HashMap());
    public static final int SSH_FXF_ACCESS_DISPOSITION = 7;
    public static final int SSH_FXF_CREATE_NEW = 0;
    public static final int SSH_FXF_CREATE_TRUNCATE = 1;
    public static final int SSH_FXF_OPEN_EXISTING = 2;
    public static final int SSH_FXF_OPEN_OR_CREATE = 3;
    public static final int SSH_FXF_TRUNCATE_EXISTING = 4;
    public static final int SSH_FXF_ACCESS_APPEND_DATA = 8;
    public static final int SSH_FXF_ACCESS_APPEND_DATA_ATOMIC = 16;
    public static final int SSH_FXF_ACCESS_TEXT_MODE = 32;
    public static final int SSH_FXF_ACCESS_BLOCK_READ = 64;
    public static final int SSH_FXF_ACCESS_BLOCK_WRITE = 128;
    public static final int SSH_FXF_ACCESS_BLOCK_DELETE = 256;
    public static final int SSH_FXF_ACCESS_BLOCK_ADVISORY = 512;
    public static final int SSH_FXF_NOFOLLOW = 1024;
    public static final int SSH_FXF_DELETE_ON_CLOSE = 2048;
    public static final int SSH_FXF_ACCESS_AUDIT_ALARM_INFO = 4096;
    public static final int SSH_FXF_ACCESS_BACKUP = 8192;
    public static final int SSH_FXF_BACKUP_STREAM = 16384;
    public static final int SSH_FXF_OVERRIDE_OWNER = 32768;
    public static final int SSH_FXP_RENAME_OVERWRITE = 1;
    public static final int SSH_FXP_RENAME_ATOMIC = 2;
    public static final int SSH_FXP_RENAME_NATIVE = 4;

    public SftpChannel(SshConnection con) throws SshException {
        super(con);
        con.setProperty("sftpVersion", (Object)this.initializeSftp(this.session));
    }

    public int getVersion() {
        return (Integer)this.con.getProperty("sftpVersion");
    }

    @Override
    protected UnsignedInteger32 getMinimumWindowSize() {
        return ((FileSystemPolicy)this.con.getContext().getPolicy(FileSystemPolicy.class)).getSftpMinWindowSize();
    }

    @Override
    protected UnsignedInteger32 getMaximumWindowSize() {
        return ((FileSystemPolicy)this.con.getContext().getPolicy(FileSystemPolicy.class)).getSftpMaxWindowSize();
    }

    @Override
    protected int getMaximumPacketSize() {
        return ((FileSystemPolicy)this.con.getContext().getPolicy(FileSystemPolicy.class)).getSftpMaxPacketSize();
    }

    public Map<String, byte[]> getExtensions() {
        return (Map)this.con.getProperty("sftpExtensions");
    }

    @Override
    public SessionChannelNG getSession() {
        return super.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private int initializeSftp(SessionChannelNG session) throws SshException {
        try {
            RequestFuture future = session.startSubsystem("sftp");
            if (!future.waitFor(this.timeout).isSuccess()) {
                throw new SshException("Could not start sftp subsystem", 10);
            }
            Packet packet = PacketPool.getInstance().getPacket();
            packet.write(1);
            packet.writeInt(6);
            this.sendMessage(packet);
            byte[] msg = this.nextMessage();
            try {
                int n;
                if (msg[0] != 2) {
                    session.close();
                    throw new SshException("Unexpected response from SFTP subsystem.", 6);
                }
                ByteArrayReader bar = new ByteArrayReader(msg);
                try {
                    bar.skip(1L);
                    int serverVersion = (int)bar.readInt();
                    int requestedVersion = 6;
                    this.version = Math.min(serverVersion, requestedVersion);
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Version is " + this.version + " [Server=" + serverVersion + " Client=" + requestedVersion + "]"), (Object[])new Object[0]);
                    }
                    try {
                        while (bar.available() > 0) {
                            String name = bar.readString();
                            byte[] data = bar.readBinaryString();
                            this.extensions.put(name, data);
                            if (!Log.isTraceEnabled()) continue;
                            Log.trace((String)("Processed extension '" + name + "'"), (Object[])new Object[0]);
                        }
                    }
                    catch (Throwable name) {
                        // empty catch block
                    }
                    if (this.version == 5) {
                        if (this.extensions.containsKey("supported")) {
                            this.processSupported(this.extensions.get("supported"));
                        }
                    } else if (this.version >= 6 && this.extensions.containsKey("supported2")) {
                        this.processSupported2(this.extensions.get("supported2"));
                    }
                    if (this.version <= 3) {
                        this.setCharsetEncoding("ISO-8859-1");
                    } else if (this.extensions.containsKey("filename-charset")) {
                        String newCharset = new String(this.extensions.get("filename-charset"), "UTF-8");
                        try {
                            this.setCharsetEncoding(newCharset);
                            this.sendExtensionMessage("filename-translation-control", new byte[]{0});
                        }
                        catch (Exception e) {
                            this.setCharsetEncoding("UTF8");
                            this.sendExtensionMessage("filename-translation-control", new byte[]{1});
                        }
                    } else {
                        this.setCharsetEncoding("UTF8");
                    }
                    this.con.setProperty("sftpExtensions", this.extensions);
                    n = this.version;
                }
                catch (Throwable throwable) {
                    bar.close();
                    throw throwable;
                }
                bar.close();
                return n;
            }
            finally {
                ByteArrays.getInstance().releaseByteArray(msg);
            }
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(6, (Throwable)ex);
        }
        catch (Throwable t) {
            throw new SshException(6, t);
        }
    }

    public byte[] getCanonicalNewline() throws SftpStatusException {
        if (this.version <= 3) {
            throw new SftpStatusException(8, "Newline setting not available for SFTP versions <= 3");
        }
        if (!this.extensions.containsKey("newline")) {
            return "\r\n".getBytes();
        }
        return this.extensions.get("newline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSupported2(byte[] data) throws IOException {
        try (ByteArrayReader supportedStructure = new ByteArrayReader(data);){
            String ext;
            int i;
            int count;
            this.supportedAttributeMask = supportedStructure.readInt();
            this.supportedAttributeBits = supportedStructure.readInt();
            this.supportedOpenFileFlags = supportedStructure.readInt();
            this.supportedAccessMask = supportedStructure.readInt();
            this.maxReadSize = (int)supportedStructure.readInt();
            this.supportedOpenBlockVector = supportedStructure.readShort();
            this.supportedBlockVector = supportedStructure.readShort();
            if (supportedStructure.available() >= 4) {
                count = (int)supportedStructure.readInt();
                for (i = 0; i < count; ++i) {
                    ext = supportedStructure.readString();
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Server supports '" + ext + "' attribute extension"), (Object[])new Object[0]);
                    }
                    this.supportedAttrExtensions.add(ext);
                }
            }
            if (supportedStructure.available() >= 4) {
                count = (int)supportedStructure.readInt();
                for (i = 0; i < count; ++i) {
                    ext = supportedStructure.readString();
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)("Server supports '" + ext + "' extension"), (Object[])new Object[0]);
                    }
                    this.supportedExtensions.add(ext);
                }
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)("supported-attribute-mask: " + this.supportedAttributeMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-attribute-bits: " + this.supportedAttributeBits.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-open-flags: " + this.supportedOpenFileFlags.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-access-mask: " + this.supportedAccessMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("max-read-size: " + this.maxReadSize.toString()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSupported(byte[] data) throws IOException {
        try (ByteArrayReader supportedStructure = new ByteArrayReader(data);){
            this.supportedAttributeMask = supportedStructure.readInt();
            this.supportedAttributeBits = supportedStructure.readInt();
            this.supportedOpenFileFlags = supportedStructure.readInt();
            this.supportedAccessMask = supportedStructure.readInt();
            this.maxReadSize = (int)supportedStructure.readInt();
            while (supportedStructure.available() >= 4) {
                String ext = supportedStructure.readString();
                if (Log.isTraceEnabled()) {
                    Log.trace((String)("Server supports '" + ext + "' extension"), (Object[])new Object[0]);
                }
                this.supportedExtensions.add(ext);
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)("supported-attribute-mask: " + this.supportedAttributeMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-attribute-bits: " + this.supportedAttributeBits.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-open-flags: " + this.supportedOpenFileFlags.toString()), (Object[])new Object[0]);
                Log.trace((String)("supported-access-mask: " + this.supportedAccessMask.toString()), (Object[])new Object[0]);
                Log.trace((String)("max-read-size: " + this.maxReadSize.toString()), (Object[])new Object[0]);
            }
        }
    }

    public void setCharsetEncoding(String charset) throws SshException, UnsupportedEncodingException {
        if (this.version == -1) {
            throw new SshException("SFTP Channel must be initialized before setting character set encoding", 4);
        }
        String test = "123456890";
        test.getBytes(charset);
        this.CHARSET_ENCODING = charset;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public String getCharsetEncoding() {
        return this.CHARSET_ENCODING;
    }

    public boolean supportsExtension(String name) {
        return this.extensions.containsKey(name);
    }

    public byte[] getExtension(String name) {
        return this.extensions.get(name);
    }

    UnsignedInteger32 nextRequestId() {
        this.nextRequestId = UnsignedInteger32.add((UnsignedInteger32)this.nextRequestId, (long)1L);
        return this.nextRequestId;
    }

    public void close() {
        this.responses.clear();
        this.getSession().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpMessage getResponse(UnsignedInteger32 requestId) throws SshException {
        MessageHolder holder = new MessageHolder();
        holder.msg = this.responses.get(requestId);
        while (holder.msg == null) {
            try {
                if (!this.sync.requestBlock(requestId, holder)) continue;
                try {
                    SftpMessage msg = new SftpMessage(this.nextMessage());
                    this.responses.put(new UnsignedInteger32((long)msg.getMessageId()), msg);
                    if (!Log.isTraceEnabled()) continue;
                    Log.trace((String)("There are " + this.responses.size() + " SFTP responses waiting to be processed"), (Object[])new Object[0]);
                }
                finally {
                    this.sync.releaseBlock();
                }
            }
            catch (InterruptedException e) {
                this.close();
                throw new SshException("The thread was interrupted", 6);
            }
            catch (IOException ex) {
                throw new SshException(5, (Throwable)ex);
            }
        }
        SftpMessage m = this.responses.remove(requestId);
        return m;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void changePermissions(byte[] file, int permissions) throws SftpStatusException, SshException {
        this.changePermissions(file, PosixPermissions.PosixPermissionsBuilder.create().fromBitmask((long)permissions).build());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void changePermissions(String filename, int permissions) throws SftpStatusException, SshException {
        this.changePermissions(filename, PosixPermissions.PosixPermissionsBuilder.create().fromBitmask((long)permissions).build());
    }

    public void changePermissions(byte[] handle, PosixPermissions permissions) throws SftpStatusException, SshException {
        SftpFileAttributes.SftpFileAttributesBuilder bldr = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)5, (String)this.getCharsetEncoding());
        bldr.withPermissions(permissions);
        this.setAttributes(handle, bldr.build());
    }

    public void changePermissions(String filename, PosixPermissions permissions) throws SftpStatusException, SshException {
        SftpFileAttributes.SftpFileAttributesBuilder bldr = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)5, (String)this.getCharsetEncoding());
        bldr.withPermissions(permissions);
        this.setAttributes(filename, bldr.build());
    }

    public void changePermissions(String filename, String permissions) throws SftpStatusException, SshException {
        SftpFileAttributes.SftpFileAttributesBuilder attrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)5, (String)this.getCharsetEncoding());
        attrs.withPermissions(PosixPermissions.PosixPermissionsBuilder.create().fromFileModeString(permissions).build());
        this.setAttributes(filename, attrs.build());
    }

    public void getOKRequestStatus(UnsignedInteger32 requestId, String path) throws SftpStatusException, SshException {
        SftpMessage bar = this.getResponse(requestId);
        try {
            if (bar.getType() == 101) {
                this.processStatusResponse(bar, path, requestId);
                return;
            }
            try {
                this.close();
                throw new SshException("The server responded with an unexpected message!", 6);
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
        finally {
            bar.release();
        }
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setAttributes(SftpFile path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        path.attributes(attrs);
    }

    public void setAttributes(String path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(9);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.write(attrs.toByteArray(this.getVersion()));
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_SETSTAT for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, path);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex, 5);
        }
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void setAttributes(byte[] handle, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (!this.isValidHandle(handle)) {
            throw new SftpStatusException(100, "The handle is not an open file handle!");
        }
        this.getBestHandle(handle).setAttributes(attrs);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public UnsignedInteger32 postWriteRequest(byte[] handle, long position, byte[] data, int off, int len) throws SftpStatusException, SshException {
        return this.getBestHandle(handle).postWriteRequest(position, data, off, len);
    }

    public void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws SftpStatusException, SshException {
        SftpHandle h = this.getBestHandle(handle);
        this.getOKRequestStatus(h.postWriteRequest(offset.longValue(), data, off, len), h.getFile() == null ? "<fileless-handle>" : h.getFile().getAbsolutePath());
    }

    public void performOptimizedWrite(String filename, byte[] handle, int blocksize, int maxAsyncRequests, InputStream in, int buffersize, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedWrite(filename, handle, blocksize, maxAsyncRequests, in, buffersize, progress, 0L);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void performOptimizedWrite(String filename, byte[] handle, int blocksize, int maxAsyncRequests, InputStream in, int buffersize, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.getBestHandle(handle).performOptimizedWrite(filename, blocksize, maxAsyncRequests, in, buffersize, progress, position);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void performOptimizedRead(String filename, byte[] handle, long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedRead(filename, handle, length, blocksize, out, outstandingRequests, progress, 0L);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void performOptimizedRead(String filename, byte[] handle, long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.getBestHandle(handle).performOptimizedRead(length, blocksize, out, outstandingRequests, progress, position);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void performSynchronousRead(byte[] handle, int blocksize, OutputStream out, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.getBestHandle(handle).performSynchronousRead(blocksize, out, progress, position);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public UnsignedInteger32 postReadRequest(byte[] handle, long offset, int len) throws SftpStatusException, SshException {
        return this.getBestHandle(handle).postReadRequest(offset, len);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public int readFile(byte[] handle, UnsignedInteger64 offset, byte[] output, int off, int len) throws SftpStatusException, SshException {
        return this.getBestHandle(handle).readFile(offset, output, off, len);
    }

    public SftpFile getFile(String path) throws SftpStatusException, SshException {
        String absolute = this.getAbsolutePath(path);
        return new SftpFile(absolute, this.getAttributes(absolute), this, null);
    }

    public String getAbsolutePath(SftpFile file) throws SftpStatusException, SshException {
        return this.getAbsolutePath(file.getFilename());
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void lockFile(byte[] handle, long offset, long length, int lockFlags) throws SftpStatusException, SshException {
        if (this.version < 6) {
            throw new SftpStatusException(8, "Locks are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        SftpHandle h = this.getBestHandle(handle);
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(22);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeInt(lockFlags);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_BLOCK for {}", (Object[])new Object[]{h.getFile().getAbsolutePath()});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, h.getFile().getAbsolutePath());
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void unlockFile(byte[] handle, long offset, long length) throws SftpStatusException, SshException {
        if (this.version < 6) {
            throw new SftpStatusException(8, "Locks are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        SftpHandle h = this.getBestHandle(handle);
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(23);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_UNBLOCK for {}", (Object[])new Object[]{h.getFile().getAbsolutePath()});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, h.getFile().getAbsolutePath());
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void createSymbolicLink(String targetpath, String linkpath) throws SftpStatusException, SshException {
        if (this.version < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(20);
            msg.writeInt(requestId.longValue());
            msg.writeString(linkpath, this.CHARSET_ENCODING);
            msg.writeString(targetpath, this.CHARSET_ENCODING);
            if (this.version >= 6) {
                msg.writeBoolean(true);
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_SYMLINK to link {} to {}", (Object[])new Object[]{linkpath, targetpath});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, linkpath);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void createLink(String targetpath, String linkpath, boolean symbolic) throws SftpStatusException, SshException {
        if (this.version < 6 && !symbolic) {
            throw new SftpStatusException(8, "Hard links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        if (this.version < 6 && symbolic) {
            this.createSymbolicLink(targetpath, linkpath);
            return;
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(21);
            msg.writeInt(requestId.longValue());
            msg.writeString(linkpath, this.CHARSET_ENCODING);
            msg.writeString(targetpath, this.CHARSET_ENCODING);
            msg.writeBoolean(symbolic);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_LINK to link {} to {}", (Object[])new Object[]{linkpath, targetpath});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, linkpath);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSymbolicLinkTarget(String linkpath) throws SftpStatusException, SshException {
        if (this.version < 3) {
            throw new SftpStatusException(8, "Symbolic links are not supported by the server SFTP version " + String.valueOf(this.version));
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        Packet msg = this.createPacket();
        msg.write(19);
        msg.writeInt(requestId.longValue());
        msg.writeString(linkpath, this.CHARSET_ENCODING);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sending SSH_FXP_READLINK for {} requestId={}", (Object[])new Object[]{linkpath, requestId});
        }
        this.sendMessage(msg);
        SftpMessage fileMsg = this.getResponse(requestId);
        if (fileMsg.getType() == 101) {
            this.processStatusResponse(fileMsg, linkpath, requestId);
            throw new IllegalStateException("Received unexpected SSH_FX_OK in status response!");
        }
        try {
            SftpFile[] files = this.extractFiles(fileMsg, null);
            String string = files[0].getAbsolutePath();
            fileMsg.release();
            return string;
        }
        catch (Throwable throwable) {
            try {
                fileMsg.release();
                throw throwable;
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.getAbsolutePath("");
    }

    public String getAbsolutePath(String path) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(16);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_REALPATH for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            return this.getSingleFileResponse(this.getResponse(requestId), "SSH_FXP_REALPATH", path, requestId).getAbsolutePath();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpFile getSingleFileResponse(SftpMessage bar, String messageName, String path, UnsignedInteger32 requestId) throws SshException, SftpStatusException {
        try {
            if (bar.getType() == 104) {
                SftpFile[] files = this.extractFiles(bar, null);
                if (files.length != 1) {
                    this.close();
                    throw new SshException("Server responded to " + messageName + " with too many files!", 6);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_FXP_NAME with value {}", (Object[])new Object[]{files[0].getAbsolutePath()});
                }
                return files[0];
            }
            if (bar.getType() == 101) {
                this.processStatusResponse(bar, path, requestId);
                throw new IllegalStateException("Received unexpected SSH_FX_OK in status response!");
            }
            this.close();
            throw new SshException("The server responded with an unexpected message", 6);
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public int listChildren(SftpFile file, List<SftpFile> children) throws SftpStatusException, SshException {
        if (file.isDirectory()) {
            return this.openDirectory(file.getAbsolutePath()).listChildren(children);
        }
        throw new SshException("Cannot list children for this file object", 4);
    }

    SftpFile[] extractFiles(SftpMessage bar, String parent) throws SshException {
        try {
            if (parent != null && !((String)parent).endsWith("/")) {
                parent = (String)parent + "/";
            }
            int count = (int)bar.readInt();
            SftpFile[] files = new SftpFile[count];
            String longname = null;
            for (int i = 0; i < files.length; ++i) {
                String shortname = bar.readString(this.CHARSET_ENCODING);
                if (this.version <= 3) {
                    longname = bar.readString(this.CHARSET_ENCODING);
                }
                SftpFileAttributes.SftpFileAttributesBuilder bldr = SftpFileAttributes.SftpFileAttributesBuilder.of((ByteArrayReader)bar, (int)this.getVersion(), (String)this.getCharsetEncoding());
                if (longname != null && this.version <= 3) {
                    try {
                        StringTokenizer t = new StringTokenizer(longname);
                        t.nextToken();
                        t.nextToken();
                        String username = t.nextToken();
                        String group = t.nextToken();
                        bldr.withUsername(username);
                        bldr.withGroup(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                files[i] = new SftpFile((String)(parent != null ? (String)parent + shortname : shortname), bldr.build(), this, longname);
            }
            return files;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void recurseMakeDirectory(String path) throws SftpStatusException, SshException {
        if (path.trim().length() > 0) {
            try {
                SftpHandle file = this.openDirectory(path);
                file.close();
            }
            catch (SshException ioe) {
                int idx = 0;
                do {
                    String tmp = (idx = path.indexOf(47, idx)) > -1 ? path.substring(0, idx + 1) : path;
                    try {
                        SftpHandle file = this.openDirectory(tmp);
                        try {
                            file.close();
                        }
                        catch (IOException e) {
                            throw new SshException((Throwable)e);
                        }
                    }
                    catch (SshException ioe7) {
                        this.makeDirectory(tmp);
                    }
                } while (idx > -1);
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
    }

    public SftpHandle openFile(String absolutePath, int flags) throws SftpStatusException, SshException {
        return this.openFile(absolutePath, flags, SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)5, (String)this.getCharsetEncoding()).build());
    }

    public SftpHandle openFile(String path, int flags, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (this.version >= 5) {
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Converting openFile request to version 5+ format", (Object[])new Object[0]);
            }
            int accessFlags = 0;
            int newFlags = 0;
            if ((flags & 1) == 1) {
                accessFlags |= 0x81;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_READ present, adding ACE4_READ_DATA, ACE4_READ_ATTRIBUTES", (Object[])new Object[0]);
                }
            }
            if ((flags & 2) == 2) {
                accessFlags |= 2;
                accessFlags |= 0x100;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_WRITE present, adding ACE4_WRITE_DATA, ACE4_WRITE_ATTRIBUTES ", (Object[])new Object[0]);
                }
            }
            if ((flags & 4) == 4) {
                accessFlags |= 4;
                accessFlags |= 2;
                accessFlags |= 0x100;
                newFlags |= 8;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_APPEND present, adding ACE4_APPEND_DATA,ACE4_WRITE_DATA, ACE4_WRITE_ATTRIBUTES", (Object[])new Object[0]);
                }
            }
            if ((flags & 0x20) == 32) {
                newFlags |= 0;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_EXCLUSIVE present, adding SSH_FXF_CREATE_NEW", (Object[])new Object[0]);
                }
            } else if ((flags & 8) == 8) {
                if ((flags & 0x10) == 16) {
                    newFlags |= 1;
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"OPEN_CREATE and OPEN_TRUNCATE present, adding SSH_FXF_CREATE_TRUNCATE", (Object[])new Object[0]);
                    }
                } else {
                    newFlags |= 3;
                }
            } else if ((flags & 0x10) == 16) {
                newFlags |= 4;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_TRUNCATE present, adding SSH_FXF_TRUNCATE_EXISTING", (Object[])new Object[0]);
                }
            } else {
                newFlags |= 2;
            }
            if ((flags & 0x40) == 64) {
                newFlags |= 0x20;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"OPEN_TEXT present adding SSH_FXF_ACCESS_TEXT_MODE", (Object[])new Object[0]);
                }
            }
            return this.openFileVersion5(path, newFlags, accessFlags, attrs);
        }
        if (attrs == null) {
            attrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)5, (String)this.getCharsetEncoding()).build();
        }
        try {
            try {
                attrs = this.getAttributes(path);
            }
            catch (SftpStatusException accessFlags) {
                // empty catch block
            }
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(3);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.writeInt(flags);
            msg.write(attrs.toByteArray(this.getVersion()));
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_OPEN for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            SftpFile file = new SftpFile(path, attrs, this, null);
            SftpHandle handle = this.getHandle(requestId, file);
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, 16711718, true).addAttribute("FILE_NAME", (Object)file.getAbsolutePath()));
            return handle;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpHandle openFileVersion5(String path, int flags, int accessFlags, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        if (attrs == null) {
            attrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)5, (String)this.getCharsetEncoding()).build();
        }
        try {
            try {
                attrs = this.getAttributes(path);
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(3);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.writeInt(accessFlags);
            msg.writeInt(flags);
            msg.write(attrs.toByteArray(this.getVersion()));
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_OPEN for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            SftpFile file = new SftpFile(path, attrs, this, null);
            SftpHandle handle = this.getHandle(requestId, file);
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, 16711718, true).addAttribute("FILE_NAME", (Object)file.getAbsolutePath()));
            return handle;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpHandle openDirectory(String path) throws SftpStatusException, SshException {
        String absolutePath = this.getAbsolutePath(path);
        SftpFileAttributes attrs = this.getAttributes(absolutePath);
        if (!attrs.isDirectory()) {
            throw new SftpStatusException(4, path + " is not a directory");
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(11);
            msg.writeInt(requestId.longValue());
            msg.writeString(absolutePath, this.CHARSET_ENCODING);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_OPENDIR for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            return this.getHandle(requestId, new SftpFile(path, attrs, this, ""));
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    @Deprecated(since="3.1.0")
    public void closeHandle(byte[] handle) throws SftpStatusException, SshException {
        if (handle == null) {
            throw new SftpStatusException(100, "The handle is invalid!");
        }
        try {
            this.getBestHandle(handle).close();
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof SshException) {
                throw (SshException)ex.getCause();
            }
            if (ex.getCause() instanceof SftpStatusException) {
                throw (SftpStatusException)ex.getCause();
            }
            throw new SshException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SftpHandle getBestHandle(byte[] handle) {
        Map<byte[], SftpHandle> map = this.handles;
        synchronized (map) {
            SftpHandle h = this.handles.get(handle);
            if (h != null) {
                return h;
            }
        }
        return new SftpHandle(handle, this, null);
    }

    @Deprecated
    public void closeFile(SftpHandle file) throws IOException {
        file.close();
    }

    private boolean isValidHandle(byte[] handle) {
        return handle != null;
    }

    public void removeDirectory(String path) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(15);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_RMDIR for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, path);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777133, true).addAttribute("DIRECTORY_PATH", (Object)path));
    }

    public void removeFile(String path) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(13);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_REMOVE for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, path);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777131, true).addAttribute("FILE_NAME", (Object)path));
    }

    public void renameFile(String oldpath, String newpath) throws SftpStatusException, SshException {
        this.renameFile(oldpath, newpath, 0);
    }

    public void renameFile(String oldpath, String newpath, int flags) throws SftpStatusException, SshException {
        if (this.version < 2) {
            throw new SftpStatusException(8, "Renaming files is not supported by the server SFTP version " + String.valueOf(this.version));
        }
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(18);
            msg.writeInt(requestId.longValue());
            msg.writeString(oldpath, this.CHARSET_ENCODING);
            msg.writeString(newpath, this.CHARSET_ENCODING);
            if (this.version >= 5) {
                msg.writeInt(flags);
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_RENAME from {} to {}", (Object[])new Object[]{oldpath, newpath});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, newpath);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777132, true).addAttribute("FILE_NAME", (Object)oldpath).addAttribute("FILE_NEW_NAME", (Object)newpath));
    }

    public SftpFileAttributes getAttributes(String path) throws SftpStatusException, SshException {
        return this.getAttributes(path, 17, "SSH_FXP_STAT");
    }

    public SftpFileAttributes getLinkAttributes(String path) throws SftpStatusException, SshException {
        return this.getAttributes(path, 7, "SSH_FXP_LSTAT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SftpFileAttributes getAttributes(String path, int messageId, String messageName) throws SftpStatusException, SshException {
        UnsignedInteger32 requestId = this.nextRequestId();
        Packet msg = this.createPacket();
        msg.write(messageId);
        msg.writeInt(requestId.longValue());
        msg.writeString(path, this.CHARSET_ENCODING);
        if (this.version > 3) {
            long flags = 509L;
            if (this.version > 4) {
                flags |= 0x200L;
            }
            msg.writeInt(flags);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sending {} for {}", (Object[])new Object[]{messageName, path});
        }
        this.sendMessage(msg);
        SftpMessage bar = this.getResponse(requestId);
        try {
            SftpFileAttributes sftpFileAttributes = this.extractAttributes(bar, path, requestId);
            bar.release();
            return sftpFileAttributes;
        }
        catch (Throwable throwable) {
            try {
                bar.release();
                throw throwable;
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
    }

    SftpFileAttributes extractAttributes(SftpMessage bar, String path, UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        try {
            if (bar.getType() == 105) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_FXP_ATTRS for {}", (Object[])new Object[]{path});
                }
                return SftpFileAttributes.SftpFileAttributesBuilder.of((ByteArrayReader)bar, (int)this.getVersion(), (String)this.getCharsetEncoding()).build();
            }
            if (bar.getType() == 101) {
                this.processStatusResponse(bar, path, requestId);
                throw new IllegalStateException("Received unexpected SSH_FX_OK in status response!");
            }
            this.close();
            throw new SshException("The server responded with an unexpected message.", 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    void processStatusResponse(SftpMessage bar, String path, UnsignedInteger32 requestId) throws SftpStatusException, IOException {
        int status = (int)bar.readInt();
        if (status == 0) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Received SSH_FX_OK for {} requestId={}", (Object[])new Object[]{path, requestId});
            }
            return;
        }
        if (this.version >= 3) {
            String desc = bar.readString();
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Received {} with message {} for {}", (Object[])new Object[]{SftpStatusException.getStatusMessage((int)status), desc, path});
            }
            throw new SftpStatusException(status, desc);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Received {} for {}", (Object[])new Object[]{SftpStatusException.getStatusMessage((int)status), path});
        }
        throw new SftpStatusException(status);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public SftpFileAttributes getAttributes(SftpFile file) throws SftpStatusException, SshException {
        return this.getAttributes(file.getAbsolutePath());
    }

    public void makeDirectory(String path) throws SftpStatusException, SshException {
        this.makeDirectory(path, SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)2, (String)this.getCharsetEncoding()).build());
    }

    public void makeDirectory(String path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        try {
            UnsignedInteger32 requestId = this.nextRequestId();
            Packet msg = this.createPacket();
            msg.write(14);
            msg.writeInt(requestId.longValue());
            msg.writeString(path, this.CHARSET_ENCODING);
            msg.write(attrs.toByteArray(this.getVersion()));
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_MKDIR for {}", (Object[])new Object[]{path});
            }
            this.sendMessage(msg);
            this.getOKRequestStatus(requestId, path);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    SftpHandle getHandle(SftpMessage bar, SftpFile file, UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        byte[] response = this.getHandleResponse(bar, file, requestId);
        return new SftpHandle(response, this, file);
    }

    public SftpMessage getExtendedReply(UnsignedInteger32 requestId, String path) throws SftpStatusException, SshException {
        return this.getExtendedReply(this.getResponse(requestId), path, requestId);
    }

    public SftpMessage getExtendedReply(SftpMessage bar, String path, UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        try {
            if (bar.getType() == 201) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_FX_EXTENDED_REPLY", (Object[])new Object[0]);
                }
                return bar;
            }
            if (bar.getType() == 101) {
                this.processStatusResponse(bar, path, requestId);
                throw new IllegalStateException("Received unexpected SSH_FX_OK in status response!");
            }
            this.close();
            throw new SshException(String.format("The server responded with an unexpected message! id=%d", bar.getType()), 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public SftpHandle getHandle(UnsignedInteger32 requestId, SftpFile file) throws SftpStatusException, SshException {
        return new SftpHandle(this.getHandleResponse(this.getResponse(requestId), file, requestId), this, file);
    }

    public byte[] getHandleResponse(SftpMessage bar, SftpFile file, UnsignedInteger32 requestId) throws SftpStatusException, SshException {
        try {
            if (bar.getType() == 102) {
                byte[] handle = bar.readBinaryString();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_FXP_HANDLE for {} handle={}", (Object[])new Object[]{file.getAbsolutePath(), Base64.encodeBytes((byte[])handle, (boolean)true)});
                }
                this.handles.put(handle, new SftpHandle(handle, this, file));
                return handle;
            }
            if (bar.getType() == 101) {
                this.processStatusResponse(bar, file.getAbsolutePath(), requestId);
                throw new IllegalStateException("Received unexpected SSH_FX_OK in status response!");
            }
            this.close();
            throw new SshException(String.format("The server responded with an unexpected message! id=%d", bar.getType()), 6);
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    SftpMessage getExtensionResponse(UnsignedInteger32 requestId, String path) throws SftpStatusException, SshException {
        SftpMessage bar = this.getResponse(requestId);
        try {
            if (bar.getType() == 201) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_FXP_EXTENDED_REPLY", (Object[])new Object[0]);
                }
                SftpMessage sftpMessage = bar;
                return sftpMessage;
            }
            try {
                if (bar.getType() == 101) {
                    this.processStatusResponse(bar, path, requestId);
                    throw new IllegalStateException("Received unexpected SSH_FX_OK in status response!");
                }
                this.close();
                throw new SshException("The server responded with an unexpected message!", 6);
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
        finally {
            bar.release();
        }
    }

    public UnsignedInteger32 sendExtensionMessage(String request, byte[] requestData) throws SshException, SftpStatusException {
        try {
            UnsignedInteger32 id = this.nextRequestId();
            Packet packet = this.createPacket();
            packet.write(200);
            packet.writeUINT32(id);
            packet.writeString(request);
            if (requestData != null) {
                packet.write(requestData);
            }
            this.sendMessage(packet);
            return id;
        }
        catch (IOException ex) {
            throw new SshException(5, (Throwable)ex);
        }
    }

    protected Packet createPacket() throws IOException {
        return PacketPool.getInstance().getPacket();
    }

    public boolean isClosed() {
        return this.getSession().isClosed();
    }

    public UnsignedInteger32 getMaximumLocalWindowSize() {
        return this.getMaximumWindowSize();
    }

    public int getMaximumLocalPacketLength() {
        return this.getMaximumPacketSize();
    }

    public UnsignedInteger32 getMaximumRemoteWindowSize() {
        return this.session.getMaxiumRemoteWindowSize();
    }

    public int getMaximumRemotePacketLength() {
        return this.session.getMaxiumRemotePacketSize();
    }

    public SshClientContext getContext() {
        return (SshClientContext)this.con.getContext();
    }

    class SftpThreadSynchronizer {
        boolean isBlocking = false;

        SftpThreadSynchronizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestBlock(UnsignedInteger32 requestId, MessageHolder holder) throws InterruptedException {
            if (SftpChannel.this.responses.containsKey(requestId)) {
                holder.msg = SftpChannel.this.responses.get(requestId);
                return false;
            }
            SftpThreadSynchronizer sftpThreadSynchronizer = this;
            synchronized (sftpThreadSynchronizer) {
                boolean canBlock;
                boolean bl = canBlock = !this.isBlocking;
                if (canBlock) {
                    this.isBlocking = true;
                } else {
                    this.wait();
                }
                return canBlock;
            }
        }

        public synchronized void releaseBlock() {
            this.isBlocking = false;
            this.notifyAll();
        }
    }
}

