/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.sftp.SftpChannel;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.client.sftp.SftpHandle;
import com.sshtools.client.sftp.SftpMessage;
import com.sshtools.common.logger.Log;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SftpFileInputStream
extends InputStream {
    private final SftpHandle handle;
    private final SftpChannel sftp;
    private final Vector<UnsignedInteger32> outstandingRequests = new Vector();
    private long position;
    private SftpMessage currentMessage;
    private int currentMessageRemaining;
    private long readPosition = 0L;
    private boolean isEOF = false;
    private boolean error = false;
    private UnsignedInteger64 length;

    @Deprecated(since="3.1.0", forRemoval=true)
    public SftpFileInputStream(SftpFile file) throws SftpStatusException, SshException {
        this(file, 0L);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public SftpFileInputStream(SftpFile file, long position) throws SftpStatusException, SshException {
        this.sftp = file.getSFTPChannel();
        this.length = file.attributes().size();
        this.handle = file.openFile(1);
        this.position = position;
    }

    SftpFileInputStream(SftpHandle handle, long position) throws SftpStatusException, SshException {
        this.handle = handle;
        this.position = position;
        this.sftp = handle.getSFTPChannel();
        this.length = handle.getFile().attributes().size();
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        try {
            if (this.isEOF && this.currentMessageRemaining == 0) {
                this.currentMessage.release();
                return -1;
            }
            int read = 0;
            int wantsLength = len;
            while (read < wantsLength && !this.isEOF) {
                if (this.currentMessage == null || this.currentMessageRemaining == 0) {
                    this.bufferNextMessage();
                    if (this.isEOF && read == 0) {
                        return -1;
                    }
                }
                if (this.currentMessage == null) {
                    throw new IOException("Failed to obtain file data or status from the SFTP server!");
                }
                int count = Math.min(this.currentMessageRemaining, len);
                System.arraycopy(this.currentMessage.array(), this.currentMessage.getPosition(), buffer, offset, count);
                this.readPosition += (long)count;
                this.currentMessageRemaining -= count;
                this.currentMessage.skip(count);
                if (this.currentMessageRemaining == 0) {
                    this.bufferNextMessage();
                }
                read += count;
                len -= count;
                offset += count;
            }
            return read;
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
        catch (SftpStatusException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void bufferNextMessage() throws SshException, IOException, SftpStatusException {
        block16: {
            try {
                if (this.currentMessage != null) {
                    this.currentMessage.release();
                }
                this.bufferMoreData();
                UnsignedInteger32 requestid = this.outstandingRequests.remove(0);
                this.currentMessage = this.sftp.getResponse(requestid);
                if (this.currentMessage.getType() == 103) {
                    this.currentMessageRemaining = (int)this.currentMessage.readInt();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received SSH_FXP_DATA with {} bytes at position {} for {} requestId={}", (Object[])new Object[]{this.currentMessageRemaining, this.readPosition, this.handle.getFile().getFilename(), requestid});
                    }
                    break block16;
                }
                if (this.currentMessage.getType() == 101) {
                    try {
                        int status = (int)this.currentMessage.readInt();
                        if (status == 1) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Received SSH_FX_EOF for {}", (Object[])new Object[]{this.handle.getFile().getFilename()});
                            }
                            this.isEOF = true;
                            return;
                        }
                        if (this.sftp.getVersion() >= 3) {
                            String desc = this.currentMessage.readString();
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Received SSH_FXP_STATUS {}/{} for {}", (Object[])new Object[]{status, desc, this.handle.getFile().getFilename()});
                            }
                            throw new IOException(desc);
                        }
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Received SSH_FXP_STATUS {} for {}", (Object[])new Object[]{status, this.handle.getFile().getFilename()});
                        }
                        throw new IOException("Unexpected status " + status);
                    }
                    finally {
                        this.currentMessage.release();
                    }
                }
                this.close();
                throw new IOException("The server responded with an unexpected SFTP protocol message! type=" + this.currentMessage.getType());
            }
            catch (SshException e) {
                this.error = true;
                throw e;
            }
            catch (SftpStatusException e) {
                this.error = true;
                throw e;
            }
        }
    }

    private void bufferMoreData() throws SftpStatusException, SshException {
        while (this.outstandingRequests.size() < 100 && this.length.longValue() > this.position) {
            this.outstandingRequests.addElement(this.handle.postReadRequest(this.position, 32768));
            this.position += 32768L;
        }
        if (this.outstandingRequests.isEmpty()) {
            this.outstandingRequests.addElement(this.handle.postReadRequest(this.position, 32768));
            this.position += 32768L;
        }
    }

    @Override
    public int available() {
        return this.currentMessageRemaining;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        try {
            this.handle.close();
            if (!this.error && this.outstandingRequests.size() > 0) {
                if (Log.isWarnEnabled()) {
                    Log.warn((String)"Discarding {} data messages through premature closing of InputStream for file {}", (Object[])new Object[]{this.outstandingRequests.size(), this.handle.getFile().getFilename()});
                }
                while (!this.error && this.outstandingRequests.size() > 0) {
                    UnsignedInteger32 requestid = this.outstandingRequests.elementAt(0);
                    this.outstandingRequests.remove(0);
                    this.sftp.getResponse(requestid).release();
                }
            }
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
    }
}

