/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.sftp.SftpChannel;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.client.sftp.SftpMessage;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SftpHandle
implements Closeable {
    private final byte[] handle;
    private final SftpChannel sftp;
    private final SftpFile file;
    private volatile boolean closed;
    private volatile boolean performVerification = false;

    SftpHandle(byte[] handle, SftpChannel sftp, SftpFile file) {
        this.handle = handle;
        this.sftp = sftp;
        this.file = file;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.handle);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SftpHandle other = (SftpHandle)obj;
        return Arrays.equals(this.handle, other.handle);
    }

    public SftpFile getFile() {
        return this.file;
    }

    public Closeable lock() throws SftpStatusException, SshException {
        return this.lock(0L, 0L, 448);
    }

    public Closeable lock(int lockFlags) throws SftpStatusException, SshException {
        return this.lock(0L, 0L, lockFlags);
    }

    public Closeable lock(final long offset, final long length, int lockflags) throws SftpStatusException, SshException {
        this.sftp.lockFile(this.handle, offset, length, lockflags);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    SftpHandle.this.sftp.unlockFile(SftpHandle.this.handle, offset, length);
                }
                catch (SftpStatusException | SshException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public void copyTo(SftpHandle destinationHandle, UnsignedInteger64 fromOffset, UnsignedInteger64 length, UnsignedInteger64 toOffset) throws SftpStatusException, SshException, IOException {
        if (!this.isOpen() || !destinationHandle.isOpen()) {
            throw new SftpStatusException(9, "source and desintation files must be open");
        }
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeBinaryString(this.handle);
            msg.writeUINT64(fromOffset);
            msg.writeUINT64(length);
            msg.writeBinaryString(destinationHandle.getHandle());
            msg.writeUINT64(toOffset);
            this.sftp.getOKRequestStatus(this.sftp.sendExtensionMessage("copy-data", msg.toByteArray()), this.file.getAbsolutePath());
        }
    }

    public int read(long offset, byte[] output, int outputOffset, int len) throws SftpStatusException, SshException {
        this.checkValidHandle();
        return this.readFile(new UnsignedInteger64(offset), output, outputOffset, len);
    }

    public void write(long offset, byte[] input, int inputOffset, int len) throws SftpStatusException, SshException {
        this.checkValidHandle();
        this.sftp.writeFile(this.handle, new UnsignedInteger64(offset), input, inputOffset, len);
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public byte[] getHandle() {
        return this.handle;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                UnsignedInteger32 requestId = this.sftp.nextRequestId();
                Packet msg = this.sftp.createPacket();
                msg.write(4);
                msg.writeInt(requestId.longValue());
                msg.writeBinaryString(this.handle);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sending SSH_FXP_CLOSE for {} requestId={}", (Object[])new Object[]{this.file.getFilename(), requestId});
                }
                this.sftp.sendMessage(msg);
                this.sftp.getOKRequestStatus(requestId, this.file.getAbsolutePath());
            }
            catch (SftpStatusException | SshException | SshIOException ex) {
                throw new IOException("Failed to close handle.", ex);
            }
            finally {
                this.sftp.handles.remove(this.handle);
            }
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, 16711717, true).addAttribute("FILE_NAME", (Object)(this.file == null ? "<unknown>" : this.file.getAbsolutePath())));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int listChildren(List<SftpFile> children) throws SftpStatusException, SshException {
        this.checkValidHandle();
        try {
            UnsignedInteger32 requestId = this.sftp.nextRequestId();
            Packet msg = this.sftp.createPacket();
            msg.write(12);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(this.handle);
            this.sftp.sendMessage(msg);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_READDIR for {} requestId={}", (Object[])new Object[]{this.file.getFilename(), requestId});
            }
            SftpMessage bar = this.sftp.getResponse(requestId);
            try {
                if (bar.getType() == 104) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received results", (Object[])new Object[0]);
                    }
                    SftpFile[] files = this.sftp.extractFiles(bar, this.file.getAbsolutePath());
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"There are {} results in this packet", (Object[])new Object[]{files.length});
                    }
                    int i = 0;
                    while (true) {
                        if (i >= files.length) {
                            i = files.length;
                            return i;
                        }
                        children.add(files[i]);
                        ++i;
                    }
                }
                if (bar.getType() == 101) {
                    int status = (int)bar.readInt();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received status {}", (Object[])new Object[]{status});
                    }
                    if (status == 1) {
                        int i = -1;
                        return i;
                    }
                    if (this.sftp.version < 3) throw new SftpStatusException(status);
                    String desc = bar.readString();
                    throw new SftpStatusException(status, desc);
                }
                this.close();
                throw new SshException("The server responded with an unexpected message", 6);
            }
            finally {
                bar.release();
            }
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public void setAttributes(SftpFileAttributes attrs) throws SftpStatusException, SshException {
        this.checkValidHandle();
        try {
            UnsignedInteger32 requestId = this.sftp.nextRequestId();
            Packet msg = this.sftp.createPacket();
            msg.write(10);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(this.handle);
            msg.write(attrs.toByteArray(this.sftp.getVersion()));
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_FSETSTAT for {} requestId=", (Object[])new Object[]{this.file.getFilename(), requestId});
            }
            this.sftp.sendMessage(msg);
            this.sftp.getOKRequestStatus(requestId, this.file.getAbsolutePath());
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFileAttributes getAttributes() throws SftpStatusException, SshException {
        this.checkValidHandle();
        UnsignedInteger32 requestId = this.sftp.nextRequestId();
        Packet msg = this.sftp.createPacket();
        msg.write(8);
        msg.writeInt(requestId.longValue());
        msg.writeBinaryString(this.handle);
        if (this.sftp.version > 3) {
            msg.writeInt(-2147483139L);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sending SSH_FXP_FSTAT for {} requestId=", (Object[])new Object[]{this.file.getFilename(), requestId});
        }
        this.sftp.sendMessage(msg);
        SftpMessage attrMessage = this.sftp.getResponse(requestId);
        try {
            SftpFileAttributes sftpFileAttributes = this.sftp.extractAttributes(attrMessage, this.getFile().getFilename(), requestId);
            attrMessage.release();
            return sftpFileAttributes;
        }
        catch (Throwable throwable) {
            try {
                attrMessage.release();
                throw throwable;
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (IOException ex) {
                throw new SshException((Throwable)ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performOptimizedWrite(String filename, int blocksize, int maxAsyncRequests, InputStream in, int buffersize, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.checkValidHandle();
        long started = System.currentTimeMillis();
        long transfered = position;
        try {
            if (blocksize > 0 && blocksize < 4096) {
                throw new SshException("Block size cannot be less than 4096", 4);
            }
            if (blocksize <= 0 || blocksize > 65536) {
                blocksize = this.sftp.getSession().getMaximumRemotePacketLength() - 13;
            } else if (blocksize + 13 > this.sftp.getSession().getMaxiumRemotePacketSize()) {
                blocksize = this.sftp.getSession().getMaximumRemotePacketLength() - 13;
            }
            int calculatedRequestsMax = (int)((double)this.sftp.getSession().getRemoteWindow().longValue() * 0.9 / (double)blocksize);
            if (maxAsyncRequests <= 0) {
                maxAsyncRequests = calculatedRequestsMax;
            }
            System.setProperty("maverick.write.optimizedBlock", String.valueOf(blocksize));
            System.setProperty("maverick.write.asyncRequestsMax", String.valueOf(maxAsyncRequests));
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Performing optimized write length=" + in.available() + " postion=" + position + " blocksize=" + blocksize + " maxAsyncRequests=" + maxAsyncRequests), (Object[])new Object[0]);
            }
            if (position < 0L) {
                throw new SshException("Position value must be greater than zero!", 4);
            }
            if (position > 0L && progress != null) {
                progress.progressed(position);
            }
            if (buffersize <= 0) {
                buffersize = blocksize;
            }
            byte[] buf = new byte[blocksize];
            int buffered = 0;
            buffered = in.read(buf);
            if (buffered != -1) {
                long time = System.currentTimeMillis();
                this.sftp.writeFile(this.handle, new UnsignedInteger64(position), buf, 0, buffered);
                time = System.currentTimeMillis() - time;
                System.setProperty("maverick.write.blockRoundtrip", String.valueOf(time));
                transfered += (long)buffered;
                if (progress != null) {
                    if (progress.isCancelled()) {
                        throw new TransferCancelledException();
                    }
                    progress.progressed(transfered);
                }
                ArrayList<UnsignedInteger32> requests = new ArrayList<UnsignedInteger32>();
                in = new BufferedInputStream(in, buffersize);
                while ((buffered = in.read(buf)) != -1) {
                    requests.add(this.postWriteRequest(transfered, buf, 0, buffered));
                    transfered += (long)buffered;
                    if (progress != null) {
                        if (progress.isCancelled()) {
                            throw new TransferCancelledException();
                        }
                        progress.progressed(transfered);
                    }
                    if (requests.size() <= maxAsyncRequests) continue;
                    UnsignedInteger32 requestId = (UnsignedInteger32)requests.remove(0);
                    this.sftp.getOKRequestStatus(requestId, this.file.getAbsolutePath());
                }
                while (requests.size() > 0) {
                    this.sftp.getOKRequestStatus((UnsignedInteger32)requests.remove(0), this.file.getAbsolutePath());
                }
            }
        }
        catch (IOException ex) {
            try {
                throw new TransferCancelledException();
                catch (OutOfMemoryError ex2) {
                    throw new SshException("Resource Shortage: try reducing the local file buffer size", 4);
                }
            }
            catch (Throwable throwable) {
                long finished2 = System.currentTimeMillis();
                long transferTime2 = finished2 - started;
                double seconds = transferTime2 > 1000L ? (double)(transferTime2 / 1000L) : 1.0;
                if (!Log.isInfoEnabled()) throw throwable;
                if (transfered > 0L) {
                    Log.info((String)"Optimized write of {} to {} took {} seconds at {} per second", (Object[])new Object[]{IOUtils.toByteSize((double)transfered), filename, seconds, IOUtils.toByteSize((double)((double)transfered / seconds), (int)1)});
                    throw throwable;
                }
                Log.info((String)"Optimized write did not transfer any data", (Object[])new Object[0]);
                throw throwable;
            }
        }
        long finished = System.currentTimeMillis();
        long transferTime = finished - started;
        double seconds = transferTime > 1000L ? (double)(transferTime / 1000L) : 1.0;
        if (!Log.isInfoEnabled()) return;
        if (transfered > 0L) {
            Log.info((String)"Optimized write of {} to {} took {} seconds at {} per second", (Object[])new Object[]{IOUtils.toByteSize((double)transfered), filename, seconds, IOUtils.toByteSize((double)((double)transfered / seconds), (int)1)});
            return;
        }
        Log.info((String)"Optimized write did not transfer any data", (Object[])new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFile(UnsignedInteger64 offset, byte[] output, int off, int len) throws SftpStatusException, SshException {
        this.checkValidHandle();
        try {
            if (output.length - off < len) {
                throw new IndexOutOfBoundsException("Output array size is smaller than read length!");
            }
            UnsignedInteger32 requestId = this.sftp.nextRequestId();
            Packet msg = this.sftp.createPacket();
            msg.write(5);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(this.handle);
            msg.write(offset.toByteArray());
            msg.writeInt(len);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_READ for {} bytes at position {} for {} requestId={}", (Object[])new Object[]{len, offset.toString(), this.file.getFilename(), requestId});
            }
            this.sftp.sendMessage(msg);
            SftpMessage bar = this.sftp.getResponse(requestId);
            try {
                if (bar.getType() == 103) {
                    byte[] msgdata = bar.readBinaryString();
                    System.arraycopy(msgdata, 0, output, off, msgdata.length);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received SSH_FXP_DATA with {} bytes at position {} for {} requestId={}", (Object[])new Object[]{msgdata.length, offset.toString(), this.file.getFilename(), requestId});
                    }
                    int n = msgdata.length;
                    return n;
                }
                if (bar.getType() == 101) {
                    int status = (int)bar.readInt();
                    if (status == 1) {
                        int n = -1;
                        return n;
                    }
                    if (this.sftp.getVersion() < 3) throw new SftpStatusException(status);
                    String desc = bar.readString();
                    throw new SftpStatusException(status, desc);
                }
                this.close();
                throw new SshException("The server responded with an unexpected message", 6);
            }
            finally {
                bar.release();
            }
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    public UnsignedInteger32 postReadRequest(long offset, int len) throws SftpStatusException, SshException {
        this.checkValidHandle();
        try {
            UnsignedInteger32 requestId = this.sftp.nextRequestId();
            Packet msg = this.sftp.createPacket();
            msg.write(5);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(this.handle);
            msg.writeUINT64(offset);
            msg.writeInt(len);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_READ for {} bytes at position {} for {} requestId={}", (Object[])new Object[]{len, offset, this.file.getFilename(), requestId});
            }
            this.sftp.sendMessage(msg);
            return requestId;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    public void performOptimizedRead(long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void performOptimizedRead(String filename, long length, int blocksize, OutputStream out, int outstandingRequests, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.performOptimizedRead(length, blocksize, out, outstandingRequests, progress, position);
    }

    public void performSynchronousRead(int blocksize, OutputStream out, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.checkValidHandle();
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Performing synchronous read postion=" + position + " blocksize=" + blocksize), (Object[])new Object[0]);
        }
        if (blocksize < 1 || blocksize > 65536) {
            blocksize = this.sftp.getSession().getMaximumRemotePacketLength() - 13;
        } else if (blocksize + 13 < this.sftp.getSession().getMaxiumRemotePacketSize()) {
            blocksize = this.sftp.getSession().getMaximumLocalPacketLength() - 13;
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Optimised block size will be {}", (Object[])new Object[]{blocksize});
        }
        if (position < 0L) {
            throw new SshException("Position value must be greater than zero!", 4);
        }
        byte[] tmp = new byte[blocksize];
        UnsignedInteger64 offset = new UnsignedInteger64(position);
        if (position > 0L && progress != null) {
            progress.progressed(position);
        }
        try {
            int read;
            while ((read = this.readFile(offset, tmp, 0, tmp.length)) > -1) {
                if (progress != null && progress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                out.write(tmp, 0, read);
                offset = UnsignedInteger64.add((UnsignedInteger64)offset, (int)read);
                if (progress == null) continue;
                progress.progressed(offset.longValue());
            }
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    public UnsignedInteger32 postWriteRequest(long position, byte[] data, int off, int len) throws SftpStatusException, SshException {
        this.checkValidHandle();
        if (data.length - off < len) {
            throw new IndexOutOfBoundsException("Incorrect data array size!");
        }
        try {
            UnsignedInteger32 requestId = this.sftp.nextRequestId();
            Packet msg = this.sftp.createPacket();
            msg.write(6);
            msg.writeInt(requestId.longValue());
            msg.writeBinaryString(this.handle);
            msg.writeUINT64(position);
            msg.writeBinaryString(data, off, len);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sending SSH_FXP_WRITE with {} bytes at position {} for {} requestId={}", (Object[])new Object[]{len, position, this.file.getFilename(), requestId});
            }
            this.sftp.sendMessage(msg);
            return requestId;
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException((Throwable)ex);
        }
    }

    SftpChannel getSFTPChannel() {
        return this.sftp;
    }

    private void checkValidHandle() throws SftpStatusException {
        if (this.closed) {
            throw new SftpStatusException(100, "The handle is not an open file handle!");
        }
    }
}

