/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClient;
import com.sshtools.client.sftp.RemoteHash;
import com.sshtools.client.sftp.SftpClient;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.AbstractFileTask;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.MultiIOException;
import com.sshtools.common.ssh.SshException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public abstract class AbstractOptimisedTask<TARGET, LOCALFILE>
extends AbstractFileTask {
    protected final int chunks;
    protected final int blocksize;
    protected final int buffersize;
    protected final int outstandingRequests;
    protected final boolean verifyIntegrity;
    protected final RemoteHash digest;
    protected final boolean ignoreIntegrity;
    protected final SftpClient primarySftpClient;
    protected final Optional<ProgressMessages> progressMessages;
    protected final Function<LOCALFILE, FileTransferProgress> chunkProgress;
    protected final LinkedList<SshClient> clients = new LinkedList();
    protected final boolean verboseOutput;

    protected AbstractOptimisedTask(AbstractOptimisedTaskBuilder<?, ?, LOCALFILE> builder) {
        super((AbstractFileTask.AbstractFileTaskBuilder<?, ?>)builder);
        this.chunks = builder.chunks;
        this.verifyIntegrity = builder.verifyIntegrity;
        this.digest = builder.digest;
        this.ignoreIntegrity = builder.ignoreIntegrity;
        this.chunkProgress = builder.chunkProgress;
        this.progressMessages = builder.progressMessages;
        this.blocksize = builder.blocksize;
        this.buffersize = builder.buffersize;
        this.outstandingRequests = builder.outstandingRequests;
        this.verboseOutput = builder.verboseOutput;
        try {
            this.primarySftpClient = builder.primarySftpClient.orElse(SftpClient.SftpClientBuilder.create().withConnection(this.con).build());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (PermissionDeniedException | SshException e) {
            throw new IllegalArgumentException("Failed to create SFTP client.", e);
        }
    }

    public final void doTask() {
        this.doTaskUntilDone(new SftpClientTask(this.con, self -> {
            this.configureConnections();
            this.transferFiles(this.configureTargetFolder());
        }));
    }

    protected abstract void transferFiles(TARGET var1) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException, ChannelOpenException;

    protected final void displayMessage(String message, Object ... args) {
        this.progressMessages.ifPresent(p -> p.message(message, args));
    }

    protected final void verboseMessage(String message, Object ... args) {
        if (this.verboseOutput) {
            this.displayMessage(message, args);
        }
    }

    protected final void configureConnections() throws IOException, SshException {
        this.displayMessage("Creating {0} connections to {1}@{2}:{3,number,#}", this.chunks, this.con.getUsername(), this.con.getRemoteIPAddress(), this.con.getRemotePort());
        for (int i = 0; i < this.chunks; ++i) {
            this.clients.add((SshClient)((Function)this.clientSupplier.get()).apply(i + 1));
        }
        this.verboseMessage("Created {0} connections to {1}@{2}:{3,number,#}", this.chunks, this.con.getUsername(), this.con.getRemoteIPAddress(), this.con.getRemotePort());
    }

    protected abstract TARGET configureTargetFolder() throws IOException, SshException, PermissionDeniedException, SftpStatusException;

    protected final void checkErrors(Collection<Throwable> errors) throws IOException, TransferCancelledException {
        if (errors.isEmpty()) {
            return;
        }
        Throwable firstCancel = errors.stream().filter(e -> e instanceof TransferCancelledException).findFirst().orElse(null);
        errors.removeIf(e -> e instanceof TransferCancelledException && e != firstCancel);
        if (errors.size() == 1) {
            Throwable err = errors.iterator().next();
            if (err instanceof UncheckedIOException) {
                throw (IOException)err.getCause();
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof TransferCancelledException) {
                throw (TransferCancelledException)err;
            }
            throw new IOException(MessageFormat.format("Transfer could not be completed. {0}", err.getMessage() == null ? "" : err.getMessage()), err);
        }
        throw new MultiIOException("Transfer could not be completed due to at least 2 errors.", errors);
    }

    protected final void printChunkMessages(long chunkLength) {
        for (int i = 0; i < this.chunks; ++i) {
            int chunk = i + 1;
            long pointer = (long)i * chunkLength;
            this.verboseMessage("Starting chunk {0} at position {1} with length of {2} bytes", chunk, pointer, chunkLength);
        }
    }

    protected final void verifyIntegrity(Path localPath, String remotePath) throws SshException, SftpStatusException, IOException, PermissionDeniedException {
        if (this.verifyIntegrity) {
            try {
                this.displayMessage("Verifying {0}", localPath.getFileName().toString());
                if (!this.primarySftpClient.verifyFiles(localPath.toAbsolutePath().toString(), remotePath, this.digest)) {
                    throw new IOException(String.format("The local and remote paths DO NOT match", localPath.getFileName().toString()));
                }
                this.displayMessage("The integrity of {0} has been verified", localPath.getFileName().toString());
            }
            catch (SftpStatusException e) {
                if (e.getStatus() == 8) {
                    if (!this.ignoreIntegrity) {
                        throw new IOException(String.format("The remote server does not support integrity verification", new Object[0]));
                    }
                    this.displayMessage("Ignoring that the remote server does not support integrity verification", new Object[0]);
                }
                throw e;
            }
        }
    }

    public static abstract class AbstractOptimisedTaskBuilder<B extends AbstractOptimisedTaskBuilder<B, T, LOCALFILE>, T extends AbstractOptimisedTask<?, ?>, LOCALFILE>
    extends AbstractFileTask.AbstractFileTaskBuilder<B, T> {
        private int chunks = 3;
        private int blocksize = 32768;
        private int buffersize = 1024000;
        private int outstandingRequests = 64;
        private boolean verifyIntegrity;
        private RemoteHash digest = RemoteHash.md5;
        private boolean ignoreIntegrity;
        private Optional<SftpClient> primarySftpClient = Optional.empty();
        private Optional<ProgressMessages> progressMessages = Optional.empty();
        private Function<LOCALFILE, FileTransferProgress> chunkProgress = f -> null;
        private boolean verboseOutput = false;

        protected AbstractOptimisedTaskBuilder() {
        }

        public final B withProgressMessages(ProgressMessages progressMessages) {
            this.progressMessages = Optional.of(progressMessages);
            return (B)this;
        }

        public final B withChunkProgress(Function<LOCALFILE, FileTransferProgress> chunkProgress) {
            this.chunkProgress = chunkProgress;
            return (B)this;
        }

        public final B withPrimarySftpClient(SftpClient primarySftpClient) {
            this.primarySftpClient = Optional.of(primarySftpClient);
            return (B)this;
        }

        public final B withChunks(int chunks) {
            this.chunks = chunks;
            return (B)this;
        }

        public final B withBufferSize(int buffersize) {
            this.buffersize = buffersize;
            return (B)this;
        }

        public final B withVerifyIntegrity() {
            this.verifyIntegrity = true;
            return (B)this;
        }

        public final B withIntegrityVerification(boolean verifyIntegrity) {
            this.verifyIntegrity = verifyIntegrity;
            return (B)this;
        }

        public final B withIgnoreIntegrity() {
            this.ignoreIntegrity = true;
            return (B)this;
        }

        public final B withIgnoreIntegrity(boolean ignoreIntegrity) {
            this.ignoreIntegrity = ignoreIntegrity;
            return (B)this;
        }

        public final B withDigest(RemoteHash digest) {
            this.digest = digest;
            return (B)this;
        }

        public final B withBlocksize(int blocksize) {
            this.blocksize = blocksize;
            return (B)this;
        }

        public final B withAsyncRequests(int outstandingRequest) {
            this.outstandingRequests = outstandingRequest;
            return (B)this;
        }

        public final B withVerboseOutput() {
            return this.withVerboseOutput(true);
        }

        public final B withVerboseOutput(boolean verboseOutput) {
            this.verboseOutput = verboseOutput;
            return (B)this;
        }
    }

    @FunctionalInterface
    public static interface ProgressMessages {
        public void message(String var1, Object ... var2);

        default public void error(Throwable exception) {
            this.error(null, exception, new Object[0]);
        }

        default public void error(String fmt, Throwable exception, Object ... args) {
            if (fmt != null) {
                this.message(fmt, args);
            }
            if (exception != null) {
                StringWriter sw = new StringWriter();
                exception.printStackTrace(new PrintWriter((Writer)sw, true));
                this.message(sw.toString(), new Object[0]);
            }
        }
    }

    protected static class FileTransferProgressWrapper
    implements FileTransferProgress {
        private final FileTransferProgress delegate;
        private final AtomicLong total;
        private volatile long bytesSoFar;
        private final Optional<FileTransferProgress> overallProgress;

        protected FileTransferProgressWrapper(FileTransferProgress delegate, Optional<FileTransferProgress> overallProgress, AtomicLong total) {
            this.delegate = delegate;
            this.total = total;
            this.overallProgress = overallProgress;
        }

        @Override
        public void started(long bytesTotal, String remoteFile) {
            this.bytesSoFar = 0L;
            if (this.delegate != null) {
                this.delegate.started(bytesTotal, remoteFile);
            }
        }

        @Override
        public boolean isCancelled() {
            if (this.delegate != null) {
                return this.delegate.isCancelled();
            }
            return this.overallProgress.isPresent() && this.overallProgress.get().isCancelled();
        }

        @Override
        public void progressed(long bytesSoFar) {
            long add = bytesSoFar - this.bytesSoFar;
            long t = this.total.addAndGet(add);
            this.bytesSoFar = bytesSoFar;
            if (this.delegate != null) {
                this.delegate.progressed(bytesSoFar);
            }
            if (this.overallProgress.isPresent()) {
                this.overallProgress.get().progressed(t);
            }
        }

        @Override
        public void completed() {
            if (this.delegate != null) {
                this.delegate.completed();
            }
        }
    }
}

