/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.AbstractSessionChannel;
import com.sshtools.client.SshClient;
import com.sshtools.client.shell.ShellTimeoutException;
import com.sshtools.client.tasks.AbstractConnectionTask;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ChannelRequestFuture;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractSessionTask<T extends AbstractSessionChannel>
extends AbstractConnectionTask
implements Closeable {
    private long timeout = 10000L;
    private final ChannelRequestFuture future;
    private Optional<T> session;

    public AbstractSessionTask(AbstractSessionTaskBuilder<?, T, ?> builder) {
        super(builder);
        this.session = builder.session.map(f -> (AbstractSessionChannel)((Object)((Object)f.apply(this.con))));
        this.future = builder.future.orElseGet(() -> new ChannelRequestFuture());
    }

    @Deprecated
    public AbstractSessionTask(SshClient ssh, ChannelRequestFuture future) {
        super(ssh);
        this.future = future;
        this.session = Optional.empty();
    }

    @Deprecated
    public AbstractSessionTask(SshConnection con, ChannelRequestFuture future) {
        super(con);
        this.future = future;
        this.session = Optional.empty();
    }

    public AbstractSessionTask(SshConnection con) {
        this(con, new ChannelRequestFuture());
    }

    public T getSession() {
        if (this.session.isEmpty()) {
            this.session = Optional.of(this.createSession(this.con));
        }
        return (T)((Object)((AbstractSessionChannel)((Object)this.session.get())));
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public ChannelRequestFuture getChannelFuture() {
        return this.future;
    }

    public void doTask() {
        T session = this.getSession();
        this.con.openChannel(session);
        if (!session.getOpenFuture().waitFor(this.timeout).isSuccess()) {
            throw new IllegalStateException("Could not open session channel");
        }
        this.setupSession(session);
        try {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Starting session task", (Object[])new Object[0]);
            }
            this.onOpenSession(session);
        }
        catch (Throwable ex) {
            this.lastError = ex;
        }
        this.closeOnTaskComplete();
    }

    @Deprecated(since="3.1.0")
    protected void closeOnTaskComplete() {
        this.close();
    }

    protected abstract T createSession(SshConnection var1);

    protected abstract void setupSession(T var1);

    protected abstract void onOpenSession(T var1) throws IOException, SshException, ShellTimeoutException;

    protected abstract void onCloseSession(T var1);

    @Override
    public final void close() {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Ending session task", (Object[])new Object[0]);
        }
        T session = this.getSession();
        session.close();
        this.onCloseSession(session);
        this.done(Objects.isNull(this.lastError));
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Session task is done success={}", (Object[])new Object[]{String.valueOf(Objects.isNull(this.lastError))});
        }
    }

    public boolean isClosed() {
        return this.getSession().isClosed();
    }

    public void changeTerminalDimensions(int cols, int rows, int width, int height) {
        ((AbstractSessionChannel)((Object)this.getSession())).changeTerminalDimensions(cols, rows, width, height);
    }

    protected static abstract class AbstractSessionTaskBuilder<B extends AbstractSessionTaskBuilder<B, SC, TT>, SC extends AbstractSessionChannel, TT extends AbstractSessionTask<SC>>
    extends AbstractConnectionTask.AbstractConnectionTaskBuilder<B, TT> {
        private Optional<Function<SshConnection, SC>> session = Optional.empty();
        private Optional<ChannelRequestFuture> future = Optional.empty();

        protected AbstractSessionTaskBuilder() {
        }

        public final AbstractSessionTaskBuilder<B, SC, TT> withSession(Function<SshConnection, SC> session) {
            this.session = Optional.of(session);
            return this;
        }

        public final AbstractSessionTaskBuilder<B, SC, TT> withFuture(ChannelRequestFuture future) {
            this.future = Optional.of(future);
            return this;
        }
    }
}

