/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.tasks.AbstractFileTask;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.ssh.Connection;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Optional;

public class DownloadOutputStreamTask
extends AbstractFileTask {
    final Path path;
    final OutputStream output;

    private DownloadOutputStreamTask(DownloadOutputStreamTaskBuilder builder) {
        super(builder);
        this.output = builder.outputStream.orElseThrow(() -> new IllegalStateException("OutputStream must be supplied."));
        this.path = builder.remote.orElseThrow(() -> new IllegalStateException("Path must be supplied."));
    }

    public DownloadOutputStreamTask(Connection<SshClientContext> con, String path, OutputStream output) {
        this(((DownloadOutputStreamTaskBuilder)DownloadOutputStreamTaskBuilder.create().withConnection((SshConnection)con)).withRemotePath(path).withOutputStream(output));
    }

    protected void doTask() {
        try {
            this.doTaskUntilDone(new SftpClientTask(this.con, self -> self.get(Utils.translatePathString((Path)this.path), this.output, (FileTransferProgress)this.progress.orElse(null))));
        }
        finally {
            IOUtils.closeStream((OutputStream)this.output);
        }
    }

    public static final class DownloadOutputStreamTaskBuilder
    extends AbstractFileTask.AbstractFileTaskBuilder<DownloadOutputStreamTaskBuilder, DownloadOutputStreamTask> {
        private Optional<Path> remote = Optional.empty();
        private Optional<OutputStream> outputStream = Optional.empty();

        private DownloadOutputStreamTaskBuilder() {
        }

        public static DownloadOutputStreamTaskBuilder create() {
            return new DownloadOutputStreamTaskBuilder();
        }

        public DownloadOutputStreamTaskBuilder withOutputStream(Optional<OutputStream> outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public DownloadOutputStreamTaskBuilder withOutputStream(OutputStream outputStream) {
            return this.withOutputStream(Optional.of(outputStream));
        }

        public DownloadOutputStreamTaskBuilder withRemotePath(Optional<String> remote) {
            return this.withRemote((Path)remote.map(x$0 -> Path.of(x$0, new String[0])).orElse(null));
        }

        public DownloadOutputStreamTaskBuilder withRemote(Path remote) {
            return this.withRemote(Optional.of(remote));
        }

        public DownloadOutputStreamTaskBuilder withRemote(Optional<Path> remote) {
            this.remote = remote;
            return this;
        }

        public DownloadOutputStreamTaskBuilder withRemotePath(String remote) {
            return this.withRemotePath(Optional.of(remote));
        }

        @Override
        public DownloadOutputStreamTask build() {
            return new DownloadOutputStreamTask(this);
        }
    }
}

