/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.PseudoTerminalModes;
import com.sshtools.client.SessionChannelNG;
import com.sshtools.client.SshClient;
import com.sshtools.client.shell.ShellTimeoutException;
import com.sshtools.client.tasks.AbstractSessionTask;
import com.sshtools.client.tasks.AbstractShellTask;
import com.sshtools.common.shell.ShellPolicy;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.ssh.TerminalModes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;

public class ShellTask
extends AbstractShellTask<SessionChannelNG> {
    private final Optional<ShellTaskEvent> onClose;
    private final Optional<ShellTaskEvent> onStartShell;
    private final Optional<ShellTaskEvent> onBeforeTask;
    private final Optional<ShellTaskEvent> onTask;
    private final String termType;
    private final int rows;
    private final int cols;
    private final boolean withPty;
    private final Optional<TerminalModes> modes;
    private final boolean autoConsume;

    private ShellTask(ShellTaskBuilder builder) {
        super(builder);
        this.onClose = builder.onClose;
        this.onStartShell = builder.onBeforeOpen;
        this.onBeforeTask = builder.onBeforeTask;
        this.onTask = builder.onTask;
        this.withPty = builder.withPty;
        this.termType = builder.termType.orElse("dumb");
        this.rows = builder.rows;
        this.cols = builder.cols;
        this.modes = builder.modes;
        this.autoConsume = builder.autoConsume;
    }

    @Deprecated
    public ShellTask(SshConnection con) {
        this((ShellTaskBuilder)ShellTaskBuilder.create().withConnection(con));
    }

    @Deprecated
    public ShellTask(SshClient ssh) {
        this((ShellTaskBuilder)ShellTaskBuilder.create().withClient(ssh));
    }

    @Override
    @Deprecated(since="3.1.0")
    protected void onOpenSession(SessionChannelNG session) throws IOException, SshException, ShellTimeoutException {
        this.onBeforeTask.ifPresent(c -> {
            try {
                c.shellEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
        this.onTask.ifPresent(c -> {
            try {
                c.shellEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe.getMessage(), ioe);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            finally {
                this.close();
            }
        });
    }

    @Override
    @Deprecated(since="3.1.0", forRemoval=true)
    protected void closeOnTaskComplete() {
    }

    @Override
    @Deprecated(since="3.1.0")
    protected void beforeStartShell(SessionChannelNG session) {
        try {
            if (this.withPty) {
                if (this.modes.isEmpty()) {
                    session.allocatePseudoTerminal(this.termType, this.cols, this.rows);
                } else {
                    session.allocatePseudoTerminal(this.termType, this.cols, this.rows, 0, 0, this.modes.get());
                }
            }
            if (this.onStartShell.isPresent()) {
                this.onStartShell.get().shellEvent(this, session);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @Deprecated(since="3.1.0")
    protected void onCloseSession(SessionChannelNG session) {
        if (this.onClose.isPresent()) {
            try {
                this.onClose.get().shellEvent(this, session);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    @Deprecated(since="3.1.0")
    protected SessionChannelNG createSession(SshConnection con) {
        return new SessionChannelNG(((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxPacketSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMinWindowSize(), this.getChannelFuture(), this.autoConsume);
    }

    public static final class ShellTaskBuilder
    extends AbstractSessionTask.AbstractSessionTaskBuilder<ShellTaskBuilder, SessionChannelNG, ShellTask> {
        private Optional<ShellTaskEvent> onClose = Optional.empty();
        private Optional<ShellTaskEvent> onBeforeOpen = Optional.empty();
        private Optional<ShellTaskEvent> onBeforeTask = Optional.empty();
        private Optional<ShellTaskEvent> onTask = Optional.empty();
        private Optional<String> termType = Optional.empty();
        private int cols = 80;
        private int rows = 24;
        private boolean withPty = true;
        private Optional<TerminalModes> modes = Optional.empty();
        private boolean autoConsume;

        private ShellTaskBuilder() {
        }

        public ShellTaskBuilder withAutoConsume() {
            return this.withAutoConsume(true);
        }

        public ShellTaskBuilder withAutoConsume(boolean autoConsume) {
            this.autoConsume = autoConsume;
            return this;
        }

        public static ShellTaskBuilder create() {
            return new ShellTaskBuilder();
        }

        public final ShellTaskBuilder withTermType(String termType) {
            return this.withTermType(Optional.of(termType));
        }

        public final ShellTaskBuilder withTermType(Optional<String> termType) {
            this.termType = termType;
            return this;
        }

        public final ShellTaskBuilder withColumns(int cols) {
            this.cols = cols;
            return this;
        }

        public final ShellTaskBuilder withRows(int rows) {
            this.rows = rows;
            return this;
        }

        @Deprecated(since="3.1.2", forRemoval=true)
        public final ShellTaskBuilder withModes(PseudoTerminalModes modes) {
            return this.withModes(TerminalModes.TerminalModesBuilder.create().fromBytes(modes.toByteArray()).build());
        }

        public final ShellTaskBuilder withModes(TerminalModes modes) {
            this.modes = Optional.of(modes);
            return this;
        }

        public final ShellTaskBuilder onBeforeOpen(ShellTaskEvent onStartShell) {
            this.onBeforeOpen = Optional.of(onStartShell);
            return this;
        }

        public final ShellTaskBuilder onClose(ShellTaskEvent onClose) {
            this.onClose = Optional.of(onClose);
            return this;
        }

        public final ShellTaskBuilder onBeforeTask(ShellTaskEvent onBeforeTask) {
            this.onBeforeTask = Optional.of(onBeforeTask);
            return this;
        }

        public final ShellTaskBuilder onTask(ShellTaskEvent onTask) {
            this.onTask = Optional.of(onTask);
            return this;
        }

        @Deprecated
        public final ShellTaskBuilder onOpen(ShellTaskEvent onTask) {
            return this.onTask(onTask);
        }

        @Override
        public ShellTask build() {
            return new ShellTask(this);
        }

        public ShellTaskBuilder withPty(boolean withPty) {
            this.withPty = withPty;
            return this;
        }

        public ShellTaskBuilder withoutPty() {
            this.withPty = false;
            return this;
        }
    }

    @FunctionalInterface
    public static interface ShellTaskEvent {
        public void shellEvent(ShellTask var1, SessionChannelNG var2) throws Exception;
    }
}

