/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.tasks.AbstractFileTask;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.ssh.Connection;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;

public class UploadFileTask
extends AbstractFileTask {
    final Optional<Path> remote;
    final Path local;

    private UploadFileTask(UploadFileTaskBuilder builder) {
        super(builder);
        this.remote = builder.path;
        this.local = builder.local.orElseThrow(() -> new IllegalStateException("Local file must be supplied."));
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public UploadFileTask(Connection<SshClientContext> con, File localFile, String path) {
        this(((UploadFileTaskBuilder)UploadFileTaskBuilder.create().withConnection((SshConnection)con)).withRemotePath(path).withLocalFile(localFile));
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public UploadFileTask(Connection<SshClientContext> con, File localFile) {
        this(con, localFile, null);
    }

    public void doTask() {
        this.doTaskUntilDone(new SftpClientTask(this.con, self -> {
            if (this.remote.isEmpty()) {
                self.put(this.local.toAbsolutePath().toString(), (FileTransferProgress)this.progress.orElse(null));
            } else {
                self.put(this.local.toAbsolutePath().toString(), Utils.translatePathString((Path)this.remote.get()), (FileTransferProgress)this.progress.orElse(null));
            }
        }));
    }

    public static final class UploadFileTaskBuilder
    extends AbstractFileTask.AbstractFileTaskBuilder<UploadFileTaskBuilder, UploadFileTask> {
        private Optional<Path> path = Optional.empty();
        private Optional<Path> local = Optional.empty();

        private UploadFileTaskBuilder() {
        }

        public static UploadFileTaskBuilder create() {
            return new UploadFileTaskBuilder();
        }

        public UploadFileTaskBuilder withRemotePath(Optional<String> remote) {
            return this.withRemote((Path)remote.map(x$0 -> Path.of(x$0, new String[0])).orElse(null));
        }

        public UploadFileTaskBuilder withRemote(Path remote) {
            return this.withRemote(Optional.of(remote));
        }

        public UploadFileTaskBuilder withRemote(Optional<Path> remmote) {
            this.path = remmote;
            return this;
        }

        public UploadFileTaskBuilder withRemotePath(String remote) {
            return this.withRemotePath(Optional.of(remote));
        }

        public UploadFileTaskBuilder withLocalFile(File file) {
            return this.withLocal(file.toPath());
        }

        public UploadFileTaskBuilder withLocal(Path path) {
            this.local = Optional.of(path);
            return this;
        }

        @Override
        public UploadFileTask build() {
            return new UploadFileTask(this);
        }
    }
}

