/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClient;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.tasks.AbstractFileTask;
import com.sshtools.common.util.Utils;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;

public class UploadInputStreamTask
extends AbstractFileTask {
    final Path path;
    final InputStream input;
    final long length;

    private UploadInputStreamTask(UploadInputStreamTaskBuilder builder) {
        super(builder);
        this.path = builder.remote.orElseThrow(() -> new IllegalStateException("Remote remote must be supplied."));
        this.input = builder.input.orElseThrow(() -> new IllegalStateException("InputStream must be supplied."));
        this.length = builder.length.orElse(-1L);
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public UploadInputStreamTask(SshClient ssh, InputStream input, String path) {
        this(((UploadInputStreamTaskBuilder)UploadInputStreamTaskBuilder.create().withClient(ssh)).withRemotePath(path).withInputStream(input));
    }

    protected void doTask() {
        this.doTaskUntilDone(new SftpClientTask(this.con, self -> self.put(this.input, Utils.translatePathString((Path)this.path), this.progress.orElse(null), 0L, this.length)));
    }

    public static final class UploadInputStreamTaskBuilder
    extends AbstractFileTask.AbstractFileTaskBuilder<UploadInputStreamTaskBuilder, UploadInputStreamTask> {
        private Optional<Path> remote = Optional.empty();
        private Optional<InputStream> input = Optional.empty();
        private Optional<Long> length = Optional.empty();

        private UploadInputStreamTaskBuilder() {
        }

        public static UploadInputStreamTaskBuilder create() {
            return new UploadInputStreamTaskBuilder();
        }

        public UploadInputStreamTaskBuilder withRemotePath(Optional<String> remote) {
            return this.withRemote((Path)remote.map(x$0 -> Path.of(x$0, new String[0])).orElse(null));
        }

        public UploadInputStreamTaskBuilder withRemote(Path remote) {
            return this.withRemote(Optional.of(remote));
        }

        public UploadInputStreamTaskBuilder withRemote(Optional<Path> remote) {
            this.remote = remote;
            return this;
        }

        public UploadInputStreamTaskBuilder withRemotePath(String remote) {
            return this.withRemotePath(Optional.of(remote));
        }

        public UploadInputStreamTaskBuilder withInputStream(InputStream input) {
            this.input = Optional.of(input);
            return this;
        }

        public UploadInputStreamTaskBuilder withLength(long length) {
            this.length = Optional.of(length);
            return this;
        }

        @Override
        public UploadInputStreamTask build() {
            return new UploadInputStreamTask(this);
        }
    }
}

