/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ForwardingFactory;
import com.sshtools.synergy.ssh.SocketListeningForwardingFactoryImpl;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ForwardingManager<T extends SshContext> {
    Map<Connection<T>, List<String>> portsByConnection = new HashMap<Connection<T>, List<String>>();
    protected Map<String, ForwardingFactory<T>> listeningPorts = Collections.synchronizedMap(new HashMap());

    public ForwardingFactory<T> getFactory(String addressToBind, int portToBind) {
        return this.listeningPorts.get(addressToBind + ":" + portToBind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isListening(int port) {
        Map<String, ForwardingFactory<T>> map = this.listeningPorts;
        synchronized (map) {
            return this.listeningPorts.containsKey(String.valueOf(port)) || this.listeningPorts.containsKey("0.0.0.0:" + port) || this.listeningPorts.containsKey("::" + port);
        }
    }

    public synchronized int startListening(String addressToBind, int portToBind, Connection<T> con, SocketListeningForwardingFactoryImpl<T> forwardingFactory) throws SshException {
        block7: {
            String key = addressToBind + ":" + portToBind;
            if (portToBind > 0 && this.isListening(portToBind)) {
                throw new SshException("Port " + portToBind + " already in use", 14);
            }
            try {
                portToBind = forwardingFactory.bindInterface(addressToBind, portToBind, con.getConnectionProtocol(), forwardingFactory.getChannelType());
                key = addressToBind + ":" + portToBind;
                this.listeningPorts.put(key, forwardingFactory);
                if (!this.portsByConnection.containsKey(con)) {
                    this.portsByConnection.put(con, new ArrayList());
                }
                this.portsByConnection.get(con).add(key);
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, forwardingFactory.getStartedEventCode(), true).addAttribute("CONNECTION", con).addAttribute("FORWARDING_TUNNEL_ENTRANCE", (Object)(addressToBind + ":" + portToBind)));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Listening for new connections on " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
                }
                return portToBind;
            }
            catch (IOException ex) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Exception caught on socket bind", (Throwable)ex, (Object[])new Object[0]);
                }
            }
            catch (Throwable t) {
                if (!Log.isDebugEnabled()) break block7;
                Log.debug((String)"Could not instantiate remote forwarding channel factory", (Throwable)t, (Object[])new Object[0]);
            }
        }
        throw new SshException("Failed to start listening socket on " + addressToBind + ":" + portToBind, 14);
    }

    public void stopForwarding(Connection<T> con) {
        if (this.portsByConnection.containsKey(con)) {
            ArrayList keys = new ArrayList(this.portsByConnection.get(con));
            for (String key : keys) {
                this.stopListening(key, true, con);
            }
        }
    }

    public void stopForwarding(String key, Connection<T> con) {
        List<String> keys;
        if (this.portsByConnection.containsKey(con) && (keys = this.portsByConnection.get(con)).contains(key)) {
            this.stopListening(key, true, con);
        }
    }

    public synchronized boolean stopListening(String addressToBind, int portToBind, boolean dropActiveTunnels, Connection<T> connection) {
        String key = addressToBind + ":" + String.valueOf(portToBind);
        return this.stopListening(key, dropActiveTunnels, connection);
    }

    public synchronized boolean stopListening(String key, boolean dropActiveTunnels, Connection<T> connection) {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Forwarding cancelled for address " + key), (Object[])new Object[0]);
        }
        if (this.listeningPorts.containsKey(key)) {
            ForwardingFactory<T> ff = this.listeningPorts.get(key);
            if (ff.belongsTo(connection.getConnectionProtocol())) {
                ff.stopListening(dropActiveTunnels);
                this.portsByConnection.get(connection).remove(key);
                this.listeningPorts.remove(key);
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, ff.getStoppedEventCode(), true).addAttribute("CONNECTION", connection).addAttribute("FORWARDING_TUNNEL_ENTRANCE", (Object)key));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Stopped listening on " + key), (Object[])new Object[0]);
                }
            }
            return true;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Failed to stop listening on " + key), (Object[])new Object[0]);
        }
        return false;
    }

    public boolean startX11Forwarding(boolean singleConnection, String protocol, byte[] cookie, int screen, ConnectionProtocol<T> connection) {
        return false;
    }

    public static interface Listener {
    }
}

