/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.forwarding.ForwardingPolicy;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.ExecutorOperationListener;
import com.sshtools.common.ssh.ExecutorServiceProvider;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.SshCipher;
import com.sshtools.common.ssh.components.SshHmac;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.compression.NoneCompression;
import com.sshtools.common.ssh.compression.SshCompression;
import com.sshtools.common.util.ByteBufferPool;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.DefaultSocketConnectionFactory;
import com.sshtools.synergy.nio.ProtocolContext;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SocketConnectionFactory;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.ssh.AuthenticatedFuture;
import com.sshtools.synergy.ssh.ChannelFactory;
import com.sshtools.synergy.ssh.ConnectionManager;
import com.sshtools.synergy.ssh.ForwardingManager;
import com.sshtools.synergy.ssh.GlobalRequestHandler;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class SshContext
extends ProtocolContext
implements ExecutorServiceProvider,
Context {
    public static final String CIPHER_TRIPLEDES_CBC = "3des-cbc";
    public static final String CIPHER_TRIPLEDES_CTR = "3des-ctr";
    public static final String CIPHER_BLOWFISH_CBC = "blowfish-cbc";
    public static final String CIPHER_AES128_CBC = "aes128-cbc";
    public static final String CIPHER_AES192_CBC = "aes192-cbc";
    public static final String CIPHER_AES256_CBC = "aes256-cbc";
    public static final String CIPHER_AES128_CTR = "aes128-ctr";
    public static final String CIPHER_AES192_CTR = "aes192-ctr";
    public static final String CIPHER_AES256_CTR = "aes256-ctr";
    public static final String CIPHER_ARCFOUR = "arcfour";
    public static final String CIPHER_ARCFOUR_128 = "arcfour128";
    public static final String CIPHER_ARCFOUR_256 = "arcfour256";
    public static final String CIPHER_AES_GCM_128 = "aes128-gcm@openssh.com";
    public static final String CIPHER_AES_GCM_256 = "aes256-gcm@openssh.com";
    public static final String HMAC_SHA1 = "hmac-sha1";
    public static final String HMAC_SHA1_ETM = "hmac-sha1-etm@openssh.com";
    public static final String HMAC_SHA1_96 = "hmac-sha1-96";
    public static final String HMAC_MD5 = "hmac-md5";
    public static final String HMAC_MD5_ETM = "hmac-md5-etm@openssh.com";
    public static final String HMAC_MD5_96 = "hmac-md5-96";
    public static final String HMAC_SHA256 = "hmac-sha256";
    public static final String HMAC_SHA256_ETM = "hmac-sha2-256-etm@openssh.com";
    public static final String HMAC_SHA256_96 = "hmac-sha2-256-96";
    public static final String HMAC_SHA512 = "hmac-sha2-512";
    public static final String HMAC_SHA512_ETM = "hmac-sha2-512-etm@openssh.com";
    public static final String HMAC_SHA512_96 = "hmac-sha2-512-96";
    public static final String HMAC_RIPEMD160 = "hmac-ripemd160";
    public static final String HMAC_RIPEMD160_ETM = "hmac-ripemd160-etm@openssh.com";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPRESSION_ZLIB = "zlib";
    public static final String KEX_DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA256 = "diffie-hellman-group-exchange-sha256";
    public static final String KEX_DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP14_SHA256 = "diffie-hellman-group14-sha256";
    public static final String KEX_DIFFIE_HELLMAN_GROUP15_SHA512 = "diffie-hellman-group15-sha512";
    public static final String KEX_DIFFIE_HELLMAN_GROUP16_SHA512 = "diffie-hellman-group16-sha512";
    public static final String KEX_DIFFIE_HELLMAN_GROUP17_SHA512 = "diffie-hellman-group17-sha512";
    public static final String KEX_DIFFIE_HELLMAN_GROUP18_SHA512 = "diffie-hellman-group18-sha512";
    public static final String KEX_DIFFIE_HELLMAN_ECDH_NISTP_256 = "ecdh-sha2-nistp256";
    public static final String KEX_DIFFIE_HELLMAN_ECDH_NISTP_384 = "ecdh-sha2-nistp384";
    public static final String KEX_DIFFIE_HELLMAN_ECDH_NISTP_521 = "ecdh-sha2-nistp521";
    public static final String PUBLIC_KEY_SSHDSS = "ssh-dss";
    public static final String PUBLIC_KEY_ED25519 = "ssh-ed25519";
    public static final String PUBLIC_KEY_SSHRSA = "ssh-rsa";
    public static final String PUBLIC_KEY_ECDSA_SHA2_NISPTP_256 = "ecdsa-sha2-nistp256";
    public static final String PUBLIC_KEY_ECDSA_SHA2_NISPTP_384 = "ecdsa-sha2-nistp384";
    public static final String PUBLIC_KEY_ECDSA_SHA2_NISPTP_521 = "ecdsa-sha2-nistp521";
    public static final String PUBLIC_KEY_RSA_SHA256 = "rsa-sha2-256";
    public static final String PUBLIC_KEY_RSA_SHA512 = "rsa-sha2-512";
    public static final String PASSWORD_AUTHENTICATION = "password";
    public static final String PUBLICKEY_AUTHENTICATION = "publickey";
    public static final String KEYBOARD_INTERACTIVE_AUTHENTICATION = "keyboard-interactive";
    protected int maximumSocketsBacklogPerRemotelyForwardedConnection = 50;
    protected SocketConnectionFactory socketConnectionFactory = new DefaultSocketConnectionFactory();
    protected ComponentFactory<SshCompression> compressionsCS;
    protected ComponentFactory<SshCompression> compressionsSC;
    protected ComponentFactory<SshCipher> ciphersCS;
    protected ComponentFactory<SshCipher> ciphersSC;
    protected ComponentFactory<SshKeyExchange<? extends SshContext>> keyExchanges;
    protected ComponentFactory<SshHmac> macCS;
    protected ComponentFactory<SshHmac> macSC;
    protected ComponentFactory<SshPublicKey> publicKeys;
    protected String prefCipherCS = "aes256-ctr";
    protected String prefCipherSC = "aes256-ctr";
    protected String prefMacCS = "hmac-sha256";
    protected String prefMacSC = "hmac-sha256";
    protected String prefCompressionCS = "none";
    protected String prefCompressionSC = "none";
    protected String prefKeyExchange = "diffie-hellman-group-exchange-sha256";
    protected String prefPublicKey = "ecdsa-sha2-nistp256";
    protected int maxChannels = 100;
    protected int compressionLevel = 6;
    protected int maximumPacketLength = 131328;
    protected long MAX_NUM_PACKETS_BEFORE_REKEY = Integer.MAX_VALUE;
    protected long MAX_NUM_BYTES_BEFORE_REKEY = 0x40000000L;
    protected SshEngine daemon;
    protected String softwareVersionComments = "MaverickSynergy";
    protected boolean killTunnelsOnRemoteForwardingCancel = false;
    protected boolean sendIgnorePacketOnIdle = false;
    protected int idleConnectionTimeout = 0;
    protected int idleAuthenticationTimeoutSeconds = 30;
    protected int keepAliveInterval = 30;
    protected int keepAliveDataMaxLength = 128;
    protected static ExecutorService executor;
    protected Locale locale = Locale.getDefault();
    protected ByteBufferPool byteBufferPool = null;
    protected int minDHGroupExchangeKeySize = 2048;
    protected int preferredDHGroupExchangeKeySize = 2048;
    protected int maxDHGroupExchangeKeySize = 8192;
    List<ExecutorOperationListener> listeners = new ArrayList<ExecutorOperationListener>();
    protected ComponentManager componentManager;
    boolean httpRedirect;
    String httpRedirectUrl;
    Map<Class<?>, Object> policies = new HashMap();
    AuthenticatedFuture authenticatedFuture = new AuthenticatedFuture();

    public SshContext(ComponentManager componentManager, SecurityLevel securityLevel) throws IOException, SshException {
        this.componentManager = componentManager;
        this.keyExchanges = new ComponentFactory(componentManager);
        this.configureKeyExchanges();
        this.keyExchanges.configureSecurityLevel(securityLevel);
        this.ciphersCS = ComponentManager.getDefaultInstance().supportedSsh2CiphersCS();
        this.ciphersCS.configureSecurityLevel(securityLevel);
        this.ciphersSC = ComponentManager.getDefaultInstance().supportedSsh2CiphersSC();
        this.ciphersSC.configureSecurityLevel(securityLevel);
        this.macCS = ComponentManager.getDefaultInstance().supportedHMacsCS();
        this.macCS.configureSecurityLevel(securityLevel);
        this.macSC = ComponentManager.getDefaultInstance().supportedHMacsSC();
        this.macSC.configureSecurityLevel(securityLevel);
        this.publicKeys = ComponentManager.getDefaultInstance().supportedPublicKeys();
        this.publicKeys.configureSecurityLevel(securityLevel);
        try {
            this.compressionsCS = new ComponentFactory(componentManager);
            this.compressionsCS.add(COMPRESSION_NONE, NoneCompression.class);
            JCEComponentManager.getDefaultInstance().loadExternalComponents("zip.properties", this.compressionsCS);
            this.compressionsSC = new ComponentFactory(componentManager);
            this.compressionsSC.add(COMPRESSION_NONE, NoneCompression.class);
            JCEComponentManager.getDefaultInstance().loadExternalComponents("zip.properties", this.compressionsSC);
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage() != null ? t.getMessage() : t.getClass().getName());
        }
        this.keepAlive = true;
        this.tcpNoDelay = true;
    }

    public void init(SshEngine daemon) {
        this.daemon = daemon;
    }

    public SshContext(SshEngine daemon, ComponentManager componentManager, SecurityLevel securityLevel) throws IOException, SshException {
        this(componentManager, securityLevel);
        this.init(daemon);
    }

    public abstract ConnectionManager<? extends SshContext> getConnectionManager();

    @Override
    public abstract ProtocolEngine createEngine(ConnectRequestFuture var1) throws IOException;

    public abstract String getSupportedPublicKeys();

    protected abstract void configureKeyExchanges();

    public abstract String getPreferredPublicKey();

    public abstract ChannelFactory<? extends SshContext> getChannelFactory();

    public <P> P getPolicy(Class<P> clz) {
        try {
            if (!this.policies.containsKey(clz)) {
                this.policies.put(clz, clz.newInstance());
            }
            return (P)this.policies.get(clz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <P> P getPolicy(Class<P> clz, P defaultValue) {
        if (!this.policies.containsKey(clz)) {
            this.policies.put(clz, defaultValue);
        }
        return (P)this.policies.get(clz);
    }

    public void setPolicy(Class<?> clz, Object policy) {
        this.policies.put(clz, policy);
    }

    public boolean hasPolicy(Class<?> clz) {
        return this.policies.containsKey(clz);
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public synchronized void addOperationListener(ExecutorOperationListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeOperationListener(ExecutorOperationListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized List<ExecutorOperationListener> getExecutorListeners() {
        return new ArrayList<ExecutorOperationListener>(this.listeners);
    }

    @Override
    public void setSocketConnectionFactory(SocketConnectionFactory socketConnectionFactory) {
        this.socketConnectionFactory = socketConnectionFactory;
    }

    @Override
    public SocketConnectionFactory getSocketConnectionFactory() {
        return this.socketConnectionFactory;
    }

    public abstract GlobalRequestHandler<? extends SshContext> getGlobalRequestHandler(String var1);

    public SshEngine getEngine() {
        return this.daemon;
    }

    public void setChannelLimit(int maxChannels) {
        this.maxChannels = maxChannels;
    }

    public int getChannelLimit() {
        return this.maxChannels;
    }

    public ComponentFactory<SshCipher> supportedCiphersCS() {
        return this.ciphersCS;
    }

    public ComponentFactory<SshCipher> supportedCiphersSC() {
        return this.ciphersSC;
    }

    public String getPreferredCipherCS() {
        return this.prefCipherCS;
    }

    public void setPreferredCipherCS(String name) throws IOException, SshException {
        if (!this.ciphersCS.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefCipherCS = name;
        this.setCipherPreferredPositionCS(name, 0);
    }

    public String getPreferredCipherSC() {
        return this.prefCipherSC;
    }

    public String getSoftwareVersionComments() {
        return this.softwareVersionComments;
    }

    public void setSoftwareVersionComments(String softwareVersionComments) {
        this.softwareVersionComments = softwareVersionComments;
    }

    public void setPreferredCipherSC(String name) throws IOException, SshException {
        if (!this.ciphersSC.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefCipherSC = name;
        this.setCipherPreferredPositionSC(name, 0);
    }

    public ComponentFactory<SshHmac> supportedMacsCS() {
        return this.macCS;
    }

    public ComponentFactory<SshHmac> supportedMacsSC() {
        return this.macSC;
    }

    public String getPreferredMacCS() {
        return this.prefMacCS;
    }

    public void setPreferredMacCS(String name) throws IOException, SshException {
        if (!this.macCS.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefMacCS = name;
        this.setMacPreferredPositionCS(name, 0);
    }

    public String getPreferredMacSC() {
        return this.prefMacSC;
    }

    public void setRemoteForwardingCancelKillsTunnels(boolean killTunnelsOnRemoteForwardingCancel) {
        this.killTunnelsOnRemoteForwardingCancel = killTunnelsOnRemoteForwardingCancel;
    }

    public boolean getRemoteForwardingCancelKillsTunnels() {
        return this.killTunnelsOnRemoteForwardingCancel;
    }

    public void setPreferredMacSC(String name) throws IOException, SshException {
        if (!this.macSC.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefMacSC = name;
        this.setMacPreferredPositionSC(name, 0);
    }

    public ComponentFactory<SshCompression> supportedCompressionsCS() {
        return this.compressionsCS;
    }

    public ComponentFactory<SshCompression> supportedCompressionsSC() {
        return this.compressionsSC;
    }

    public String getPreferredCompressionCS() {
        return this.prefCompressionCS;
    }

    public void setPreferredCompressionCS(String name) throws IOException {
        if (!this.compressionsCS.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefCompressionCS = name;
    }

    public String getPreferredCompressionSC() {
        return this.prefCompressionSC;
    }

    public void setPreferredCompressionSC(String name) throws IOException {
        if (!this.compressionsSC.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefCompressionSC = name;
    }

    public ComponentFactory<SshKeyExchange<? extends SshContext>> supportedKeyExchanges() {
        return this.keyExchanges;
    }

    public String getPreferredKeyExchange() {
        return this.prefKeyExchange;
    }

    public void setPreferredKeyExchange(String name) throws IOException, SshException {
        if (!this.keyExchanges.contains(name)) {
            throw new IOException(name + " is not supported");
        }
        this.prefKeyExchange = name;
        this.setKeyExchangePreferredPosition(name, 0);
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getMaximumSocketsBacklogPerRemotelyForwardedConnection() {
        return this.maximumSocketsBacklogPerRemotelyForwardedConnection;
    }

    public void setMaximumSocketsBacklogPerRemotelyForwardedConnection(int maximumSocketsBacklogPerRemotelyForwardedConnection) {
        this.maximumSocketsBacklogPerRemotelyForwardedConnection = maximumSocketsBacklogPerRemotelyForwardedConnection;
    }

    public String getCiphersSC() {
        return this.ciphersSC.list(this.prefCipherSC);
    }

    public String getCiphersCS() {
        return this.ciphersCS.list(this.prefCipherCS);
    }

    public String getMacsCS() {
        return this.macCS.list(this.prefMacCS);
    }

    public String getMacsSC() {
        return this.macSC.list(this.prefMacSC);
    }

    public String getPublicKeys() {
        return this.publicKeys.list(this.prefPublicKey);
    }

    public String getKeyExchanges() {
        return this.keyExchanges.list(this.prefKeyExchange);
    }

    public void setPreferredCipherSC(int[] order) throws SshException {
        this.prefCipherSC = this.ciphersSC.createNewOrdering(order);
    }

    public void setPreferredCipherSC(String[] order) throws SshException {
        this.prefCipherSC = this.ciphersSC.order(order);
    }

    public void setPreferredCipherCS(int[] order) throws SshException {
        this.prefCipherCS = this.ciphersCS.createNewOrdering(order);
    }

    public void setPreferredCipherCS(String[] order) throws SshException {
        this.prefCipherCS = this.ciphersCS.order(order);
    }

    public void setPreferredMacSC(int[] order) throws SshException {
        this.prefMacSC = this.macSC.createNewOrdering(order);
    }

    public void setPreferredMacSC(String[] order) throws SshException {
        this.prefMacSC = this.macSC.order(order);
    }

    public void setPreferredKeyExchange(String[] order) throws SshException {
        this.prefKeyExchange = this.keyExchanges.order(order);
    }

    public void setPreferredMacCS(int[] order) throws SshException {
        this.prefMacSC = this.macCS.createNewOrdering(order);
    }

    public void setPreferredMacCS(String[] order) throws SshException {
        this.prefMacCS = this.macCS.order(order);
    }

    public void setCipherPreferredPositionCS(String name, int position) throws SshException {
        this.prefCipherCS = this.ciphersCS.changePositionofAlgorithm(name, position);
    }

    public void setCipherPreferredPositionSC(String name, int position) throws SshException {
        this.prefCipherSC = this.ciphersSC.changePositionofAlgorithm(name, position);
    }

    public void setMacPreferredPositionSC(String name, int position) throws SshException {
        this.prefMacSC = this.macSC.changePositionofAlgorithm(name, position);
    }

    public void setMacPreferredPositionCS(String name, int position) throws SshException {
        this.prefMacCS = this.macCS.changePositionofAlgorithm(name, position);
    }

    public void setPublicKeyPreferredPosition(String name, int position) throws SshException {
        this.prefMacCS = this.publicKeys.changePositionofAlgorithm(name, position);
    }

    public void setKeyExchangePreferredPosition(String name, int position) throws SshException {
        this.prefMacCS = this.keyExchanges.changePositionofAlgorithm(name, position);
    }

    public void setMaximumPacketLength(int maximumPacketLength) {
        this.maximumPacketLength = maximumPacketLength;
    }

    public int getMaximumPacketLength() {
        return this.maximumPacketLength;
    }

    public void setKeyExchangeTransferLimit(long MAX_NUM_BYTES_BEFORE_REKEY) {
        if (MAX_NUM_BYTES_BEFORE_REKEY < 1024000L) {
            throw new IllegalArgumentException("The minimum number of bytes allowed between key exchange is 1MB (1024000 bytes)");
        }
        this.MAX_NUM_BYTES_BEFORE_REKEY = MAX_NUM_BYTES_BEFORE_REKEY;
    }

    public void setKeyExchangePacketLimit(int MAX_NUM_PACKETS_BEFORE_REKEY) {
        if (MAX_NUM_PACKETS_BEFORE_REKEY < 100) {
            throw new IllegalArgumentException("The minimum number of packets allowed between key exchanges is 100");
        }
        this.MAX_NUM_PACKETS_BEFORE_REKEY = MAX_NUM_PACKETS_BEFORE_REKEY;
    }

    public long getKeyExchangeTransferLimit() {
        return this.MAX_NUM_BYTES_BEFORE_REKEY;
    }

    public long getKeyExchangePacketLimit() {
        return this.MAX_NUM_PACKETS_BEFORE_REKEY;
    }

    public int getIdleConnectionTimeoutSeconds() {
        return this.idleConnectionTimeout;
    }

    public void setIdleConnectionTimeoutSeconds(int idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public ComponentFactory<SshPublicKey> supportedPublicKeys() {
        return this.publicKeys;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getKeepAliveDataMaxLength() {
        return this.keepAliveDataMaxLength;
    }

    public void setKeepAliveDataMaxLength(int keepAliveDataMaxLength) {
        this.keepAliveDataMaxLength = keepAliveDataMaxLength;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void enableFIPSMode() throws SshException {
        int i;
        if (Log.isInfoEnabled()) {
            Log.info((String)"Enabling FIPS mode", (Object[])new Object[0]);
        }
        if (!this.keyExchanges.contains(KEX_DIFFIE_HELLMAN_GROUP14_SHA1)) {
            throw new SshException("Cannot enable FIPS mode because diffie-hellman-group14-sha1 keyexchange was not supported by this configuration. Install a JCE Provider that supports a prime size of 2048 bits (for example BouncyCastle provider)", 4);
        }
        Vector<String> allowed = new Vector<String>();
        allowed.addElement(KEX_DIFFIE_HELLMAN_GROUP14_SHA1);
        String[] names = this.keyExchanges.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Removing key exchange " + names[i]), (Object[])new Object[0]);
            }
            this.keyExchanges.remove(names[i]);
        }
        this.keyExchanges.lockComponents();
        allowed.clear();
        allowed.addElement(CIPHER_AES128_CBC);
        allowed.addElement(CIPHER_AES192_CBC);
        allowed.addElement(CIPHER_AES256_CBC);
        allowed.addElement(CIPHER_TRIPLEDES_CBC);
        names = this.ciphersCS.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Removing cipher client->server " + names[i]), (Object[])new Object[0]);
            }
            this.ciphersCS.remove(names[i]);
        }
        this.ciphersCS.lockComponents();
        names = this.ciphersSC.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Removing cipher server->client " + names[i]), (Object[])new Object[0]);
            }
            this.ciphersSC.remove(names[i]);
        }
        this.ciphersSC.lockComponents();
        allowed.clear();
        allowed.addElement(PUBLIC_KEY_SSHRSA);
        names = this.publicKeys.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Removing public key " + names[i]), (Object[])new Object[0]);
            }
            this.publicKeys.remove(names[i]);
        }
        this.publicKeys.lockComponents();
        allowed.clear();
        allowed.addElement(HMAC_SHA1);
        allowed.addElement(HMAC_SHA256);
        allowed.addElement("hmac-sha256@ssh.com");
        names = this.macCS.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Removing mac client->server " + names[i]), (Object[])new Object[0]);
            }
            this.macCS.remove(names[i]);
        }
        this.macCS.lockComponents();
        names = this.macSC.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            if (Log.isInfoEnabled()) {
                Log.info((String)("Removing mac server->client " + names[i]), (Object[])new Object[0]);
            }
            this.macSC.remove(names[i]);
        }
        this.macCS.lockComponents();
    }

    public ExecutorService getExecutorService() {
        if (executor == null) {
            ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    return t;
                }
            });
            if (!Objects.isNull(this.daemon)) {
                this.daemon.addShutdownHook(new Runnable(){

                    @Override
                    public void run() {
                        SshContext.this.shutdown();
                    }
                });
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        SshContext.this.shutdown();
                    }
                });
            }
            SshContext.executor = executor;
        }
        return executor;
    }

    @Override
    public void shutdown() {
        if (executor != null) {
            executor.shutdown();
            try {
                executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                executor = null;
            }
        }
    }

    public synchronized ByteBufferPool getByteBufferPool() {
        if (this.byteBufferPool == null) {
            this.byteBufferPool = new ByteBufferPool(this.getMaximumPacketLength(), this.getEngine().getContext().isUsingDirectBuffers());
        }
        return this.byteBufferPool;
    }

    public SshEngineContext getDaemonContext() {
        return this.daemon.getContext();
    }

    public int getIdleAuthenticationTimeoutSeconds() {
        return this.idleAuthenticationTimeoutSeconds;
    }

    public void setIdleAuthenticationTimeoutSeconds(int idleAuthenticationTimeoutSeconds) {
        this.idleAuthenticationTimeoutSeconds = idleAuthenticationTimeoutSeconds;
    }

    public int getMinDHGroupExchangeKeySize() {
        return this.minDHGroupExchangeKeySize;
    }

    public void setMinDHGroupExchangeKeySize(int minDHGroupExchangeKeySize) {
        this.minDHGroupExchangeKeySize = minDHGroupExchangeKeySize;
    }

    public abstract ForwardingManager<? extends SshContext> getForwardingManager();

    protected String listPublicKeys(String ... keys) {
        String list = "";
        for (String key : keys) {
            list = !key.equals(this.prefPublicKey) ? list + (list.length() == 0 ? "" : ",") + key : this.prefPublicKey + (list.length() == 0 ? "" : ",") + list;
        }
        return list;
    }

    public boolean isSendIgnorePacketOnIdle() {
        return this.sendIgnorePacketOnIdle;
    }

    public void setSendIgnorePacketOnIdle(boolean sendIgnorePacketOnIdle) {
        this.sendIgnorePacketOnIdle = sendIgnorePacketOnIdle;
    }

    public boolean isHttpRedirect() {
        return this.httpRedirect;
    }

    public void setHttpRedirect(boolean httpRedirect) {
        this.httpRedirect = httpRedirect;
    }

    public String getHttpRedirectUrl() {
        return this.httpRedirectUrl;
    }

    public void setHttpRedirectUrl(String httpRedirectUrl) {
        this.httpRedirectUrl = httpRedirectUrl;
    }

    public int getPreferredDHGroupExchangeKeySize() {
        return this.preferredDHGroupExchangeKeySize;
    }

    public void setPreferredDHGroupExchangeKeySize(int preferredDHGroupExchangeKeySize) {
        this.preferredDHGroupExchangeKeySize = preferredDHGroupExchangeKeySize;
    }

    public int getMaxDHGroupExchangeKeySize() {
        return this.maxDHGroupExchangeKeySize;
    }

    public void setMaxDHGroupExchangeKeySize(int maxDHGroupExchangeKeySize) {
        this.maxDHGroupExchangeKeySize = maxDHGroupExchangeKeySize;
    }

    public ForwardingPolicy getForwardingPolicy() {
        return this.getPolicy(ForwardingPolicy.class);
    }

    protected AuthenticatedFuture getAuthenticatedFuture() {
        return this.authenticatedFuture;
    }
}

