/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.nio;

import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.IdleStateManager;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationQueues;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SelectorThread;
import com.sshtools.synergy.nio.SocketHandler;
import com.sshtools.synergy.nio.SocketWriteCallback;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.SshContext;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;

public class SocketConnection
implements SocketHandler {
    private static final Integer SOCKET_QUEUE = ExecutorOperationQueues.generateUniqueQueue((String)"SocketConnection.in");
    protected SocketChannel socketChannel;
    protected ProtocolEngine protocolEngine;
    protected SshEngineContext daemonContext;
    protected SelectorThread selectorThread;
    protected SelectionKey key;
    protected SshEngine daemon;
    protected ByteBuffer socketDataIn;
    protected ByteBuffer socketDataOut;
    protected boolean closed;
    boolean hasInterestedOps = false;
    int currentInterestedOps = 5;
    int pendingRemoveOps = 0;
    int pendingIncludeOps = 0;
    Object opsLock = new Object();
    LinkedList<SocketWriteCallback> socketWriteCallbacks = new LinkedList();
    private SocketAddress remoteAddress;
    private int remotePort;
    private int localPort;
    private SocketAddress localAddress;

    @Override
    public void initialize(ProtocolEngine protocolEngine, SshEngine daemon, SelectableChannel channel) throws IOException {
        this.protocolEngine = protocolEngine;
        this.daemon = daemon;
        this.daemonContext = daemon.getContext();
        this.socketChannel = (SocketChannel)channel;
        this.localAddress = this.socketChannel.getLocalAddress();
        this.localPort = this.socketChannel.socket().getLocalPort();
        this.remoteAddress = this.socketChannel.getRemoteAddress();
        this.remotePort = this.socketChannel.socket().getPort();
    }

    @Override
    public void registrationCompleted(SelectableChannel channel, SelectionKey key, SelectorThread selectorThread) throws IOException {
        this.selectorThread = selectorThread;
        this.key = key;
        this.protocolEngine.onSocketConnect(this);
    }

    @Override
    public void setSelectionKey(SelectionKey key) {
        this.key = key;
        this.hasInterestedOps = false;
    }

    public void setProtocolEngine(ProtocolEngine protocolEngine) {
        this.protocolEngine = protocolEngine;
    }

    public void closeConnection() {
        this.closeConnection(true);
    }

    public void closeConnection(boolean closeProtocol) {
        if (!this.closed) {
            if (this.socketChannel != null && this.socketChannel.isOpen()) {
                try {
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"Closing socket", (Object[])new Object[0]);
                    }
                    this.socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (closeProtocol) {
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Closing protocol engine", (Object[])new Object[0]);
                }
                this.protocolEngine.onSocketClose();
            }
            this.closed = true;
        }
    }

    public ProtocolEngine getProtocolEngine() {
        return this.protocolEngine;
    }

    public SshEngineContext getDaemonContext() {
        return this.daemonContext;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getPort() {
        return this.remotePort;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public IdleStateManager getIdleStates() {
        return this.selectorThread.getIdleStates();
    }

    public boolean isSelectorThread() {
        return Thread.currentThread().equals(this.selectorThread);
    }

    protected boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isOpen() && this.protocolEngine.isConnected();
    }

    public SelectorThread getThread() {
        return this.selectorThread;
    }

    @Override
    public int getInitialOps() {
        return 5;
    }

    @Override
    public synchronized boolean processReadEvent() {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Processing socket READ event", (Object[])new Object[0]);
        }
        try {
            if (!this.isConnected()) {
                boolean bl = true;
                return bl;
            }
            if (this.socketDataIn == null) {
                this.socketDataIn = this.daemonContext.getBufferPool().get();
            }
            int numBytesRead = this.socketChannel.read(this.socketDataIn);
            this.socketDataIn.flip();
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Read " + numBytesRead + " bytes from socket"), (Object[])new Object[0]);
            }
            if (numBytesRead == -1) {
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Received EOF from remote host", (Object[])new Object[0]);
                }
                this.closeConnection();
                boolean bl = true;
                return bl;
            }
            if (this.socketDataIn.hasRemaining()) {
                this.protocolEngine.onSocketRead(this.socketDataIn);
            }
            if (this.socketDataIn != null && Log.isTraceEnabled()) {
                Log.trace((String)("There is " + this.socketDataIn.remaining() + " bytes left to process on socket"), (Object[])new Object[0]);
            }
            if (!this.isConnected() && Log.isTraceEnabled()) {
                Log.trace((String)"Connection is closed, cancelling selectors", (Object[])new Object[0]);
            }
            boolean bl = !this.isConnected();
            return bl;
        }
        catch (Throwable ex) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Connection closed on socket read: " + ex.getMessage()), (Object[])new Object[0]);
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Trace: ", (Throwable)ex, (Object[])new Object[0]);
            }
            this.closeConnection();
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.socketDataIn != null) {
                if (!this.socketDataIn.hasRemaining()) {
                    this.daemonContext.getBufferPool().add(this.socketDataIn);
                    this.socketDataIn = null;
                } else {
                    this.socketDataIn.compact();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean processWriteEvent() {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Processing socket WRITE event", (Object[])new Object[0]);
        }
        if (this.socketChannel == null || !this.socketChannel.isOpen()) {
            return true;
        }
        if (this.socketDataOut == null) {
            this.socketDataOut = this.daemonContext.getBufferPool().get();
        }
        try {
            SocketWriteCallback c2;
            if (this.socketDataOut.remaining() == this.socketDataOut.capacity() && this.protocolEngine.isConnected() && (c2 = this.protocolEngine.onSocketWrite(this.socketDataOut)) != null) {
                this.socketWriteCallbacks.addLast(c2);
            }
            this.socketDataOut.flip();
            if (!this.socketChannel.isOpen()) {
                boolean c2 = true;
                return c2;
            }
            if (this.socketDataOut.hasRemaining()) {
                int written = this.socketChannel.write(this.socketDataOut);
                if (Log.isTraceEnabled()) {
                    Log.trace((String)("Written " + written + " bytes to socket"), (Object[])new Object[0]);
                }
            }
            if (this.socketDataIn != null) {
                this.socketDataIn.flip();
                if (this.socketDataIn.hasRemaining()) {
                    this.protocolEngine.onSocketRead(this.socketDataIn);
                }
            }
            boolean written = !this.isConnected();
            return written;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Connection closed on socket write", (Object[])new Object[0]);
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)"Connection error", (Throwable)ex, (Object[])new Object[0]);
            }
            this.closeConnection();
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.socketDataOut != null) {
                if (!this.socketDataOut.hasRemaining()) {
                    this.daemonContext.getBufferPool().add(this.socketDataOut);
                    this.socketDataOut = null;
                    Iterator it = this.socketWriteCallbacks.iterator();
                    while (it.hasNext()) {
                        ((SocketWriteCallback)it.next()).completedWrite();
                    }
                    this.socketWriteCallbacks.clear();
                } else {
                    this.socketDataOut.compact();
                }
            }
            if (this.socketDataIn != null) {
                if (!this.socketDataIn.hasRemaining()) {
                    this.daemonContext.getBufferPool().add(this.socketDataIn);
                    this.socketDataIn = null;
                } else {
                    this.socketDataIn.compact();
                }
            }
        }
    }

    @Override
    public void setThread(SelectorThread thread) {
        this.selectorThread = thread;
    }

    @Override
    public void addTask(ConnectionAwareTask task) {
        this.protocolEngine.getExecutor().addTask(SOCKET_QUEUE, task);
    }

    @Override
    public synchronized boolean wantsWrite() {
        return this.socketDataOut != null && this.socketDataOut.hasRemaining() || this.protocolEngine != null && this.protocolEngine.wantsToWrite();
    }

    @Override
    public SelectorThread getSelectorThread() {
        return this.selectorThread;
    }

    public void flagWrite() {
        this.selectorThread.addSelectorOperation(new Runnable(){

            @Override
            public void run() {
                if (SocketConnection.this.key.isValid()) {
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"Flag selector as READ/WRITE", (Object[])new Object[0]);
                    }
                    SocketConnection.this.key.interestOps(5);
                }
            }
        });
    }

    @Override
    public String getName() {
        return this.protocolEngine.getName();
    }

    @Override
    public SshContext getContext() {
        return this.protocolEngine.getContext();
    }

    @Override
    public Connection<? extends SshContext> getConnection() {
        return this.protocolEngine.getConnection();
    }

    @Override
    public boolean wantsRead() {
        return true;
    }
}

