/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.nio;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.net.HttpRequest;
import com.sshtools.common.net.HttpResponse;
import com.sshtools.common.ssh.AbstractRequestFuture;
import com.sshtools.common.ssh.ChannelRequestFuture;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.nio.ClientAcceptor;
import com.sshtools.synergy.nio.ClientConnector;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.LicenseException;
import com.sshtools.synergy.nio.ListeningInterface;
import com.sshtools.synergy.nio.PomVersion;
import com.sshtools.synergy.nio.ProtocolContext;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SelectorThread;
import com.sshtools.synergy.nio.SelectorThreadImpl;
import com.sshtools.synergy.nio.SelectorThreadPool;
import com.sshtools.synergy.nio.SocketConnection;
import com.sshtools.synergy.nio.SocketHandler;
import com.sshtools.synergy.nio.SshEngineContext;
import com.sshtools.synergy.nio.SshEngineListener;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SshEngine {
    static SshEngine defaultInstance = null;
    SshEngineContext context;
    SelectorThreadPool acceptThreads;
    SelectorThreadPool connectThreads;
    SelectorThreadPool transferThreads;
    Map<String, ProtocolClientAcceptor> acceptors = new ConcurrentHashMap<String, ProtocolClientAcceptor>(50, 0.9f, 1);
    Thread shutdownHook;
    boolean started;
    boolean isStarting = false;
    boolean startupRequiresListeningInterfaces = false;
    List<ListeningInterface> listeningInterfaces = Collections.synchronizedList(new ArrayList());
    ConcurrentLinkedQueue<Runnable> shutdownHooks = new ConcurrentLinkedQueue();
    Throwable lastError = null;
    AbstractRequestFuture shutdownFuture = new ChannelRequestFuture();
    List<SshEngineListener> listeners = Collections.synchronizedList(new ArrayList());
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();
    private static final String[] SOCKSV5_ERROR = new String[]{"Success", "General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
    private static final String[] SOCKSV4_ERROR = new String[]{"Request rejected or failed", "SOCKS server cannot connect to identd on the client", "The client program and identd report different user-ids"};
    private static final int SOCKS4 = 4;
    private static final int SOCKS5 = 5;
    private static final int CONNECT = 1;
    private static final int NULL_TERMINATION = 0;
    private static String version = PomVersion.getVersion();
    private static long releaseDate = 0L;
    Object license;

    public SshEngine() {
        this.context = new SshEngineContext(this);
    }

    public SshEngineContext getContext() {
        return this.context;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void addListener(SshEngineListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SshEngineListener listener) {
        this.listeners.remove(listener);
    }

    public static String getVersion() {
        return version;
    }

    public static Date getReleaseDate() {
        return new Date(releaseDate);
    }

    public boolean isStarting() {
        return this.isStarting;
    }

    public void addShutdownHook(Runnable r) {
        this.shutdownHooks.add(r);
    }

    protected int getIntValue(Properties properties, String overrideKey, int defaultValue) {
        if (properties.containsKey(overrideKey)) {
            try {
                return Integer.parseInt(properties.getProperty(overrideKey));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected boolean getBooleanValue(Properties properties, String overrideKey, boolean defaultValue) {
        if (properties.containsKey(overrideKey)) {
            try {
                return Boolean.parseBoolean(properties.getProperty(overrideKey));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected long getLongValue(Properties properties, String overrideKey, long defaultValue) {
        if (properties.containsKey(overrideKey)) {
            try {
                return Long.parseLong(properties.getProperty(overrideKey));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public synchronized boolean startup() throws IOException {
        return this.startup(System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startup(final Properties properties) throws IOException {
        this.isStarting = true;
        this.lastError = null;
        try {
            for (SshEngineListener listener : this.listeners) {
                listener.starting(this);
            }
            this.shutdownHook = new Thread(){

                @Override
                public void run() {
                    if (Log.isInfoEnabled()) {
                        Log.info((String)"The system is shutting down", (Object[])new Object[0]);
                    }
                    SshEngine.this.shutdownNow(true, SshEngine.this.getLongValue(properties, "maverick.config.shutdown.defaultGracePeriod", 5000L));
                }
            };
            if (Log.isInfoEnabled()) {
                Log.info((String)("Product version: " + version), (Object[])new Object[0]);
                Log.info((String)("Java version: " + System.getProperty("java.version")), (Object[])new Object[0]);
                Log.info((String)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch")), (Object[])new Object[0]);
                Log.info((String)"Configuring SSH engine", (Object[])new Object[0]);
            }
            if (Log.isInfoEnabled()) {
                Log.info((String)"Configuration complete", (Object[])new Object[0]);
            }
            if (Runtime.getRuntime() != null) {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            this.connectThreads = new SelectorThreadPool(new ConnectSelectorThread(), this.getIntValue(properties, "maverick.config.connect.threads", this.context.getPermanentConnectThreads()), this.getIntValue(properties, "maverick.config.channelsPerThread", this.context.getMaximumChannelsPerThread()), this.getIntValue(properties, "maverick.config.idlePeriod", this.context.getIdleServiceRunPeriod()), this.getIntValue(properties, "maverick.config.idleEvents", this.context.getInactiveServiceRunsPerIdleEvent()), this.context.getSelectorProvider());
            this.transferThreads = new SelectorThreadPool(new TransferSelectorThread(), this.getIntValue(properties, "maverick.config.transfer.threads", this.context.getPermanentTransferThreads()), this.getIntValue(properties, "maverick.config.channelsPerThread", this.context.getMaximumChannelsPerThread()), this.getIntValue(properties, "maverick.config.idlePeriod", this.context.getIdleServiceRunPeriod()), this.getIntValue(properties, "maverick.config.idleEvents", this.context.getInactiveServiceRunsPerIdleEvent()), this.context.getSelectorProvider());
            this.acceptThreads = new SelectorThreadPool(new AcceptSelectorThread(), this.getIntValue(properties, "maverick.config.accept.threads", this.context.getPermanentAcceptThreads()), this.getIntValue(properties, "maverick.config.channelsPerThread", this.context.getMaximumChannelsPerThread()), this.getIntValue(properties, "maverick.config.idlePeriod", this.context.getIdleServiceRunPeriod()), this.getIntValue(properties, "maverick.config.idleEvents", this.context.getInactiveServiceRunsPerIdleEvent()), this.context.getSelectorProvider());
            ListeningInterface[] interfaces = this.context.getListeningInterfaces();
            int listening = 0;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!this.startListeningInterface(interfaces[i])) continue;
                ++listening;
            }
            if (listening == 0 && this.startupRequiresListeningInterfaces) {
                if (Log.isInfoEnabled()) {
                    Log.info((String)"No listening interfaces were bound!", (Object[])new Object[0]);
                }
                this.shutdownNow(false, 0L);
                boolean bl = false;
                return bl;
            }
            this.started = true;
            for (SshEngineListener listener : this.listeners) {
                listener.started(this);
            }
            if (this.getBooleanValue(properties, "maverick.threadDump", false)) {
                new Thread("ThreadMonitor"){

                    @Override
                    public void run() {
                        while (SshEngine.this.isStarted()) {
                            try {
                                Thread.sleep(SshEngine.this.getLongValue(properties, "maverick.threadDumpInterval", 300000L));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            Log.raw((Log.Level)Log.Level.INFO, (String)Utils.generateThreadDump((Thread.State[])new Thread.State[0]), (boolean)true);
                        }
                    }
                }.start();
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable ex) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"The engine failed to start", (Throwable)ex, (Object[])new Object[0]);
            }
            this.lastError = ex;
            this.shutdownNow(false, 0L);
            if (ex instanceof LicenseException) {
                throw (IOException)ex;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.isStarting = false;
        }
    }

    protected boolean startListeningInterface(ListeningInterface li) {
        if (Log.isInfoEnabled()) {
            Log.info((String)("Binding server to " + li.getAddressToBind().toString()), (Object[])new Object[0]);
        }
        try {
            ServerSocketChannel socketChannel = this.context.getSelectorProvider().openServerSocketChannel();
            socketChannel.configureBlocking(false);
            socketChannel.socket().setReuseAddress(li.getSocketOptionReuseAddress());
            ServerSocket socket = socketChannel.socket();
            socket.bind(li.getAddressToBind(), li.getBacklog());
            li.setActualPort(socket.getLocalPort());
            socket.setReuseAddress(li.getSocketOptionReuseAddress());
            ProtocolClientAcceptor a = new ProtocolClientAcceptor(li, socketChannel);
            this.registerAcceptor(a, socketChannel);
            this.acceptors.put(li.getAddressToBind().toString(), a);
            for (SshEngineListener listener : this.listeners) {
                listener.interfaceStarted(this, li);
            }
            this.listeningInterfaces.add(li);
            return true;
        }
        catch (IOException ex) {
            if (Log.isInfoEnabled()) {
                Log.info((String)("Failed to bind to " + li.getAddressToBind().toString()), (Throwable)ex, (Object[])new Object[0]);
            }
            try {
                this.context.removeListeningInterface(li.getAddressToBind().getAddress().getHostAddress(), li.getActualPort());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            this.lastError = ex;
            for (SshEngineListener listener : this.listeners) {
                listener.interfaceCannotStart(this, li, ex);
            }
            return false;
        }
    }

    public void removeAcceptor(ListeningInterface li) {
        if (Log.isInfoEnabled()) {
            Log.info((String)("Removing interface " + li.getAddressToBind().toString()), (Object[])new Object[0]);
        }
        ProtocolClientAcceptor a = this.acceptors.remove(li.getAddressToBind().toString());
        try {
            if (a != null) {
                a.stopAccepting();
            }
            this.listeningInterfaces.remove(li);
            for (SshEngineListener listener : this.listeners) {
                listener.interfaceStopped(this, li);
            }
        }
        catch (IOException ex) {
            for (SshEngineListener listener : this.listeners) {
                listener.interfaceCannotStop(this, li, ex);
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void shutdownAsync(final boolean graceful, final long forceAfterMs) {
        Thread t = new Thread(){

            @Override
            public void run() {
                SshEngine.this.shutdownNow(graceful, forceAfterMs);
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownNow(boolean graceful, long forceAfterMs) {
        try {
            for (SshEngineListener listener : this.listeners) {
                listener.shuttingDown(this);
            }
            if (this.acceptThreads != null) {
                this.acceptThreads.shutdown();
            }
            for (ListeningInterface li : this.listeningInterfaces) {
                for (SshEngineListener listener : this.listeners) {
                    listener.interfaceStopped(this, li);
                }
            }
            this.listeningInterfaces.clear();
            if (graceful) {
                long started = System.currentTimeMillis();
                while (this.transferThreads.getCurrentLoad() > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (forceAfterMs <= 0L || System.currentTimeMillis() - started <= forceAfterMs) continue;
                }
            }
            if (this.transferThreads != null) {
                this.transferThreads.closeAllChannels();
            }
            try {
                if (Runtime.getRuntime() != null && this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.shutdownHook = null;
                for (SshEngineListener listener : this.listeners) {
                    listener.shutdown(this);
                }
            }
            finally {
                this.shutdownHook = null;
                for (SshEngineListener listener : this.listeners) {
                    listener.shutdown(this);
                }
            }
            if (this.shutdownHooks != null) {
                for (Runnable r : this.shutdownHooks) {
                    try {
                        r.run();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.connectThreads != null) {
                this.connectThreads.shutdown();
            }
            if (this.transferThreads != null) {
                this.transferThreads.shutdown();
            }
        }
        finally {
            this.started = false;
            this.shutdownFuture.done(true);
        }
    }

    public void shutdownAndExit() {
        this.shutdownNow(false, 0L);
        Log.getDefaultContext().shutdown();
    }

    public void restart() throws IOException {
        this.restart(false, 0L);
    }

    public void restart(boolean graceful, long forceAfterMs) throws IOException {
        this.shutdownNow(graceful, forceAfterMs);
        this.startup();
    }

    public <K extends ProtocolContext> ConnectRequestFuture connect(String hostToConnect, int portToConnect, K protocolContext) throws SshException, IOException {
        boolean connected;
        ConnectRequestFuture future;
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        socketChannel.socket().setTcpNoDelay(true);
        switch (protocolContext.getProxyType()) {
            case NONE: {
                future = new ConnectRequestFuture(hostToConnect, portToConnect);
                connected = socketChannel.connect(new InetSocketAddress(hostToConnect, portToConnect));
                break;
            }
            default: {
                future = new ConnectRequestFuture(protocolContext.getProxyHostname(), protocolContext.getProxyPort());
                connected = socketChannel.connect(new InetSocketAddress(protocolContext.getProxyHostname(), protocolContext.getProxyPort()));
            }
        }
        if (connected) {
            this.processOpenSocket(socketChannel, protocolContext, hostToConnect, portToConnect);
            socketChannel.configureBlocking(false);
            this.registerClientConnection(protocolContext, socketChannel, future);
        } else {
            this.registerConnector(new DaemonClientConnector(protocolContext, socketChannel, future, hostToConnect, portToConnect), socketChannel);
        }
        return future;
    }

    private void sendHTTPProxyRequest(SocketChannel channel, ProtocolContext protocolContext, String hostToConnect, int portToConnect) throws UnsupportedEncodingException, IOException {
        int count;
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Connecting via HTTP proxy {}:{}", (Object[])new Object[]{protocolContext.getProxyHostname(), protocolContext.getProxyPort()});
        }
        HttpRequest request = new HttpRequest();
        request.setHeaderBegin("CONNECT " + hostToConnect + ":" + portToConnect + " HTTP/1.0");
        request.setHeaderField("User-Agent", Utils.defaultString((String)protocolContext.getUserAgent(), (String)("MaverickSynergy/" + version)));
        request.setHeaderField("Pragma", "No-Cache");
        request.setHeaderField("Host", protocolContext.getProxyHostname());
        request.setHeaderField("Proxy-Connection", "Keep-Alive");
        if (Utils.isNotBlank((String)protocolContext.getProxyUsername()) && !Utils.isNotBlank((String)protocolContext.getProxyPassword())) {
            request.setBasicAuthentication(protocolContext.getProxyUsername(), protocolContext.getProxyPassword());
        }
        channel.write(ByteBuffer.wrap(request.toString().getBytes("UTF-8")));
        ByteBuffer buf = ByteBuffer.allocate(4096);
        while ((count = channel.read(buf)) > -1 && !this.isHTTPResponseComplete(buf)) {
        }
        HttpResponse resp = new HttpResponse();
        buf.flip();
        resp.process(buf);
        if (resp.getStatus() != 200) {
            throw new IOException("Invalid HTTP proxy response! " + resp.getStartLine());
        }
    }

    private boolean isHTTPResponseComplete(ByteBuffer buf) {
        buf.flip();
        boolean eol = false;
        if (buf.remaining() > 4) {
            eol = buf.get(buf.remaining() - 4) == 13 && buf.get(buf.remaining() - 3) == 10 && buf.get(buf.remaining() - 2) == 13 && buf.get(buf.remaining() - 1) == 10;
        }
        buf.compact();
        return eol;
    }

    protected SocketChannel processOpenSocket(SocketChannel socketChannel, ProtocolContext protocolContext, String hostToConnect, int portToConnect) throws UnsupportedEncodingException, IOException {
        switch (protocolContext.getProxyType()) {
            case HTTP: {
                this.sendHTTPProxyRequest(socketChannel, protocolContext, hostToConnect, portToConnect);
                break;
            }
            case SOCKS4: {
                break;
            }
            case SOCKS5: {
                break;
            }
        }
        return socketChannel;
    }

    public boolean isStartupRequiresListeningInterfaces() {
        return this.startupRequiresListeningInterfaces;
    }

    public void setStartupRequiresListeningInterfaces(boolean startupRequiresListeningInterfaces) {
        this.startupRequiresListeningInterfaces = startupRequiresListeningInterfaces;
    }

    private <K extends ProtocolContext> ProtocolEngine registerClientConnection(K protocolContext, SocketChannel socketChannel, ConnectRequestFuture connectFuture) throws IOException {
        SocketConnection connection = protocolContext.getSocketConnectionFactory().createSocketConnection(this.context, socketChannel.socket().getLocalSocketAddress(), socketChannel.socket().getRemoteSocketAddress());
        ProtocolEngine engine = protocolContext.createEngine(connectFuture);
        connection.initialize(engine, this, socketChannel);
        this.registerHandler(connection, socketChannel);
        return engine;
    }

    public void registerConnector(ClientConnector connector, SocketChannel socketChannel) throws IOException {
        SelectorThread t = this.connectThreads.selectNextThread();
        t.register(socketChannel, 8, connector, true);
    }

    public void registerAcceptor(ClientAcceptor acceptor, ServerSocketChannel socketChannel) throws IOException {
        this.acceptThreads.register(socketChannel, 16, acceptor, true);
    }

    public void registerHandler(SocketHandler handler, SelectableChannel channel) throws IOException {
        SelectorThread t = this.transferThreads.selectNextThread();
        this.registerHandler(handler, channel, t);
    }

    public void registerHandler(SocketHandler handler, SelectableChannel channel, SelectorThread thread) throws IOException {
        handler.setThread(thread);
        if (thread == null) {
            throw new IOException("Unable to allocate thread");
        }
        thread.register(channel, handler.getInitialOps(), handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshEngine getDefaultInstance() throws IOException {
        Class<SshEngine> clazz = SshEngine.class;
        synchronized (SshEngine.class) {
            if (defaultInstance == null) {
                defaultInstance = new SshEngine();
                if (!defaultInstance.startup()) {
                    throw new IOException("Failed to start SSH engine");
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        defaultInstance.shutdownNow(false, 0L);
                    }
                });
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultInstance;
            }
            if (!defaultInstance.isStarted()) {
                defaultInstance.startup();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public AbstractRequestFuture getShutdownFuture() {
        return this.shutdownFuture;
    }

    class ProtocolClientAcceptor
    extends ClientAcceptor {
        ServerSocketChannel socketChannel;
        ListeningInterface li;

        ProtocolClientAcceptor(ListeningInterface li, ServerSocketChannel socketChannel) {
            super(li);
            this.li = li;
            this.socketChannel = socketChannel;
        }

        @Override
        public boolean finishAccept(SelectionKey key, ListeningInterface li) {
            AbstractInterruptibleChannel sc = null;
            boolean registered = false;
            try {
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777216, true).addAttribute("IP", (Object)((ServerSocketChannel)key.channel()).socket().getInetAddress().getHostAddress()));
                sc = ((ServerSocketChannel)key.channel()).accept();
                if (sc != null) {
                    Object protocolContext = li.getContextFactory().createContext(SshEngine.this.context, (SocketChannel)sc);
                    ((SocketChannel)sc).socket().setKeepAlive(((ProtocolContext)protocolContext).getSocketOptionKeepAlive());
                    ((SocketChannel)sc).socket().setTcpNoDelay(((ProtocolContext)protocolContext).getSocketOptionTcpNoDelay());
                    if (((ProtocolContext)protocolContext).getSendBufferSize() > 0) {
                        ((SocketChannel)sc).socket().setSendBufferSize(((ProtocolContext)protocolContext).getSendBufferSize());
                    }
                    ((AbstractSelectableChannel)sc).configureBlocking(false);
                    if (Log.isWarnEnabled() && ((ProtocolContext)protocolContext).getReceiveBufferSize() > 0 && ((SocketChannel)sc).socket().getReceiveBufferSize() != ((ProtocolContext)protocolContext).getReceiveBufferSize()) {
                        Log.warn((String)("WARNING: TCP receive buffer could not be set to " + ((ProtocolContext)protocolContext).getReceiveBufferSize() + ". The socket reported a size of " + ((SocketChannel)sc).socket().getReceiveBufferSize()), (Object[])new Object[0]);
                    }
                    if (Log.isWarnEnabled() && ((ProtocolContext)protocolContext).getSendBufferSize() > 0 && ((SocketChannel)sc).socket().getSendBufferSize() != ((ProtocolContext)protocolContext).getSendBufferSize()) {
                        Log.warn((String)("WARNING: TCP send buffer could not be set to " + ((ProtocolContext)protocolContext).getSendBufferSize() + ". The socket reported a size of " + ((SocketChannel)sc).socket().getSendBufferSize()), (Object[])new Object[0]);
                    }
                    SocketConnection connection = ((ProtocolContext)protocolContext).getSocketConnectionFactory().createSocketConnection(SshEngine.this.context, ((SocketChannel)sc).socket().getLocalSocketAddress(), ((SocketChannel)sc).socket().getRemoteSocketAddress());
                    ProtocolEngine e = ((ProtocolContext)protocolContext).createEngine(new ConnectRequestFuture());
                    connection.initialize(e, SshEngine.this, (SelectableChannel)sc);
                    SshEngine.this.registerHandler(connection, (SelectableChannel)sc);
                    registered = true;
                    return !((ServerSocketChannel)key.channel()).isOpen();
                }
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Accept event fired but no socket was accepted", (Object[])new Object[0]);
                }
                return true;
            }
            catch (Throwable ex) {
                if (Log.isInfoEnabled()) {
                    Log.info((String)"SSH client acceptor failed to accept", (Throwable)ex, (Object[])new Object[0]);
                }
                if (sc != null && !registered) {
                    try {
                        sc.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        ((SocketChannel)sc).socket().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return !((ServerSocketChannel)key.channel()).isOpen();
            }
        }

        @Override
        public void stopAccepting() throws IOException {
            this.socketChannel.close();
        }
    }

    class DaemonClientConnector
    implements ClientConnector {
        ProtocolContext protocolContext;
        SocketChannel socketChannel;
        ProtocolEngine engine;
        ConnectRequestFuture connectFuture;
        String hostToConnect;
        int portToConnect;

        DaemonClientConnector(ProtocolContext protocolContext, SocketChannel socketChannel, ConnectRequestFuture connectFuture, String hostToConnect, int portToConnect) {
            this.protocolContext = protocolContext;
            this.socketChannel = socketChannel;
            this.connectFuture = connectFuture;
            this.hostToConnect = hostToConnect;
            this.portToConnect = portToConnect;
        }

        @Override
        public void registrationCompleted(SelectableChannel channel, SelectionKey key, SelectorThread selectorThread) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean finishConnect(SelectionKey key) {
            try {
                while (!this.socketChannel.finishConnect()) {
                }
                SshEngine.this.processOpenSocket(this.socketChannel, this.protocolContext, this.hostToConnect, this.portToConnect);
                this.engine = SshEngine.this.registerClientConnection(this.protocolContext, this.socketChannel, this.connectFuture);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                Log.error((String)"Failed to connect socket", (Throwable)e, (Object[])new Object[0]);
                boolean bl = false;
                return bl;
            }
            finally {
                key.cancel();
            }
        }
    }

    class ConnectSelectorThread
    implements SelectorThreadImpl {
        ConnectSelectorThread() {
        }

        @Override
        public void processSelectionKey(SelectionKey key, SelectorThread thread) {
            ClientConnector con = (ClientConnector)key.attachment();
            if (con.finishConnect(key)) {
                key.cancel();
            }
        }

        @Override
        public String getName() {
            return SshEngine.this.context.getProduct() + "-CONNECT";
        }
    }

    class SocketReadWriteTask
    extends ConnectionAwareTask {
        SocketHandler listener;
        SelectionKey key;

        SocketReadWriteTask(Connection<?> con, SelectionKey key, SocketHandler listener) {
            super(con);
            this.key = key;
            this.listener = listener;
        }

        public void doTask() {
            boolean cancel = false;
            if (this.key.isValid() && this.key.isWritable()) {
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Starting {} WRITE", (Object[])new Object[]{this.listener.getName()});
                }
                cancel = this.listener.processWriteEvent();
            }
            if (this.key.isValid() && this.key.isReadable()) {
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Starting {} READ", (Object[])new Object[]{this.listener.getName()});
                }
                cancel |= this.listener.processReadEvent();
            }
            if (cancel) {
                this.key.cancel();
            } else {
                this.listener.getSelectorThread().addSelectorOperation(new Runnable(){

                    @Override
                    public void run() {
                        if (SocketReadWriteTask.this.key.isValid()) {
                            int ops = 0;
                            boolean wantsWrite = SocketReadWriteTask.this.listener.wantsWrite();
                            boolean wantsRead = SocketReadWriteTask.this.listener.wantsRead();
                            if (wantsWrite) {
                                ops |= 4;
                            }
                            if (wantsRead) {
                                ops |= 1;
                            }
                            if (Log.isTraceEnabled()) {
                                Log.trace((String)"{} has state ops={} {}", (Object[])new Object[]{SocketReadWriteTask.this.listener.getName(), ops, wantsWrite && wantsRead ? "READ/WRITE" : (wantsWrite ? "WRITE" : (wantsRead ? "READ" : "NONE"))});
                            }
                            SocketReadWriteTask.this.key.interestOps(ops);
                        }
                    }
                });
            }
        }
    }

    class TransferSelectorThread
    implements SelectorThreadImpl {
        TransferSelectorThread() {
        }

        @Override
        public void processSelectionKey(SelectionKey key, SelectorThread t) {
            SocketHandler listener = (SocketHandler)key.attachment();
            if (key != null && key.isValid()) {
                key.interestOps(0);
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Processing {}{}{}", (Object[])new Object[]{listener.getName(), key.isReadable() ? " READ" : "", key.isWritable() ? " WRITE" : ""});
                }
                listener.addTask(new SocketReadWriteTask(listener.getConnection(), key, listener));
            }
        }

        @Override
        public String getName() {
            return SshEngine.this.context.getProduct() + "-TRANSFER";
        }
    }

    class AcceptSelectorThread
    implements SelectorThreadImpl {
        AcceptSelectorThread() {
        }

        @Override
        public void processSelectionKey(SelectionKey key, SelectorThread thread) {
            ClientAcceptor acceptor = (ClientAcceptor)key.attachment();
            if (Log.isTraceEnabled()) {
                Log.trace((String)(SshEngine.this.context.getBufferPool().getAllocatedBuffers() + " direct buffers allocated, " + SshEngine.this.context.getBufferPool().getFreeBuffers() + " free"), (Object[])new Object[0]);
            }
            acceptor.finishAccept(key);
        }

        @Override
        public String getName() {
            return SshEngine.this.context.getProduct() + "-ACCEPT";
        }
    }
}

