/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventException;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.events.EventTrigger;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.AbstractRequestFuture;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.GlobalRequest;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshConnectionManager;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.synergy.nio.SshEngine;
import com.sshtools.synergy.ssh.AuthenticatedFuture;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class Connection<T extends SshContext>
implements EventTrigger,
SshConnection {
    TransportProtocol<? extends Context> transport;
    ConnectionProtocol<T> connection;
    String username;
    boolean closed = false;
    Date startTime = new Date();
    HashMap<String, Object> properties = new HashMap();
    InetSocketAddress remoteAddress;
    InetSocketAddress localAddress;
    T context;
    List<EventListener> listeners = new ArrayList<EventListener>();
    Locale locale;

    public Connection(T context) {
        this.context = context;
        this.listeners.add(new EventListener(){

            public void processEvent(Event evt) {
                if (evt.getId() == -16776961 && !Connection.this.getAuthenticatedFuture().isDone()) {
                    Connection.this.getAuthenticatedFuture().authenticated(false);
                }
            }
        });
    }

    public synchronized void addEventListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void fireEvent(Event evt) {
        EventException lastException = null;
        for (EventListener listener : this.listeners) {
            try {
                listener.processEvent(evt);
            }
            catch (Throwable t) {
                if (t instanceof EventException) {
                    lastException = (EventException)t;
                    continue;
                }
                if (!Log.isWarnEnabled()) continue;
                Log.warn((String)"Caught exception from event listener", (Throwable)t, (Object[])new Object[0]);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public AuthenticatedFuture getAuthenticatedFuture() {
        return this.transport.getAuthenticatedFuture();
    }

    public String getSessionId() {
        return this.transport.getUUID();
    }

    public String getRemoteIdentification() {
        return this.transport.getRemoteIdentification();
    }

    public ConnectionAwareTask addTask(ConnectionAwareTask r) {
        ((SshContext)this.context).getExecutorService().execute((Runnable)r);
        return r;
    }

    public ConnectionAwareTask addTask(Runnable r) {
        ConnectionTaskWrapper t = new ConnectionTaskWrapper(this, r);
        ((SshContext)this.context).getExecutorService().execute((Runnable)((Object)t));
        return t;
    }

    public <R> Future<R> executeTask(Callable<R> task) {
        return ((SshContext)this.context).getExecutorService().submit(task);
    }

    public void executeTask(Runnable r) {
        ((SshContext)this.context).getExecutorService().submit(r);
    }

    public String getUUID() {
        return this.transport.getUUID();
    }

    public String getUsername() {
        return this.username;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public long getTotalBytesIn() {
        return this.transport.incomingBytes;
    }

    public long getTotalBytesOut() {
        return this.transport.outgoingBytes;
    }

    @Deprecated
    public InetAddress getRemoteAddress() {
        return this.remoteAddress.getAddress();
    }

    public String getRemoteIPAddress() {
        return this.remoteAddress.getHostString();
    }

    public int getRemotePort() {
        return this.remoteAddress.getPort();
    }

    @Deprecated
    public SocketAddress getRemoteSocketAddress() {
        return this.remoteAddress;
    }

    @Deprecated
    public SocketAddress getLocalSocketAddress() {
        return this.localAddress;
    }

    @Deprecated
    public InetAddress getLocalAddress() {
        return this.localAddress.getAddress();
    }

    public String getLocalIPAddress() {
        return this.localAddress.getHostString();
    }

    public int getLocalPort() {
        return this.localAddress.getPort();
    }

    public boolean isDisconnected() {
        return this.getDisconnectFuture().isDone();
    }

    public boolean isDisconnecting() {
        return this.transport.isDisonnecting();
    }

    public void disconnect() {
        this.disconnect("By Application");
    }

    public void disconnect(String reason) {
        if (!this.closed) {
            this.transport.disconnect(11, reason);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object val) {
        this.properties.put(name, val);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public boolean isAuthenticated() {
        return this.connection != null;
    }

    public T getContext() {
        return this.context;
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ConnectionProtocol<T> getConnectionProtocol() {
        return this.connection;
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public String getHostKeyAlgorithm() {
        return this.transport.getHostKeyAlgorithm();
    }

    public String getCipherInUseCS() {
        return this.transport.getCipherCS();
    }

    public String getCipherInUseSC() {
        return this.transport.getCipherSC();
    }

    public String getMacInUseCS() {
        return this.transport.getMacCS();
    }

    public String getMacInUseSC() {
        return this.transport.getMacSC();
    }

    public String getCompressionInUseCS() {
        return this.transport.getCompressionCS();
    }

    public String getCompressionInUseSC() {
        return this.transport.getCompressionSC();
    }

    public void close() {
        this.closed = true;
        this.listeners.clear();
    }

    public Locale getLocale() {
        return Objects.isNull(this.locale) ? ((SshContext)this.context).getLocale() : this.locale;
    }

    public SshConnectionManager getConnectionManager() {
        return ((SshContext)this.context).getConnectionManager();
    }

    public boolean isConnected() {
        return this.transport.isConnected();
    }

    public void addTask(Integer queue, ConnectionAwareTask r) {
        this.transport.addTask(queue, r);
    }

    public int getSessionCount() {
        int count = 0;
        for (ChannelNG<T> channel : this.connection.getActiveChannels()) {
            if (!channel.getChannelType().equals("session")) continue;
            ++count;
        }
        return count;
    }

    public void disconnect(int reason, String message) {
        this.transport.disconnect(reason, message);
    }

    public String getServerVersion() {
        return SshEngine.getVersion();
    }

    public void openChannel(Channel channel) {
        if (this.connection == null) {
            throw new IllegalStateException("Not connected.");
        }
        this.connection.openChannel((ChannelNG)channel);
    }

    public void startLogging(Log.Level level) throws IOException {
        ((SshContext)this.context).getConnectionManager().startLogging(this, level);
    }

    public void startLogging() throws IOException {
        ((SshContext)this.context).getConnectionManager().startLogging(this);
    }

    public AbstractRequestFuture getDisconnectFuture() {
        return this.transport.disconnectFuture;
    }

    public SshPublicKey getHostKey() {
        return this.transport.getHostKey();
    }

    public String[] getRemotePublicKeys() {
        return this.transport.getRemotePublicKeys();
    }

    public String[] getRemoteKeyExchanges() {
        return this.transport.getRemoteKeyExchanges();
    }

    public String[] getRemoteCompressionsCS() {
        return this.transport.getRemoteCompressionsCS();
    }

    public String[] getRemoteCompressionsSC() {
        return this.transport.getRemoteCompressionsSC();
    }

    public String[] getRemoteCiphersCS() {
        return this.transport.getRemoteCiphersCS();
    }

    public String[] getRemoteCiphersSC() {
        return this.transport.getRemoteCiphersSC();
    }

    public String[] getRemoteMacsCS() {
        return this.transport.getRemoteMacsCS();
    }

    public String[] getRemoteMacsSC() {
        return this.transport.getRemoteMacsSC();
    }

    public String getKeyExchangeInUse() {
        return this.transport.getKeyExchangeInUse();
    }

    public String getHostKeyInUse() {
        return this.transport.getHostKeyInUse();
    }

    public String getLocalIdentification() {
        return this.transport.getLocalIdentification();
    }

    public void sendGlobalRequest(GlobalRequest request, boolean wantReply) {
        this.connection.sendGlobalRequest(request, wantReply);
    }

    public void setLocalAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String toString() {
        return this.transport.getUUID();
    }
}

