/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.IPPolicy;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.sshd.AbstractServerTransport;
import com.sshtools.common.sshd.Service;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.server.AuthenticationProtocolServer;
import com.sshtools.server.LoadBalancerPolicy;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.LicenseException;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SocketConnection;
import com.sshtools.synergy.ssh.ConnectionStateListener;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.TransportProtocol;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public final class TransportProtocolServer
extends TransportProtocol<SshServerContext>
implements AbstractServerTransport<SshServerContext> {
    int disconnectReason;
    String disconnectText;
    boolean denyConnection = false;

    public TransportProtocolServer(SshServerContext sshContext, ConnectRequestFuture connectFuture) throws LicenseException {
        super((SshContext)sshContext, connectFuture);
    }

    public SshServerContext getContext() {
        return (SshServerContext)this.sshContext;
    }

    private void processProxyProtocol(String tmp) throws IOException {
        String[] elements;
        if (!((LoadBalancerPolicy)this.getContext().getPolicy(LoadBalancerPolicy.class)).isProxyProtocolEnabled()) {
            throw new IOException("Received PROXY protocol directive but the current policy does not support it");
        }
        if (((LoadBalancerPolicy)this.getContext().getPolicy(LoadBalancerPolicy.class)).isRestrictedAccess()) {
            String remoteAddress = ((InetSocketAddress)this.socketConnection.getRemoteAddress()).getAddress().getHostAddress();
            if (!((LoadBalancerPolicy)this.getContext().getPolicy(LoadBalancerPolicy.class)).isSupportedIPAddress(remoteAddress)) {
                throw new IOException(String.format("Received PROXY protocol string from unsupported IP address %s", remoteAddress));
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"PROXY protocol directive enabled by remote IP adresss {}", (Object[])new Object[]{remoteAddress});
            }
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)String.format("Parsing PROXY protocol string [%s]", tmp), (Object[])new Object[0]);
        }
        if ((elements = tmp.split(" ")).length < 4) {
            if (Log.isInfoEnabled()) {
                Log.info((String)"Not enough parameters in PROXY statement", (Object[])new Object[0]);
            }
            return;
        }
        if ("TCP4".equals(elements[1]) || "TCP6".equals(elements[1])) {
            String sourceAddress = elements[2].trim();
            String targetAddress = elements[3].trim();
            int sourcePort = Integer.parseInt(elements[4].trim());
            int targetPort = Integer.parseInt(elements[5].trim());
            this.con.setRemoteAddress(InetSocketAddress.createUnresolved(sourceAddress, sourcePort));
            this.con.setLocalAddress(InetSocketAddress.createUnresolved(targetAddress, targetPort));
        }
    }

    protected void processNegotiationString(String value) throws IOException {
        if (value.startsWith("PROXY")) {
            this.processProxyProtocol(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canConnect(SocketConnection connection) {
        boolean canConnect = ((IPPolicy)((SshServerContext)this.sshContext).getPolicy(IPPolicy.class)).checkConnection(connection.getRemoteAddress(), connection.getLocalAddress());
        if (Log.isDebugEnabled()) {
            Log.debug((String)("IP policy has " + (canConnect ? "authorized" : "denied") + " access to " + ((InetSocketAddress)connection.getRemoteAddress()).getAddress()), (Object[])new Object[0]);
        }
        if (!canConnect) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            Integer numberOfConnections = ((SshServerContext)this.sshContext).getConnectionManager().getNumberOfConnections();
            if (((SshServerContext)this.sshContext).getEngine().getContext().getMaximumConnections() > -1 && numberOfConnections >= ((SshServerContext)this.sshContext).getEngine().getContext().getMaximumConnections()) {
                this.denyConnection = true;
                this.disconnectText = ((SshServerContext)this.sshContext).getEngine().getContext().getTooManyConnectionsText();
                this.disconnectReason = 12;
                if (!((SshServerContext)this.sshContext).isEnsureGracefulDisconnect()) {
                    this.fireTooManyConnectionsDisconnectEvent(numberOfConnections);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Denying connection.. too many users currently online", (Object[])new Object[0]);
                    }
                    connection.closeConnection();
                    return false;
                }
                this.sessionIdentifier = new byte[0];
            }
        }
        return true;
    }

    protected void initializeKeyExchange(SshKeyExchange<SshServerContext> keyExchange, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        SshKeyPair pair = this.getContext().getHostKey(this.publicKey);
        this.hostKey = pair.getPublicKey();
        keyExchange.init((SshTransport)this, this.remoteIdentification.toString().trim(), this.localIdentification.trim(), this.remotekex, this.localkex, pair.getPrivateKey(), pair.getPublicKey(), firstPacketFollows, useFirstPacket);
    }

    protected void onKeyExchangeInit() throws SshException {
        if (this.getContext().isForceServerPreferences()) {
            this.getContext().supportedKeyExchanges().removeAllBut(this.getContext().supportedKeyExchanges().selectStrongestComponent(this.getRemoteKeyExchanges()));
            this.getContext().supportedPublicKeys().removeAllBut(this.getContext().supportedPublicKeys().selectStrongestComponent(this.getRemotePublicKeys()));
            this.getContext().supportedCiphersCS().removeAllBut(this.getContext().supportedCiphersCS().selectStrongestComponent(this.getRemoteCiphersCS()));
            this.getContext().supportedCiphersCS().removeAllBut(this.getContext().supportedCiphersCS().selectStrongestComponent(this.getRemoteCiphersSC()));
            this.getContext().supportedMacsCS().removeAllBut(this.getContext().supportedMacsCS().selectStrongestComponent(this.getRemoteMacsCS()));
            this.getContext().supportedMacsSC().removeAllBut(this.getContext().supportedMacsSC().selectStrongestComponent(this.getRemoteMacsSC()));
        }
    }

    protected void keyExchangeInitialized() {
        if (this.denyConnection) {
            this.fireTooManyConnectionsDisconnectEvent(((SshServerContext)this.sshContext).getConnectionManager().getNumberOfConnections());
            this.disconnect(this.disconnectReason, this.disconnectText);
        }
    }

    protected boolean canSendKeyExchangeInit() {
        return !this.getContext().isForceServerPreferences();
    }

    protected void onNewKeysReceived() {
        this.generateNewKeysServerIn();
    }

    protected boolean processTransportMessage(int msgId, byte[] msg) throws IOException {
        switch (msg[0]) {
            case 5: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_MSG_SERVICE_REQUEST", (Object[])new Object[0]);
                }
                this.startService(msg);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startService(byte[] msg) throws IOException {
        try (ByteArrayReader bar = new ByteArrayReader(msg);){
            bar.skip(1L);
            String servicename = bar.readString();
            if (servicename.equals("ssh-userauth")) {
                this.activeService = new AuthenticationProtocolServer(this);
                final byte[] serviceNameBytes = TransportProtocolServer.getBytes((String)servicename, (String)CHARSET_ENCODING);
                this.postMessage(new SshMessage(){

                    public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                        buf.put((byte)6);
                        buf.putInt(serviceNameBytes.length);
                        buf.put(serviceNameBytes);
                        return true;
                    }

                    public void messageSent(Long sequenceNo) throws SshException {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Sent SSH_MSG_SERVICE_ACCEPT", (Object[])new Object[0]);
                        }
                        TransportProtocolServer.this.activeService.start();
                    }
                });
            } else {
                this.disconnect(7, servicename + " is not a valid service.");
            }
        }
    }

    void startService(com.sshtools.synergy.ssh.Service activeService) throws SshException {
        this.activeService.stop();
        this.activeService = activeService;
        activeService.start();
    }

    protected void onNewKeysSent() {
        this.generateNewKeysServerOut();
    }

    protected void disconnected() {
        for (ConnectionStateListener connectionStateListener : this.getContext().getStateListeners()) {
            connectionStateListener.disconnected((SshConnection)this.getContext().getConnectionManager().getConnectionById(this.getUUID()));
        }
    }

    protected void onConnected() {
        this.con = this.getContext().getConnectionManager().registerTransport((TransportProtocol)this, (SshContext)this.getContext());
        this.getConnectFuture().connected((ProtocolEngine)this, this.con);
    }

    protected void onDisconnected() {
        this.getContext().getConnectionManager().unregisterTransport((TransportProtocol)this);
    }

    private void fireTooManyConnectionsDisconnectEvent(Integer numberOfConnections) {
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777056, false).addAttribute("CONNECTION", (Object)this.con).addAttribute("NUMBER_OF_CONNECTIONS", (Object)String.valueOf(numberOfConnections)));
    }

    public String getName() {
        return "transport-server";
    }

    public void startService(Service<SshServerContext> service) {
    }
}

