/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.DiffieHellmanGroups;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.components.SshKeyExchangeServer;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.jce.AbstractKeyExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanGroupExchangeSha1JCE
extends SshKeyExchangeServer
implements AbstractKeyExchange {
    static final int SSH_MSG_KEY_DH_GEX_REQUEST_OLD = 30;
    static final int SSH_MSG_KEY_DH_GEX_GROUP = 31;
    static final int SSH_MSG_KEY_DH_GEX_INIT = 32;
    static final int SSH_MSG_KEY_DH_GEX_REPLY = 33;
    static final int SSH_MSG_KEY_DH_GEX_REQUEST = 34;
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO = BigInteger.valueOf(2L);
    BigInteger g = null;
    BigInteger p = null;
    BigInteger e = null;
    BigInteger f = null;
    UnsignedInteger32 min = null;
    UnsignedInteger32 n = null;
    UnsignedInteger32 max = null;
    KeyPairGenerator dhKeyPairGen;
    KeyAgreement dhKeyAgreement;
    KeyFactory dhKeyFactory;
    static int maxSupportedSize = -1;
    static int minSupportedSize = -1;
    public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";

    public DiffieHellmanGroupExchangeSha1JCE() {
        super("SHA-1", SecurityLevel.WEAK, 1000);
    }

    public DiffieHellmanGroupExchangeSha1JCE(String hashAlgorithm, SecurityLevel securityLevel, int priority) {
        super(hashAlgorithm, securityLevel, priority);
    }

    @Override
    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1;
    }

    void initCrypto() throws NoSuchAlgorithmException {
        this.dhKeyFactory = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
        this.dhKeyPairGen = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
        this.dhKeyAgreement = JCEProvider.getProviderForAlgorithm((String)"DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm((String)"DH"));
    }

    public void init(SshTransport<SshServerContext> transport, String clientIdentification, String serverIdentification, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        this.clientId = clientIdentification;
        this.serverId = serverIdentification;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.prvkey = prvkey;
        this.pubkey = pubkey;
        this.firstPacketFollows = firstPacketFollows;
        this.useFirstPacket = useFirstPacket;
        this.transport = transport;
        try {
            this.initCrypto();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SshIOException(new SshException("JCE does not support Diffie Hellman key exchange", 16));
        }
    }

    public String getProvider() {
        if (this.dhKeyAgreement != null) {
            return this.dhKeyAgreement.getProvider().getName();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exchangeGroup(byte[] msg) throws SshException, IOException {
        if (this.firstPacketFollows && !this.useFirstPacket) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Client attempted to guess the kex in use but we determined it was wrong so we're waiting for another message", (Object[])new Object[0]);
            }
            this.firstPacketFollows = false;
            return true;
        }
        try (ByteArrayReader bar = new ByteArrayReader(msg);){
            switch (bar.read()) {
                case 30: {
                    this.n = bar.readUINT32();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received SSH_MSG_KEY_DH_GEX_REQUEST_OLD n={}", (Object[])new Object[]{this.n.longValue()});
                    }
                    DiffieHellmanGroups.DHGroup group = DiffieHellmanGroups.getSafePrime((UnsignedInteger32)new UnsignedInteger32((long)Math.min(maxSupportedSize, Math.max(Math.min(this.n.intValue(), ((SshServerContext)this.transport.getContext()).getMaxDHGroupExchangeKeySize()), ((SshServerContext)this.transport.getContext()).getMinDHGroupExchangeKeySize()))));
                    this.p = group.getP();
                    this.g = group.getG();
                    break;
                }
                case 34: {
                    this.min = bar.readUINT32();
                    this.n = bar.readUINT32();
                    this.max = bar.readUINT32();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Recieved SSH_MSG_KEY_DH_GEX_REQUEST min={} n={} max={}", (Object[])new Object[]{this.min.longValue(), this.n.longValue(), this.max.longValue()});
                    }
                    DiffieHellmanGroups.DHGroup group = DiffieHellmanGroups.getSafePrime((UnsignedInteger32)new UnsignedInteger32((long)Math.min(maxSupportedSize, Math.max(Math.min(this.n.intValue(), ((SshServerContext)this.transport.getContext()).getMaxDHGroupExchangeKeySize()), ((SshServerContext)this.transport.getContext()).getMinDHGroupExchangeKeySize()))));
                    this.p = group.getP();
                    this.g = group.getG();
                    if (!Log.isDebugEnabled()) break;
                    Log.debug((String)"Selected {} bit prime and {} bit group", (Object[])new Object[]{this.p.bitLength(), this.g.bitLength()});
                    break;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
            if (!Boolean.getBoolean("maverick.disableAsyncKex")) {
                ((SshServerContext)this.transport.getContext()).getExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        DiffieHellmanGroupExchangeSha1JCE.this.prepareGroup();
                    }
                });
            } else {
                this.prepareGroup();
            }
            boolean bl = true;
            return bl;
        }
    }

    public void prepareGroup() {
        try {
            int retry = 3;
            do {
                if (retry == 0) {
                    this.transport.disconnect(3, "Failed to generate key exchange value");
                    return;
                }
                --retry;
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, this.g);
                this.dhKeyPairGen.initialize(dhSkipParamSpec);
                KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                this.f = ((DHPublicKey)dhKeyPair.getPublic()).getY();
            } while (!DiffieHellmanGroups.verifyParameters((BigInteger)this.f, (BigInteger)this.p));
            this.transport.postMessage(new SshMessage(){

                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    buf.put((byte)31);
                    byte[] tmp = DiffieHellmanGroupExchangeSha1JCE.this.p.toByteArray();
                    buf.putInt(tmp.length);
                    buf.put(tmp);
                    tmp = DiffieHellmanGroupExchangeSha1JCE.this.g.toByteArray();
                    buf.putInt(tmp.length);
                    buf.put(tmp);
                    return true;
                }

                public void messageSent(Long sequenceNo) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Sent SSH_MSG_KEY_DH_GEX_GROUP p={}, g={}", (Object[])new Object[]{DiffieHellmanGroupExchangeSha1JCE.this.p.toString(16), DiffieHellmanGroupExchangeSha1JCE.this.g.toString(16)});
                    }
                }
            }, true);
        }
        catch (InvalidKeyException ex) {
            this.transport.disconnect(3, ex.getMessage());
        }
        catch (InvalidAlgorithmParameterException ex) {
            this.transport.disconnect(3, ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processMessage(byte[] msg) throws SshException, IOException {
        if (this.exchangeGroup(msg)) {
            return true;
        }
        try (ByteArrayReader bar = new ByteArrayReader(msg);){
            if (bar.read() != 32) {
                boolean bl = false;
                return bl;
            }
            this.e = bar.readBigInteger();
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Recieved SSH_MSG_KEY_DH_GEX_INIT e={}", (Object[])new Object[]{this.e.toString(16)});
            }
            if (!DiffieHellmanGroups.verifyParameters((BigInteger)this.e, (BigInteger)this.p)) {
                throw new SshException(String.format("Key exchange detected invalid e value {}", this.e.toString(16)), 3);
            }
            if (!Boolean.getBoolean("maverick.disableAsyncKex")) {
                ((SshServerContext)this.transport.getContext()).getExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        DiffieHellmanGroupExchangeSha1JCE.this.doKex();
                    }
                });
            } else {
                this.doKex();
            }
            boolean bl = true;
            return bl;
        }
    }

    private void doKex() {
        try {
            DHPublicKeySpec spec = new DHPublicKeySpec(this.e, this.p, this.g);
            try {
                DHPublicKey key = (DHPublicKey)this.dhKeyFactory.generatePublic(spec);
                this.dhKeyAgreement.doPhase(key, true);
                byte[] tmp = this.dhKeyAgreement.generateSecret();
                if ((tmp[0] & 0x80) == 128) {
                    byte[] tmp2 = new byte[tmp.length + 1];
                    System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                    tmp = tmp2;
                }
                this.secret = new BigInteger(tmp);
            }
            catch (Exception e1) {
                throw new SshException((Throwable)e1);
            }
            if (!DiffieHellmanGroups.verifyParameters((BigInteger)this.secret, (BigInteger)this.p)) {
                throw new SshException(String.format("Key exchange detected invalid k value {}", this.e.toString(16)), 3);
            }
            this.hostKey = this.pubkey.getEncoded();
            this.calculateExchangeHash();
            this.signature = this.prvkey.sign(this.exchangeHash, this.pubkey.getSigningAlgorithm());
            this.transport.postMessage(new SshMessage(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    ByteArrayWriter baw = new ByteArrayWriter();
                    try {
                        buf.put((byte)33);
                        buf.putInt(DiffieHellmanGroupExchangeSha1JCE.this.hostKey.length);
                        buf.put(DiffieHellmanGroupExchangeSha1JCE.this.hostKey);
                        byte[] tmp = DiffieHellmanGroupExchangeSha1JCE.this.f.toByteArray();
                        buf.putInt(tmp.length);
                        buf.put(tmp);
                        baw.writeString(DiffieHellmanGroupExchangeSha1JCE.this.pubkey.getAlgorithm());
                        baw.writeBinaryString(DiffieHellmanGroupExchangeSha1JCE.this.signature);
                        tmp = baw.toByteArray();
                        buf.putInt(tmp.length);
                        buf.put(tmp);
                    }
                    catch (IOException ex) {
                        DiffieHellmanGroupExchangeSha1JCE.this.transport.disconnect(3, "Could not read host key");
                    }
                    finally {
                        try {
                            baw.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return true;
                }

                public void messageSent(Long sequenceNo) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Sent SSH_MSG_KEY_DH_GEX_REPLY f={}", (Object[])new Object[]{DiffieHellmanGroupExchangeSha1JCE.this.f.toString(16)});
                    }
                }
            }, true);
            this.transport.sendNewKeys();
        }
        catch (Exception e) {
            this.transport.disconnect(3, e.getMessage());
        }
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getDefaultInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        if (this.min != null) {
            hash.putInt(this.min.intValue());
        }
        hash.putInt(this.n.intValue());
        if (this.max != null) {
            hash.putInt(this.max.intValue());
        }
        hash.putBigInteger(this.p);
        hash.putBigInteger(this.g);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public void test() {
        try {
            ComponentManager.getDefaultInstance().supportedDigests().getInstance(this.getHashAlgorithm());
            this.initCrypto();
            if (minSupportedSize == -1) {
                Provider provider = JCEComponentManager.getProviderForAlgorithm((String)"DH");
                if (provider != null && provider.getName().equals("BC")) {
                    minSupportedSize = 1024;
                    maxSupportedSize = 8192;
                    if (Log.isInfoEnabled()) {
                        Log.info((String)"Using BC for DH; prime range is {} to {} bits", (Object[])new Object[]{minSupportedSize, maxSupportedSize});
                    }
                } else {
                    maxSupportedSize = -1;
                    for (BigInteger p : DiffieHellmanGroups.allDefaultGroups()) {
                        try {
                            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, TWO);
                            this.dhKeyPairGen.initialize(dhSkipParamSpec);
                            KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                            this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                            if (minSupportedSize == -1) {
                                minSupportedSize = p.bitLength();
                            }
                            maxSupportedSize = p.bitLength();
                        }
                        catch (Exception e) {}
                    }
                    if (maxSupportedSize == -1) {
                        throw new IllegalStateException("The diffie hellman algorithm does not appear to be configured correctly on this machine");
                    }
                    if (Log.isInfoEnabled()) {
                        Log.info((String)"The supported DH prime range is {} to {} bits", (Object[])new Object[]{minSupportedSize, maxSupportedSize});
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

