/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.command.ExecutableCommand;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.IdleStateListener;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.shell.ShellPolicy;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.common.ssh.SessionChannelHelper;
import com.sshtools.common.ssh.SessionChannelServer;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.Subsystem;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.Utils;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.ChannelOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SessionChannelNG
extends ChannelNG<SshServerContext>
implements IdleStateListener,
SessionChannelServer {
    public static final int SSH_EXTENDED_DATA_STDERR = 1;
    protected Subsystem subsystem;
    protected ExecutableCommand command;
    protected Map<String, String> environment = new ConcurrentHashMap<String, String>(8, 0.9f, 1);
    boolean hasTimedOut = false;
    boolean haltIncomingData = false;
    long lastActivity = System.currentTimeMillis();
    boolean agentForwardingRequested;
    boolean rawMode = false;
    boolean singleSession = false;
    ChannelOutputStream stderrOutputStream = new ChannelOutputStream((ChannelNG)this, 1);

    public SessionChannelNG(SshConnection con) {
        this(con, false);
    }

    public SessionChannelNG(SshConnection con, boolean autoConsume) {
        super("session", ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxPacketSize(), UnsignedInteger32.ZERO, ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMaxWindowSize(), ((ShellPolicy)con.getContext().getPolicy(ShellPolicy.class)).getSessionMinWindowSize(), null, autoConsume);
    }

    public boolean isSingleSession() {
        return this.singleSession;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected void onChannelClosed() {
        if (this.singleSession) {
            this.con.disconnect();
        }
    }

    public void enableRawMode() {
        this.rawMode = true;
    }

    public void disableRawMode() {
        this.rawMode = false;
    }

    public Subsystem getSubsystem() {
        return this.subsystem;
    }

    protected final byte[] createChannel() throws IOException {
        this.registerExtendedDataType(1);
        return null;
    }

    public OutputStream getErrorStream() {
        return this.stderrOutputStream;
    }

    public boolean isAgentForwardingRequested() {
        return this.agentForwardingRequested;
    }

    protected boolean requestAgentForwarding(String requestType) {
        return false;
    }

    protected abstract boolean allocatePseudoTerminal(String var1, int var2, int var3, int var4, int var5, byte[] var6);

    protected abstract void changeWindowDimensions(int var1, int var2, int var3, int var4);

    protected abstract void processSignal(String var1);

    public abstract boolean setEnvironmentVariable(String var1, String var2);

    protected abstract boolean startShell();

    protected boolean executeCommand(String[] args) {
        boolean success = false;
        try {
            this.command = ((SshServerContext)this.connection.getContext()).getChannelFactory().executeCommand((SessionChannel)this, args, this.environment);
            success = true;
        }
        catch (PermissionDeniedException | UnsupportedChannelException e) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Failed to execute command", (Throwable)e, (Object[])new Object[0]);
            }
            success = false;
        }
        return success;
    }

    protected void onChannelOpen() {
        if (((ShellPolicy)((SshServerContext)this.getContext()).getPolicy(ShellPolicy.class)).getSessionTimeout() > 0) {
            this.getConnectionProtocol().getTransport().getSocketConnection().getIdleStates().register((IdleStateListener)this);
        }
    }

    public boolean idle() {
        if (((ShellPolicy)((SshServerContext)this.getContext()).getPolicy(ShellPolicy.class)).getSessionTimeout() > 0) {
            long idleTimeSeconds = (System.currentTimeMillis() - this.lastActivity) / 1000L;
            if ((long)((ShellPolicy)((SshServerContext)this.getContext()).getPolicy(ShellPolicy.class)).getSessionTimeout() < idleTimeSeconds) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Session has timed out!", (Object[])new Object[0]);
                }
                this.hasTimedOut = true;
                this.close();
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChannelRequest(String type, boolean wantreply, byte[] requestdata) {
        boolean success = false;
        this.resetIdleState();
        try (ByteArrayReader bar = new ByteArrayReader(requestdata == null ? new byte[]{} : requestdata);){
            if (type.equals("pty-req")) {
                String term = bar.readString();
                int cols = (int)bar.readInt();
                int rows = (int)bar.readInt();
                int width = (int)bar.readInt();
                int height = (int)bar.readInt();
                byte[] modes = bar.readBinaryString();
                success = this.allocatePseudoTerminal(term, cols, rows, width, height, modes);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(term + " pseudo terminal requested"), (Object[])new Object[0]);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Terminal dimensions are " + String.valueOf(cols) + "x" + String.valueOf(rows)), (Object[])new Object[0]);
                }
            } else if (type.equals("x11-req")) {
                boolean singleConnection = bar.readBoolean();
                String protocol = bar.readString();
                String cookie = bar.readString();
                int screen = (int)bar.readInt();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (int i = 0; i < cookie.length(); i += 2) {
                    out.write(Integer.parseInt(cookie.substring(i, i + 2), 16));
                }
                success = ((SshServerContext)this.getContext()).getForwardingManager().startX11Forwarding(singleConnection, protocol, out.toByteArray(), screen, this.getConnectionProtocol());
            } else if (type.equals("env")) {
                String name = bar.readString();
                String value = bar.readString();
                this.environment.put(name, value);
                success = this.setEnvironmentVariable(name, value);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(name + "=" + value + " environment variable set"), (Object[])new Object[0]);
                }
            } else if (type.equals("shell")) {
                boolean shellSuccess = ((ShellPolicy)((SshServerContext)this.connection.getContext()).getPolicy(ShellPolicy.class)).checkPermission((SshConnection)this.getConnection(), 4096, new String[0]);
                success = shellSuccess ? this.startShell() : shellSuccess;
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777166, success).addAttribute("CONNECTION", (Object)this.getConnection()));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Shell " + (success ? "started" : "failed")), (Object[])new Object[0]);
                }
            } else if (type.equals("exec")) {
                String cmd = bar.readString();
                success = ((ShellPolicy)((SshServerContext)this.connection.getContext()).getPolicy(ShellPolicy.class)).checkPermission((SshConnection)this.getConnection(), 8192, new String[]{cmd});
                if (success) {
                    success = this.executeCommand(Utils.splitToArgsArray((String)cmd));
                }
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777165, success).addAttribute("CONNECTION", (Object)this.getConnection()).addAttribute("COMMAND", (Object)cmd));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Command " + cmd + (success ? " started" : " failed")), (Object[])new Object[0]);
                }
            } else if (type.equals("subsystem")) {
                String name = bar.readString();
                success = ((ShellPolicy)((SshServerContext)this.connection.getContext()).getPolicy(ShellPolicy.class)).checkPermission((SshConnection)this.getConnection(), 16384, new String[]{name});
                if (success) {
                    success = this.startSubsystem(name);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"{} was {}", (Object[])new Object[]{name, success ? "opened" : "not opened"});
                    }
                }
                if ("sftp".equals(name)) {
                    this.localWindow.setMaximumWindowSpace(((FileSystemPolicy)((SshServerContext)this.connection.getContext()).getPolicy(FileSystemPolicy.class)).getSftpMaxWindowSize());
                    this.localWindow.setMinimumWindowSpace(((FileSystemPolicy)((SshServerContext)this.connection.getContext()).getPolicy(FileSystemPolicy.class)).getSftpMinWindowSize());
                    this.localWindow.setMaxiumPacketSize(((FileSystemPolicy)((SshServerContext)this.connection.getContext()).getPolicy(FileSystemPolicy.class)).getSftpMaxPacketSize());
                }
                this.sendWindowAdjust();
            } else if (type.equals("window-change")) {
                int cols = (int)bar.readInt();
                int rows = (int)bar.readInt();
                int width = (int)bar.readInt();
                int height = (int)bar.readInt();
                this.changeWindowDimensions(cols, rows, width, height);
            } else if (type.equals("signal")) {
                String signal = bar.readString();
                this.processSignal(signal);
            } else if (type.equals("auth-agent-req")) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Agent forwarding requested for auth-agent", (Object[])new Object[0]);
                }
                success = this.agentForwardingRequested = this.requestAgentForwarding("auth-agent");
            } else if (type.equals("auth-agent-req@openssh.com")) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Agent forwarding requested for auth-agent@openssh.com", (Object[])new Object[0]);
                }
                success = this.agentForwardingRequested = this.requestAgentForwarding("auth-agent@openssh.com");
            }
        }
        if (success && (type.equals("exec") || type.equals("shell"))) {
            this.sendWindowAdjust();
            if (this.command == null) {
                this.resetIdleState();
                this.onSessionOpen();
            }
            if (wantreply) {
                this.sendRequestResponse(success);
            }
            if (this.command != null) {
                this.command.start();
            }
        } else if (wantreply) {
            this.sendRequestResponse(success);
        }
        if (!success && (type.equals("exec") || type.equals("shell") || type.equals("subsystem"))) {
            this.close();
        }
    }

    protected void onChannelOpenConfirmation() {
    }

    protected void onRemoteEOF() {
        this.close();
    }

    protected void onChannelFree() {
        if (this.subsystem != null) {
            this.subsystem.free();
        }
        this.subsystem = null;
        this.command = null;
    }

    protected void onChannelClosing() {
        if (((ShellPolicy)((SshServerContext)this.getContext()).getPolicy(ShellPolicy.class)).getSessionTimeout() > 0 && !this.hasTimedOut) {
            this.getConnectionProtocol().getTransport().getSocketConnection().getIdleStates().remove((IdleStateListener)this);
        }
        if (this.command != null) {
            if (this.command.getExitCode() != Integer.MIN_VALUE) {
                SessionChannelHelper.sendExitStatus((Channel)this, (int)this.command.getExitCode());
            } else {
                this.command.kill();
            }
        }
    }

    private void resetIdleState() {
        this.lastActivity = System.currentTimeMillis();
        if (((ShellPolicy)((SshServerContext)this.getContext()).getPolicy(ShellPolicy.class)).getSessionTimeout() > 0) {
            this.getConnectionProtocol().getTransport().getSocketConnection().getIdleStates().reset((IdleStateListener)this);
        }
    }

    protected final void onChannelData(ByteBuffer data) {
        this.resetIdleState();
        if (this.subsystem != null) {
            try {
                this.subsystem.processMessage(data);
            }
            catch (IOException ex) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"The channel failed to process a subsystem message", (Throwable)ex, (Object[])new Object[0]);
                }
                this.close();
            }
        } else {
            super.onChannelData(data);
        }
    }

    protected void onExtendedData(ByteBuffer data, int type) {
        this.resetIdleState();
    }

    public void sendStdoutData(byte[] data, int off, int len) throws IOException {
        this.resetIdleState();
        this.sendData(data, off, len);
    }

    public void sendStdoutData(byte[] data) throws IOException {
        this.resetIdleState();
        this.sendData(data, 0, data.length);
    }

    public void sendStderrData(byte[] data, int off, int len) throws IOException {
        this.resetIdleState();
        this.sendExtendedData(data, off, len, 1);
    }

    public void sendStderrData(byte[] data) throws IOException {
        this.sendStderrData(data, 0, data.length);
    }

    protected final byte[] openChannel(byte[] data) throws WriteOperationRequest, ChannelOpenException {
        this.registerExtendedDataType(1);
        return null;
    }

    public boolean isIncomingDataHalted() {
        return this.haltIncomingData;
    }

    public UnsignedInteger32 getMaximumWindowSpace() {
        return this.localWindow.getMaximumWindowSpace();
    }

    public UnsignedInteger32 getMinimumWindowSpace() {
        return this.localWindow.getMinimumWindowSpace();
    }

    public void onSessionOpen() {
    }

    protected boolean startSubsystem(String name) {
        boolean success = false;
        try {
            this.subsystem = ((SshServerContext)this.connection.getContext()).getChannelFactory().createSubsystem(name, (SessionChannel)this);
            success = true;
        }
        catch (PermissionDeniedException | UnsupportedChannelException e) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Failed to create instance of supported subsystem " + name), (Throwable)e, (Object[])new Object[0]);
            }
            success = false;
        }
        return success;
    }
}

