/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.components.SshKeyExchangeServer;
import com.sshtools.server.components.SshKeyExchangeServerFactory;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.jce.AbstractKeyExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class Rsa1024SHA1KeyExchange
extends SshKeyExchangeServer
implements AbstractKeyExchange {
    public static final String RSA_1024_SHA1 = "rsa1024-sha1";
    static final int SSH_MSG_KEXRSA_PUBKEY = 30;
    static final int SSH_MSG_KEXRSA_SECRET = 31;
    static final int SSH_MSG_KEXRSA_DONE = 32;
    Cipher cipher;
    SshKeyPair transientKey;
    byte[] encryptedSecret;

    public Rsa1024SHA1KeyExchange() {
        super("SHA-1", SecurityLevel.WEAK, 1000);
    }

    @Override
    public String getAlgorithm() {
        return RSA_1024_SHA1;
    }

    public void test() {
        try {
            ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
            this.initCrypto();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    void initCrypto() throws SshException, NoSuchAlgorithmException, NoSuchPaddingException {
        this.transientKey = JCEComponentManager.getInstance().generateRsaKeyPair(1024, 2);
        this.cipher = Cipher.getInstance(JCEProvider.getRSAOAEPSHA1AlgorithmName());
    }

    public void init(SshTransport<SshServerContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, final SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.prvkey = prvkey;
        this.pubkey = pubkey;
        this.firstPacketFollows = firstPacketFollows;
        this.useFirstPacket = useFirstPacket;
        this.transport = transport;
        try {
            this.initCrypto();
        }
        catch (Exception ex) {
            throw new IOException("JCE does not support " + this.getAlgorithm() + " key exchange");
        }
        transport.postMessage(new SshMessage(){

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                try {
                    buf.put((byte)30);
                    byte[] hostkey = pubkey.getEncoded();
                    buf.putInt(hostkey.length);
                    buf.put(hostkey);
                    byte[] tk = Rsa1024SHA1KeyExchange.this.transientKey.getPublicKey().getEncoded();
                    buf.putInt(tk.length);
                    buf.put(tk);
                }
                catch (SshException e) {
                    Rsa1024SHA1KeyExchange.this.transport.disconnect(3, "Could not send transient key");
                }
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_KEXRSA_PUBKEY", (Object[])new Object[0]);
                }
            }
        }, true);
    }

    public String getProvider() {
        return this.cipher.getProvider().getName();
    }

    @Override
    public boolean processMessage(byte[] msg) throws SshException, IOException {
        switch (msg[0]) {
            case 31: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_MSG_KEXRSA_SECRET", (Object[])new Object[0]);
                }
                try (ByteArrayReader bar = new ByteArrayReader(msg);){
                    bar.skip(1L);
                    this.encryptedSecret = bar.readBinaryString();
                    try {
                        this.cipher.init(2, this.transientKey.getPrivateKey().getJCEPrivateKey());
                        byte[] tmp = this.cipher.doFinal(this.encryptedSecret);
                        try (ByteArrayReader r = new ByteArrayReader(tmp);){
                            tmp = r.readBinaryString();
                            this.secret = new BigInteger(tmp);
                        }
                    }
                    catch (Throwable t) {
                        this.transport.disconnect(3, "Could not decrypt secret");
                        throw new SshException(t);
                    }
                    this.hostKey = this.pubkey.getEncoded();
                    this.calculateExchangeHash();
                    int count = 0;
                    while (true) {
                        this.signature = this.prvkey.sign(this.exchangeHash, this.pubkey.getSigningAlgorithm());
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Verifying signature output to mitigate passive SSH key compromise vulnerability", (Object[])new Object[0]);
                        }
                        if (this.pubkey.verifySignature(this.signature, this.exchangeHash)) break;
                        if (count++ >= 3) {
                            throw new SshException(61440, "Detected invalid signautre from private key!");
                        }
                        if (!Log.isDebugEnabled()) continue;
                        Log.debug((String)"Detected invalid signature output from {} implementation", (Object[])new Object[]{this.pubkey.getSigningAlgorithm()});
                    }
                    this.transport.postMessage(new SshMessage(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                            ByteArrayWriter baw = new ByteArrayWriter();
                            try {
                                buf.put((byte)32);
                                baw.writeString(Rsa1024SHA1KeyExchange.this.pubkey.getSigningAlgorithm());
                                baw.writeBinaryString(Rsa1024SHA1KeyExchange.this.signature);
                                byte[] h = baw.toByteArray();
                                buf.putInt(h.length);
                                buf.put(h);
                            }
                            catch (IOException ex) {
                                Rsa1024SHA1KeyExchange.this.transport.disconnect(3, "Could not read host key");
                            }
                            finally {
                                try {
                                    baw.close();
                                }
                                catch (IOException iOException) {}
                            }
                            return true;
                        }

                        public void messageSent(Long sequenceNo) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Sent SSH_MSG_KEXRSA_DONE", (Object[])new Object[0]);
                            }
                        }
                    }, true);
                    this.transport.sendNewKeys();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        byte[] tk = this.transientKey.getPublicKey().getEncoded();
        hash.putInt(tk.length);
        hash.putBytes(tk);
        hash.putInt(this.encryptedSecret.length);
        hash.putBytes(this.encryptedSecret);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public static class Rsa1024SHA1KeyExchangeFactory
    implements SshKeyExchangeServerFactory<Rsa1024SHA1KeyExchange> {
        public Rsa1024SHA1KeyExchange create() throws NoSuchAlgorithmException, IOException {
            return new Rsa1024SHA1KeyExchange();
        }

        public String[] getKeys() {
            return new String[]{Rsa1024SHA1KeyExchange.RSA_1024_SHA1};
        }
    }
}

